/*
	ScriptKeyEditor.h
	Popup script key editor window for Cutscene Exporter (and possibly others later)
	aml - 5-19-03
*/

#ifndef __SCRIPTKEYEDITOR_H__
#define __SCRIPTKEYEDITOR_H__

//#include "../UI/ModalDlg.h"
#include "../UI/MSWindow.h"
#include "../UI/TrackUI.h"
#include "../UI/MultiList.h"
#include "../UI/PropList.h"
#include "../PropEdit/RTFEditor.h"
#include "../PropEdit/ScriptIniParser.h"
#include "../PropEdit/PropBufGen.h"

#define SCRIPTED_KEY_NAME        "ScriptedKey"
#define KEYOBJ_KEY_NAME          "KeyObj"
#define KEYOBJ_ENABLE_KEY_NAME   "Enable"
#define KEYOBJ_DISABLE_KEY_NAME  "Disable"
#define SCRIPTKEY_VERSION 0x0001
#define SCRIPTKEY_SCRIPT    0			// Value of key's userData if a user script is defined
#define SCRIPTKEY_GENERATED 1			// Value of key's userData if information is stored to generate a script (via templates)

//class ScriptKeyEditor: public ModalDlgWindow
class ScriptKeyEditor: public MSDlgWindow, 
//                     public ScriptIniParser,
					   public PropTagParser,
					   public PropBufGen
{
	RTFEditor* editor;
	MultiList* keyClass;
	MultiList* keyType;
	PropList*  pPropList;
	TrackUI*   trackUI;
	bool       bLockTextUpdate;					// True if combo box string text update should be denied

	DWORD      saveID;							// This is the chunk ID in the MAX file that will store any
												// custom key data (as it gets updated)

	int*       timeAdjust;						// Pointer to value that should be updated when the user
												// adjusts the key time in the editor

	ICustEdit*       INameEdit;					// Edit control for adjusting name of the current key
	ICustEdit*       ITimeEdit;					// Edit control for adjusting the keytime
	ISpinnerControl* ITimeSpin;					// Attached spinner control for adjusting the keytime

	void(*TimeChangeCB)(int,void*);				// Callback executed when the user changes the key time
	void* pTimeChangeData;						// Retained data passed to the callback

	void(*UpdateCB)(ScriptKeyEditor*,void*);	// Called when an update operation should be performed on the current key
	void* pUpdateData;							// Retained data passed to the callback

	void(*CancelCB)(ScriptKeyEditor*,void*);	// Called when an update operation should be aborted
	void* pCancelData;							// Retained data passed to the callback

	void(*KeyChangeCB)(ScriptKeyEditor*,
		               Link<TrackUIKey>*,
		               void*);					// Called when the user changes the current key being edited
	void* pKeyChangeData;						// Retained data passed to the callback

	Link<TrackUIKey>* linkKey;					// Link to the key we're modifying

	BOOL DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void AddKeyClasses();
	void AddKeyTypes();
	void UpdateClassType();

	static void PropChangeCB(PropList* pPropList, void* pData);

public:
	ScriptKeyEditor(HINSTANCE hInstance, HWND hwndParent);
	~ScriptKeyEditor();

	void SetTimeAdjust(int* time);
	void SetKeyAdjust(Link<TrackUIKey>* key);
	void SetTimeChangeCB(void(*pFunc)(int,void*), void* pData);
	void SetUpdateCB(void(*pFunc)(ScriptKeyEditor*,void*),void* pData);
	void SetCancelCB(void(*pFunc)(ScriptKeyEditor*,void*),void* pData);
	void SetKeyChangeCB(void(*pFunc)(ScriptKeyEditor*,Link<TrackUIKey>*,void*),void* pData);
	void BuildKeyList(TrackUI* trackUI);
	void UpdateCurKeyText();

	void ApplyTrackKeyUserData();

	void WriteKeyData();
	void LoadKeyData();

	CStr GetScriptBuffer();
	CStr GetScriptBuffer(Link<TrackUIKey>* link);

	void Show();
};

#endif
