#ifndef __EXPORT_EXPORTOPTIONS_H__
#define __EXPORT_EXPORTOPTIONS_H__


typedef enum
{
	vQUICKVIEW_PS2,
	vQUICKVIEW_XBOX,
	vQUICKVIEW_NGC,
	vQUICKVIEW_PCVIEW,
} QuickviewPlatform;

class ExportOptions
{
public:

	// VERSION HISTORY:
	//	Version 2: Added int  m_SortGroupId
	//  Version 3: Added bool m_SceneConvOptimize   aml
	enum
	{
		vVERSION_NUMBER = 0x0003,
	};

	enum
	{
		vEXPORT_SCENE,
		vEXPORT_MODEL,
		vEXPORT_ANIM,		// Export animations  aml
		vEXPORT_SKIN,
		vEXPORT_SKELETON,	// Export skeleton data  aml
		vEXPORT_CAMERA,		// Export camera data    aml
		vEXPORT_PARTS,		// Export level editor parts  aml
		vEXPORT_OBJECT,		// Export object data  aml
		vEXPORT_CUTSCENE,	// Export cutscene data aml
	};

	ExportOptions( void );

	int		m_Version;
	int		m_ExportType;
	int		m_SortGroupId;
	bool    m_SceneConvOptimize;	// True if sceneconv should be ran with -o option  aml
};

class ExportOptionsDlg
{
public:
	void Show( void );
	void Hide( void );
	inline HWND GetHWND() { return m_wnd; }
private:
	HWND m_wnd;	
};

void SetExportOptions( ExportOptions* options );
ExportOptions* GetExportOptions( void );

void				SetQuickviewPlatform( QuickviewPlatform platform );
QuickviewPlatform	GetQuickviewPlatform( void );

bool	UseSceneConvOptimize( void );

void	DestroySceneOptionsDialog( void );
void	DestroyModelOptionsDialog( void );
void	DestroyAnimOptionsDialog( void );
void	DestroySkinOptionsDialog( void );
void	DestroySkeletonOptionsDialog( void );
//void	DestroyCameraOptionsDialog( void );


#endif // __EXPORT_EXPORTOPTIONS_H__