#include "FuncEnter.h"

/*
	CutsceneExport.cpp
	Cutscene exporter
*/

#include "CutsceneExport.h"
#include "resource.h"
#include "IUtilityPanel.h"

static CutsceneExporterClassDesc theCutsceneExporterDesc;
ClassDesc2* GetCutsceneExporterDesc() { FUNC_ENTER("GetCutsceneExporterDesc");  return &theCutsceneExporterDesc; }

extern HINSTANCE hInstance;

void OpenCutsceneExporter()
{ FUNC_ENTER("OpenCutsceneExporter"); 
	IUtilityPanel* iutil = (IUtilityPanel*)GetCOREInterface(IUTIL_FO_INTERFACE);
	
	assert(iutil);
	iutil->OpenUtility(&theCutsceneExporterDesc);
}

CutsceneExporter::CutsceneExporter()
{ FUNC_ENTER("CutsceneExporter::CutsceneExporter"); 
	ColorListBox::Register(hInstance);
}

CutsceneExporter::~CutsceneExporter()
{ FUNC_ENTER("CutsceneExporter::~CutsceneExporter"); 

}

void CutsceneExporter::BeginEditParams(Interface* ip, IUtil* iu)
{ FUNC_ENTER("CutsceneExporter::BeginEditParams"); 
	this->ip = ip;
	this->iu = iu;

	hwnd = ip->AddRollupPage(hInstance,MAKEINTRESOURCE(IDD_CUTSCENEEXPORTER),DlgProc,"Cutscene Exporter");

	objListbox = new ColorListBox(hInstance, GetDlgItem(hwnd, IDC_OBJLIST));
}

void CutsceneExporter::EndEditParams(Interface* ip, IUtil* iu)
{ FUNC_ENTER("CutsceneExporter::EndEditParams"); 
	delete objListbox;
	ip->DeleteRollupPage(hwnd);
}

void CutsceneExporter::SelectionSetChanged(Interface* ip, IUtil* iu)
{ FUNC_ENTER("CutsceneExporter::SelectionSetChanged"); 

}

BOOL CutsceneExporter::DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{ FUNC_ENTER("CutsceneExporter::DlgProc"); 

	return FALSE;
}
