/*
	AnimPreviewDlg.cpp
	2-13-03
*/

#include "../../code/core/defines.h"
#include "../../code/core/math/math.h"
#include <Engine/Engine.h>
#include <Sk/Gamenet/ExportMsg.h>
#include <process.h>
#include <io.h>
#include "../Misc/GenCrc.h"
#include "../Misc/Util.h"
#include "../Misc/MDir.h"
#include "AnimOptionsDlg.h"
#include "AnimPreviewDlg.h"
#include "NExt.h"
#include <direct.h>
#include "../path.h"
#include "AppData.h"
#include "../PropEdit/ParseFuncs.h"
#include "../UI/PropList.h"
#include "../UI/OkToAll.h"
#include "SceneExportOptions.h"
#include "ExportOptions.h"
#include "Resource.h"
#include "../PropEdit/RTFEditor.h"
//#include "phyexp.h"				// CStudio SDK  Physique Export

#define NO_PREINCLUDES
#define NO_BASEPREINCLUDES
#include "FuncEnter.h"

AnimPreviewDlg::AnimPreviewDlg(HINSTANCE hInstance,HWND hwndParent,Interface* ip, bool bSilentExport) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_ANIMPREVIEW),hwndParent)
{ FUNC_ENTER("AnimPreviewDlg::AnimPreviewDlg"); 	
	scriptEdit = new RTFEditor(hInstance,GetDlgItem(hwnd,IDC_SCRIPT_EDIT));
	scriptName = GetICustEdit( GetDlgItem( hWnd(), IDC_PREVIEW_NAME ));
	scriptName->SetText( "av_default" );
	ReleaseICustEdit( scriptName );
}

AnimPreviewDlg::~AnimPreviewDlg()
{ FUNC_ENTER("AnimPreviewDlg::~AnimPreviewDlg"); 	
	delete scriptEdit;	
}

BOOL AnimPreviewDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("AnimPreviewDlg::DlgProc"); 
	if (LOWORD(wParam)==IDC_SCRIPT_EDIT)
		if (scriptEdit->ProcMessage(hwnd,msg,wParam,lParam))
			return TRUE;

	switch(msg)
	{
		case WM_SHOWWINDOW:
			FillAnimList();
			FillDirList();
			break;
		case WM_INITDIALOG:
			break;
			
		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDCANCEL:
				case IDC_DONE:
					Hide();
					break;
				case IDC_PREVIEW_QB_SCRIPT:
					int sel;
					char file[_MAX_FNAME];
					sel = SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_GETCURSEL, 0, 0);
					if( sel != LB_ERR )
					{
						SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_GETTEXT, (WPARAM) sel, 
							(LPARAM) (LPCTSTR) file );
						RunScript( file );
					}
					break;
				case IDC_EDIT_SCRIPT:
					Edit();
					break;
				case IDC_DELETE_PREVIEW:
					Delete();
					break;
				case IDC_ADD_ANIM:
					AddAnimation();
					SendDlgItemMessage( hWnd(), IDC_PREV_ANIM_LIST, LB_SETSEL, (WPARAM) FALSE, (LPARAM) -1 );
					break;
				case IDC_PREVIEW_SCRIPT:
					Preview();
					break;
			}
			break;

			return TRUE;
		}
	}
	return FALSE;
}

void AnimPreviewDlg::AddAnimation( void )
{ FUNC_ENTER("AnimPreviewDlg::AddAnimation"); 
	CStr text;
	int sel_count, result, i;
	int selections[256];
	char anm_name[256];

	text = scriptEdit->GetText();
	sel_count = SendDlgItemMessage( hWnd(), IDC_PREV_ANIM_LIST, LB_GETSELCOUNT, 0, 0);
	if(( sel_count <= 0 ) || ( sel_count > 256 ))
	{
		return;
	}

	result = SendDlgItemMessage( hWnd(), IDC_PREV_ANIM_LIST, LB_GETSELITEMS, (WPARAM) sel_count, (LPARAM) selections );
	if( result == LB_ERR )
	{
		return;
	}

	for( i = 0; i < sel_count; i++ )
	{
		SendDlgItemMessage( hWnd(), IDC_PREV_ANIM_LIST, LB_GETTEXT, (WPARAM) selections[i], 
							(LPARAM) (LPCTSTR) anm_name );
		if(( text == CStr( "" )) || ( i > 0 ))
		{
			text += CStr( "Obj_PlayAnim anim=" ) + CStr( anm_name ) + CStr( " BlendPeriod=0.0\n" );
			text += CStr( "WaitAnimFinished\n" );
		}
		else
		{
			text += CStr( "\nObj_PlayAnim anim=" ) + CStr( anm_name ) + CStr( " BlendPeriod=0.0\n" );
			text += CStr( "WaitAnimFinished\n" );
		}
	}
	scriptEdit->SetText( text );
}

void AnimPreviewDlg::Preview( void )
{ FUNC_ENTER("AnimPreviewDlg::Preview"); 
	char dir[_MAX_PATH];
	char filepath[_MAX_PATH];
	char filename[_MAX_FNAME];
	char* proj_root;
	CStr script;
	char qcomp_path[_MAX_PATH];	
	char *args[3];

	scriptName = GetICustEdit( GetDlgItem( hWnd(), IDC_PREVIEW_NAME ));
	scriptName->GetText( filename, _MAX_FNAME );
	if( strstr( filename, "av_" ) == NULL )
	{
		char copy[_MAX_FNAME];

		strcpy( copy, filename );
		sprintf( filename, "av_%s", copy );
	}
	ReleaseICustEdit( scriptName );

	if( filename[0] == '\0' )
	{
		MessageBoxAll( hWnd(), "You must first enter a filename.", "Unnamed Script", MB_OK );
		return;
	}
	
	proj_root = getenv( APP_ENV );
	if( proj_root == NULL )
	{
		MessageBoxAll( hWnd(), "Your PROJ_ROOT environment variable must first be defined.", "Environment Variable", MB_OK );
		return;
	}
	
	sprintf( dir, "%s\\data\\scripts\\animview", proj_root );
	MDir( dir );
	sprintf( filepath, "%s\\%s.qn", dir, filename );	
	fpExport = fopen( filepath, "w" );
	if( !fpExport )
	{
		char err[256];

		sprintf( err, "Could not open the file %s for writing. Check it out or make it writable", filepath );
		MessageBoxAll( hWnd(), err, "Read-Only Error", MB_OK );
		return;
	}

	script = scriptEdit->GetText();
	script = ReplaceStr( script,"\r\n","\n");

	fprintf( fpExport, "script %s\n", filename );
	fprintf( fpExport, "begin\n" );
	fprintf( fpExport, script.data());
	fprintf( fpExport, "\nWaitAnimFinished\n" );
	fprintf( fpExport, "repeat\n" );
	fprintf( fpExport, "endscript\n" );
	fclose( fpExport );

	sprintf( qcomp_path, "%s%s\\qcomp.exe", proj_root, QCOMP_PATH );
	args[0] = qcomp_path;
	args[1] = filepath;
	args[2] = NULL;

	ExecuteCommand( args );
	RunScript( filename );

	if( !AlreadyInList( filename ))
	{
		SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_ADDSTRING, 0, (LPARAM)filename);
	}
}

void AnimPreviewDlg::RunScript( char* anm_name )
{ FUNC_ENTER("AnimPreviewDlg::RunScript"); 
	Net::MsgDesc msgdesc;
	char rel_script_path[_MAX_PATH];

	sprintf( rel_script_path, "%s", anm_name );
	msgdesc.m_Id     = Net::vMSG_ID_VIEWOBJ_PREVIEW_SEQUENCE;
	msgdesc.m_Length = strlen( rel_script_path ) + 1;
	msgdesc.m_Data   = rel_script_path;

	gClient->EnqueueMessageToServer( &msgdesc );
}

void AnimPreviewDlg::Delete( void )
{ FUNC_ENTER("AnimPreviewDlg::Delete"); 
	int sel;
	char file[_MAX_FNAME];
	char file_path[_MAX_PATH];
	char* proj_root;

	sel = SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_GETCURSEL, 0, 0);
	if( sel == LB_ERR )
	{
		return;
	}

	SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_GETTEXT, (WPARAM) sel, 
							(LPARAM) (LPCTSTR) file );
	
	// Set the filename edit box at the top of the dialog
	scriptName = GetICustEdit( GetDlgItem( hWnd(), IDC_PREVIEW_NAME ));
	scriptName->SetText( file );
	ReleaseICustEdit( scriptName );

	proj_root = getenv( APP_ENV );
	if( proj_root == NULL )
	{
		MessageBoxAll( hWnd(), "Your PROJ_ROOT environment variable must first be defined.", "Environment Variable", MB_OK );
		return;
	}

	sprintf( file_path, "%s\\data\\scripts\\animview\\%s.qn", proj_root, file );
	DeleteFile( file_path );
	sprintf( file_path, "%s\\data\\scripts\\animview\\%s.qb", proj_root, file );
	DeleteFile( file_path );
	SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_DELETESTRING, sel, 0);

}

void AnimPreviewDlg::Edit( void )
{ FUNC_ENTER("AnimPreviewDlg::Edit"); 
	int sel;
	fpos_t end_pos;
	char file[_MAX_FNAME];
	char file_path[_MAX_PATH];
	char script_buf[10000];
	char* proj_root, *start_ptr, *end_ptr;

	sel = SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_GETCURSEL, 0, 0);
	if( sel == LB_ERR )
	{
		return;
	}

	SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_GETTEXT, (WPARAM) sel, 
							(LPARAM) (LPCTSTR) file );
	
	// Set the filename edit box at the top of the dialog
	scriptName = GetICustEdit( GetDlgItem( hWnd(), IDC_PREVIEW_NAME ));
	scriptName->SetText( file );
	ReleaseICustEdit( scriptName );

	proj_root = getenv( APP_ENV );
	if( proj_root == NULL )
	{
		MessageBoxAll( hWnd(), "Your PROJ_ROOT environment variable must first be defined.", "Environment Variable", MB_OK );
		return;
	}

	sprintf( file_path, "%s\\data\\scripts\\animview\\%s.qn", proj_root, file );
	fpExport = fopen( file_path, "r" );
	if( !fpExport )
	{
		char err_msg[256];

		sprintf( err_msg, "Could not open script %s\n", file_path );
		MessageBoxAll( hWnd(), err_msg, "File Error", MB_OK );
		return;
	}

	memset( script_buf, 0, 10000 );
	
	fseek( fpExport, 0, SEEK_END );
	fgetpos( fpExport, &end_pos );
	fseek( fpExport, 0, SEEK_SET );
	
	fread( script_buf, sizeof( char ), ( end_pos > 9999 ) ? 9999 : end_pos, fpExport );
	start_ptr = strstr( script_buf, "begin" );
	if( start_ptr == NULL )
	{
		return;
	}
	start_ptr += strlen( "begin\n" );

	end_ptr = strstr( script_buf, "endscript" );
	if( end_ptr == NULL )
	{
		return;
	}
	end_ptr -= strlen( "\nWaitAnimFinished\nrepeat\n" );
	*end_ptr = '\0';

	scriptEdit->SetText( start_ptr );

	fclose( fpExport );
}

void AnimPreviewDlg::FillDirList( void )
{ FUNC_ENTER("AnimPreviewDlg::FillDirList"); 
	_finddata_t fileinfo;
	char* proj_root;
	char search_mask[_MAX_PATH];
	char filename[_MAX_FNAME];
	long fhandle;
	char* search;
	
	SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_RESETCONTENT, 0, 0);

	proj_root = getenv( APP_ENV );
	if( proj_root == NULL )
	{
		MessageBoxAll( hWnd(), "Your PROJ_ROOT environment variable must first be defined.", "Environment Variable", MB_OK );
		return;
	}

	sprintf( search_mask, "%s\\data\\scripts\\animview\\*.qn", proj_root );
	fhandle = _findfirst( search_mask, &fileinfo );
	if( fhandle == -1 )
	{
		// No matching files found
		return;
	}

	strcpy( filename, fileinfo.name );
	search = strstr( filename, "." );
	if( search )
	{
		*search = '\0';
	}
	SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_ADDSTRING, 0, (LPARAM)filename);

	while(_findnext(fhandle,&fileinfo)==0)
	{
		strcpy( filename, fileinfo.name );
		search = strstr( filename, "." );
		if( search )
		{
			*search = '\0';
		}
		SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_ADDSTRING, 0, (LPARAM)filename);	
	}

	_findclose(fhandle);	
}

bool AnimPreviewDlg::AlreadyInList( char* anm_name )
{ FUNC_ENTER("AnimPreviewDlg::AlreadyInList"); 
	int result;
	result = SendDlgItemMessage( hWnd(), IDC_ANIM_LIST, LB_FINDSTRINGEXACT, 0, (LPARAM)anm_name);	
	return ( result != LB_ERR );
}

void AnimPreviewDlg::FillAnimList( void )
{ FUNC_ENTER("AnimPreviewDlg::FillAnimList"); 
	char* proj_root;
	char* script_buf;
	char file_path[_MAX_PATH];
	fpos_t end_pos;
	char* anim_search, *end_marker;

	SendDlgItemMessage( hWnd(), IDC_PREV_ANIM_LIST, LB_RESETCONTENT, 0, 0 );

	proj_root = getenv( APP_ENV );
	if( proj_root == NULL )
	{
		MessageBoxAll( hWnd(), "Your PROJ_ROOT environment variable must first be defined.", "Environment Variable", MB_OK );
		return;
	}

	sprintf( file_path, "%s\\data\\scripts\\allanims.qn", proj_root );
	fpExport = fopen( file_path, "r" );
	if( !fpExport )
	{
		char err_msg[256];

		sprintf( err_msg, "Could not open script %s\n", file_path );
		MessageBoxAll( hWnd(), err_msg, "File Error", MB_OK );
		return;
	}

	script_buf = new char[500 * 1024];
	memset( script_buf, 0, 500 * 1024 );
	
	fseek( fpExport, 0, SEEK_END );
	fgetpos( fpExport, &end_pos );
	fseek( fpExport, 0, SEEK_SET );
	
	fread( script_buf, sizeof( char ), ( end_pos > ( 500 * 1024 )) ? ( 500 * 1024 ): end_pos, fpExport );

	anim_search = strstr( script_buf, "script animload_THPS5_human" );
	if( anim_search == NULL )
	{
		delete [] script_buf;
		fclose( fpExport );
		return;
	}
	end_marker = strstr( anim_search, "endscript" );
	if( end_marker == NULL )
	{
		delete [] script_buf;
		fclose( fpExport );
		return;
	}

	*end_marker = '\0';
	anim_search = strstr( anim_search, "descChecksum" );
	while( anim_search )
	{
		anim_search += strlen( "descChecksum=" );
		end_marker = strstr( anim_search, "\n" );
		if( end_marker == NULL )
		{
			delete [] script_buf;
			fclose( fpExport );
			return;
		}
		*end_marker = '\0';
		
		SendDlgItemMessage( hWnd(), IDC_PREV_ANIM_LIST, LB_ADDSTRING, 0, (LPARAM) anim_search );
		anim_search = end_marker + 1;
		anim_search = strstr( anim_search, "descChecksum" );
	}
}