/*
	NExtGlobals.cpp
	Neversoft global identifiers accessible to MAXScript
	4-17-01  aml
*/

#include "MAXScrpt/MAXScrpt.h"
#include "MAXScrpt/numbers.h"
#include "NExtGlobals.h"
#include "../NExt/UI/PropList.h"

Value* GetSkatable()           {   return new Integer(NSF_SKATABLE);              }
Value* GetNotSkatable()        {   return new Integer(NSF_NOT_SKATABLE);          }
Value* GetWallRidable()        {   return new Integer(NSF_WALL_RIDABLE);          }
Value* GetVert()               {   return new Integer(NSF_VERT);                  }
Value* GetNonCollidable()      {   return new Integer(NSF_NON_COLLIDABLE);        }
Value* GetDecal()              {   return new Integer(NSF_DECAL);                 }
Value* GetTrigger()            {   return new Integer(NSF_TRIGGER);               }
Value* GetCameraCollidable()   {   return new Integer(NSF_CAMERA_COLLIDABLE);     }
Value* GetNoSkaterShadow()     {   return new Integer(NSF_NO_SKATER_SHADOW);      }
Value* GetSkaterShadow()       {   return new Integer(NSF_SKATER_SHADOW);         }
Value* GetNoSkaterShadowWall() {   return new Integer(NSF_NO_SKATER_SHADOW_WALL); }
Value* GetUnderOK()            {   return new Integer(NSF_UNDER_OK);              }
Value* GetInvisible()          {   return new Integer(NSF_INVISIBLE);             }

Value* GetPUndefined()        {   return new Integer(PROPTYPE_UNDEFINED);         }
Value* GetPEdit()             {   return new Integer(PROPTYPE_EDIT);			  }
Value* GetPList()             {   return new Integer(PROPTYPE_LIST);              }
Value* GetPExtList()          {   return new Integer(PROPTYPE_EXTLIST);           }
Value* GetPSlider()           {   return new Integer(PROPTYPE_SLIDER);            }
Value* GetPScript()           {   return new Integer(PROPTYPE_SCRIPT);            }
Value* GetPFile()             {   return new Integer(PROPTYPE_FILE);              }
Value* GetPColor()            {   return new Integer(PROPTYPE_COLOR);             }
Value* GetPCheck()            {   return new Integer(PROPTYPE_CHECK);             }
Value* GetPSpinEdit()         {   return new Integer(PROPTYPE_SPINEDIT);          }
Value* GetPStatic()           {   return new Integer(PROPTYPE_STATIC);            }
Value* GetPSliderNum()        {   return new Integer(PROPTYPE_SLIDERNUM);         }
Value* GetPNode()             {   return new Integer(PROPTYPE_NODE);              }
Value* GetPMulti()            {   return new Integer(PROPTYPE_MULTI);             }
Value* GetPFlags()            {   return new Integer(PROPTYPE_FLAGS);             }
Value* GetPMtl()              {   return new Integer(PROPTYPE_MTL);               }
Value* GetPColorPopup()       {   return new Integer(PROPTYPE_COLORPOPUP);        }

void RegisterGlobals()
{
	define_system_global("NSF_SKATABLE",GetSkatable,NULL);
	define_system_global("NSF_NOT_SKATABLE",GetNotSkatable,NULL);
	define_system_global("NSF_WALL_RIDABLE",GetWallRidable,NULL);
	define_system_global("NSF_VERT",GetVert,NULL);
	define_system_global("NSF_NON_COLLIDABLE",GetNonCollidable,NULL);
	define_system_global("NSF_DECAL",GetDecal,NULL);
	define_system_global("NSF_TRIGGER",GetTrigger,NULL);
	define_system_global("NSF_CAMERA_COLLIDABLE",GetCameraCollidable,NULL);
	define_system_global("NSF_NO_SKATER_SHADOW",GetNoSkaterShadow,NULL);
	define_system_global("NSF_SKATER_SHADOW",GetSkaterShadow,NULL);
	define_system_global("NSF_NO_SKATER_SHADOW_WALL",GetNoSkaterShadowWall,NULL);
	define_system_global("NSF_UNDER_OK",GetUnderOK,NULL);
	define_system_global("NSF_INVISIBLE",GetInvisible,NULL);

	define_system_global("NSPT_UNDEFINED",GetPUndefined,NULL);
	define_system_global("NSPT_EDIT",GetPEdit,NULL);
	define_system_global("NSPT_LIST",GetPList,NULL);
	define_system_global("NSPT_EXTLIST",GetPExtList,NULL);
	define_system_global("NSPT_SLIDER",GetPSlider,NULL);
	define_system_global("NSPT_SCRIPT",GetPScript,NULL);
	define_system_global("NSPT_FILE",GetPFile,NULL);
	define_system_global("NSPT_COLOR",GetPColor,NULL);
	define_system_global("NSPT_CHECK",GetPCheck,NULL);
	define_system_global("NSPT_SPINEDIT",GetPSpinEdit,NULL);
	define_system_global("NSPT_STATIC",GetPStatic,NULL);
	define_system_global("NSPT_SLIDERNUM",GetPSliderNum,NULL);
	define_system_global("NSPT_NODE",GetPNode,NULL);
	define_system_global("NSPT_MULTI",GetPMulti,NULL);
	define_system_global("NSPT_FLAGS",GetPFlags,NULL);
	define_system_global("NSPT_MTL",GetPMtl,NULL);
	define_system_global("NSPT_COLORPOPUP",GetPColorPopup,NULL);
}
