/*
	DllMain.cpp
	Neversoft MAXScript Extensions
	4-17-01 aml
*/

#include "MAXScrpt/MAXScrpt.h"
#include "NExtGlobals.h"

HINSTANCE ghInstance;
HINSTANCE hInstance;

CRITICAL_SECTION  gCriticalSection;
int refCount=0;

extern HANDLE ghMemSize;
extern int*   gpMemSize;
extern HANDLE ghMemBuf;
extern char*  gpMemBuf;
extern HANDLE ghMemStdSize;
extern int*   gpMemStdSize;
extern HANDLE ghMemStdBuf;
extern char*  gpMemStdBuf;


// Close any open memory mapped files so the space taken up in the paging file is freed
void FreeMemoryMaps()
{
	if (gpMemSize)
		UnmapViewOfFile(gpMemSize);

	if (ghMemSize)
		CloseHandle(ghMemSize);

	if (gpMemBuf)
		UnmapViewOfFile(gpMemBuf);

	if (ghMemBuf)
		CloseHandle(ghMemBuf);

	if (gpMemStdSize)
		UnmapViewOfFile(gpMemStdSize);

	if (ghMemStdSize)
		CloseHandle(ghMemStdSize);

	if (gpMemStdBuf)
		UnmapViewOfFile(gpMemStdBuf);

	if (ghMemStdBuf)
		CloseHandle(ghMemStdBuf);
}

BOOL WINAPI DllMain(HINSTANCE hInstance,DWORD dwReason,LPVOID rsvd)
{
	switch(dwReason)
	{
	case DLL_PROCESS_ATTACH:
		refCount++;
		if (refCount==1)
			InitializeCriticalSection(&gCriticalSection);

		::hInstance = hInstance;
		ghInstance = hInstance;
		break;

	case DLL_PROCESS_DETACH:
		refCount--;
		if (refCount==0)
		{
			FreeMemoryMaps();
			DeleteCriticalSection(&gCriticalSection);
		}

	}

	return TRUE;
}

__declspec(dllexport) void LibInit()
{
	RegisterGlobals();
}

__declspec(dllexport) const TCHAR* LibDescription()
{
	return _T("NeverSoft MAXScript Extensions");
}

__declspec(dllexport) ULONG LibVersion()
{
	return VERSION_3DSMAX;
}
