/*
	ToolTip.h
	Adam Lippmann
	12-11-01
*/

#ifndef __TOOLTIP__
#define __TOOLTIP__

#include <windows.h>

class ToolTip
{
	WNDCLASS  wndClass;		// Window class specifying our own tooltip window
	HWND      hwnd;			// Window for the last active tooltip
	HWND      hwndTxt;		// Child window containing the text of the tooltip
	HINSTANCE hInstance;	// Application hInstance
	HBRUSH    hBrush;		// Brush used to paint window background
	RECT      rect;			// The computed tooltip dimensions
	HFONT     hFont;		// The font that the tooltip uses

	static LRESULT CALLBACK WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	char*     text;			// Text message

public:
	ToolTip(HINSTANCE hInstance);
	~ToolTip();

	void CreateTip(char* str,int x,int y,int width=170,int height=30);
	void Close();
	BOOL IsClosed();
};

#endif
