/*
	ProgressBar.cpp
	A window that displays a progress bar

	Adam Lippmann
	12-13-01
*/

#include "ProgressBar.h"

ProgressBar::ProgressBar(HINSTANCE hInstance,HWND hwndOwner,char* Caption,int min,int max,int val)
{
	this->hInstance=hInstance;
	this->min=min;
	this->max=max;
	this->val=val;

	bCancel=false;

	hwnd=CreateDialog(hInstance,MAKEINTRESOURCE(IDD_PROGRESS),hwndOwner,RedirectDlgProc);
	SetWindowLong(hwnd,GWL_USERDATA,(LONG)this);
	ShowWindow(hwnd,SW_SHOW);
	SetWindowPos(hwnd,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);

	hwndBar=GetDlgItem(hwnd,IDC_PROGRESS1);
	hwndText=GetDlgItem(hwnd,IDC_PROGTEXT);

	SetDlgItemText(hwnd,IDC_PROGTEXT,Caption);
	SendMessage(hwndBar,PBM_SETRANGE,0,MAKELPARAM(0,100));
	SendMessage(hwndBar,PBM_SETPOS,val,0);
}

ProgressBar::~ProgressBar()
{
	DestroyWindow(hwnd);
}

void ProgressBar::SetCaption(char* Caption)
{
	SetDlgItemText(hwnd,IDC_PROGTEXT,Caption);
}

void ProgressBar::SetVal(int val)
{
	this->val=val;
	int pval=val*100/(max-min);
	SendMessage(hwndBar,PBM_SETPOS,pval,0);
	InvalidateRect(hwndBar,NULL,TRUE);
}

BOOL CALLBACK ProgressBar::RedirectDlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	ProgressBar* thisclass=(ProgressBar*)GetWindowLong(hwnd,GWL_USERDATA);
	return thisclass->DlgProc(hwnd,msg,wParam,lParam);
}

BOOL ProgressBar::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		return TRUE;

	case WM_CLOSE:
		ShowWindow(hwnd,SW_HIDE);
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_CANCEL:
			bCancel=true;
			if (fpCancel)
				fpCancel(pCancelData);
		}
	};

	// for future expansion

	return FALSE;
}

BOOL ProgressBar::Update()
{
	MSG msg;
	
	if (PeekMessage(&msg,GetDlgItem(hwnd,IDC_CANCEL),0,0,PM_REMOVE))
	{
		if (msg.message==WM_LBUTTONDOWN)
		{
			bCancel=true;
			return TRUE;
		}
	}
		//return DlgProc(msg.hwnd,msg.message,msg.wParam,msg.lParam);

	return FALSE;
}

void ProgressBar::SetCancelCB(void(*Func)(void*),void* pData)
{
	fpCancel=Func;
	pCancelData=pData;
	ShowWindow(GetDlgItem(hwnd,IDC_CANCEL),SW_SHOW);
}

void ProgressBar::AllowCancel(BOOL bVal)
{
	if (bVal)
		ShowWindow(GetDlgItem(hwnd,IDC_CANCEL),SW_SHOW);
	else
		ShowWindow(GetDlgItem(hwnd,IDC_CANCEL),SW_HIDE);
}
