/*
	ColorListBox.h
	A list box control that supports colored entries
	aml 4-24-01
*/

#ifndef __COLORLISTBOX__
#define __COLORLISTBOX__

#include <windows.h>

#define LB_SETITEMCOLOR   WM_USER + 1	// This message sets an item in the lists color
										// wParam = index lParam = COLORREF

class ColorListBox
{
	HWND      hwnd;				// The window we're attached to (parent of the listbox)
	HWND      hwndLB;			// Handle to the internal owner-drawn listbox class 
	HINSTANCE hInstance;		// The application's hInstance
	HFONT     hFont;			// The font that the listbox uses

	static LRESULT CALLBACK WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void BuildUI(DWORD flags=0);

public:
	ColorListBox(HINSTANCE hInstance);
	ColorListBox(HINSTANCE hInstance, HWND hwnd, DWORD flags=0);
	~ColorListBox();

	void  Attach(HWND hwnd,DWORD flags=0);
	void  SetStyle(DWORD flags=0);
	void  Clear();
	int   AddItem(char* str,COLORREF color=0,DWORD data=0);
	void  RemoveItem(int index);
	void  UnSelItem(int index);
	void  SelItem(int index);
	int   GetCount();
	
	DWORD GetItemData(int index);
	void  SetItemData(int index,DWORD val);
	
	void  GetItem(int index,int len,char* val);

	static void Register(HINSTANCE hInstance);
	static void UnRegister(HINSTANCE hInstance);
};

#endif
