/*
	ScreenFX.h
	Front-Facing Poly Effect Object
	The object still maintains its data in the PE's property format and also thus uses the script exporter
	in its current state.  This way property dependancies for these objects can still be managed with all the
	PEs features.  This code is responsible for setting up a single screen FX instance, but the individual instance
	may be modifiable thru ScreenFX or the property editor for individual (or multi prop modifications at a time accross objects)
	7-16-01
*/

#ifndef __SCREENFX__
#define __SCREENFX__

#include "max.h"
#include "istdplug.h"
#include "iparamb2.h"
#include "iparamm2.h"

#define vSCREENFXOBJ_CLASS_ID  Class_ID(0x2ac43198, 0xbea7d77)
#define PBLOCK_REF             0

class ScreenFXObj: public GeomObject
{
public:
	Mesh         mesh;
	IObjParam    *ip;
	IParamBlock2 *pblock;
	ULONG        nodeHandle;

	ScreenFXObj();
	~ScreenFXObj();

	TCHAR*		GetObjectName() { return _T("ScreenFXObj"); }
	void		DeleteThis() { delete this; }
	Class_ID	ClassID() { return vSCREENFXOBJ_CLASS_ID; }
	void		GetClassName(TSTR& s) { s = _T("ScreenFXObj"); }
	void        InitNodeName(TSTR& s) { s = _T("ScreenFXObj"); }
	
	void        RefAdded(RefMakerHandle rm);

	RefTargetHandle Clone(RemapDir &remap);
	RefResult NotifyRefChanged(Interval        changeInt,
		                       RefTargetHandle hTarget,
							   PartID&         partID,
							   RefMessage      message)  {  return REF_SUCCEED; }

	int NumRefs() { return 1; }
	RefTargetHandle GetReference(int i) { return pblock; }
	
	void SetReference(int i, RefTargetHandle rtarg)
	{
		pblock = (IParamBlock2*)rtarg;
	}

	// Make pblock public
	int NumParamBlocks() { return 1; }
	IParamBlock2* GetParamBlock(int i) { return pblock; }
	IParamBlock2* GetParamBlockByID(BlockID id)
	{
		if (pblock->ID() == id)
			return pblock;

		return NULL;
	}

	CreateMouseCallBack* GetCreateMouseCallBack();

	void BeginEditParams(IObjParam *ip, ULONG flags, Animatable* prev);
	void EndEditParams(IObjParam *ip, ULONG flags, Animatable* next);

	void BuildMesh(TimeValue t);
	void FreeCaches();

	// Obj Space
	void GetLocalBoundBox(TimeValue t, INode* node, ViewExp *vpt, Box3 &box);

	// World Space
	void GetWorldBoundBox(TimeValue t, INode* node, ViewExp *vpt, Box3 &box);

	int  Display(TimeValue t,INode *node, ViewExp *vpt, int flags);

	int HitTest(TimeValue t,
		        INode     *node,
				int       type,
				int       crossing,
				int       flags,
				IPoint2   *p,
				ViewExp   *vpt);

	ObjectState Eval(TimeValue t);

	// Screen FX objects can convert themselves to triObjects in representation of a quad
	int CanConvertToType(Class_ID obtype);
	Object* ConvertToType(TimeValue t, Class_ID obtype);
};

class ScreenFXObjClassDesc : public ClassDesc2
{
public:
	int 	     IsPublic(void) 			{ return TRUE; }
	void*        Create(BOOL loading=FALSE) { return new ScreenFXObj; }
	const TCHAR* ClassName(void)		    { return "ScreenFXObj"; }
	SClass_ID    SuperClassID(void)		    { return GEOMOBJECT_CLASS_ID; }
	Class_ID     ClassID(void)				{ return vSCREENFXOBJ_CLASS_ID; }
	const TCHAR* Category(void)		        { return "NExt Helpers"; }

	const TCHAR* InternalName()             { return _T("ScreenFXObj"); }
	HINSTANCE    HInstance()                { return hInstance; }
};


#endif
