/*
	RailTool.h
	SRTL  Super-Rail Layout Tool
*/

#ifndef __RAILTOOL__
#define __RAILTOOL__

#include "max.h"
#include "iparamb2.h"
#include "utilapi.h"

#define vRAILTOOL_CLASS_ID   Class_ID(0x66e05e9e, 0x60712e00)

ClassDesc2* GetRailToolDesc();

class RT_ActionCB : public ActionCallback {
public:
	BOOL ExecuteAction(int id);
};

class RailTool: public UtilityObj
{
	Interface* ip;				// MAX Interface pointer
	IUtil*     iu;				// Utility object interface pointer

public:
	RailTool();
	~RailTool();

	void BeginEditParams(Interface *ip,IUtil *iu);
	void EndEditParams(Interface *ip,IUtil *iu);
	void SelectionSetChanged(Interface *ip,IUtil *iu);
	void DeleteThis() { delete this; }
	void SetStartupParam(TSTR param) {}
};

class RailToolClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new RailTool(); }
	const TCHAR *	ClassName() {return _T("NeverSoft Super Rail Layout Tool"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return vRAILTOOL_CLASS_ID;}
	const TCHAR* 	Category() {return _T("RailTool");}
	const TCHAR*	InternalName() { return _T("RailTool"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }			// returns owning module handle	

	//int           NumActionTables()     { return 1; }
	//ActionTable*  GetActionTable(int i) { return GetTestActions(); }
};

#endif
