/*
	PropCompareDlg.cpp
	Property Comparison Popup Dialog
	1-22-01
*/

#include "PropCompareDlg.h"
#include "Resource.h"

PropCompareDlg::PropCompareDlg(HINSTANCE hInstance,HWND hwndParent,int x,int y) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_PROPCOMPARE),hwndParent)
{
	this->x=x;
	this->y=y;
	
	pPropList=NULL;
	index=0;

	lview=new ListView(GetDlgItem(hwnd,IDC_COMPARELIST));
	lview->AddColumn("Node");
	lview->AddColumn("Value");
}

PropCompareDlg::~PropCompareDlg()
{
	if (lview)
		delete lview;
}

void PropCompareDlg::Attach(PropList* pPropList,int index)
{
	this->pPropList=pPropList;
	this->index=index;
}

void PropCompareDlg::Clear()
{
	lview->Clear();
}

void PropCompareDlg::AddConflict(char* nodeName,char* propValue)
{
	int index=lview->AddItem(nodeName);
	lview->AddSubItem(propValue);
}

void PropCompareDlg::Move(int x,int y)
{
	RECT winRect;
	GetWindowRect(hwnd,&winRect);

	if (x==-1)
		x=this->x;

	if (y==-1)
		y=this->y;

	SetWindowPos(hwnd,
		         HWND_TOPMOST,
		         x,y,
				 winRect.right-winRect.left,
				 winRect.bottom-winRect.top,
				 SWP_SHOWWINDOW);

	/*
	MoveWindow(hwnd,
		       x,y,
			   winRect.right-winRect.left,
			   winRect.bottom-winRect.top,
			   TRUE);
	*/
}

BOOL PropCompareDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	NMHDR* nmhdr;

	switch(msg)
	{
	case WM_ACTIVATE:
		if (LOWORD(wParam)==WA_INACTIVE)
			EnableAccelerators();
		else
			DisableAccelerators();
		
		return TRUE;

	case WM_NOTIFY:
		nmhdr=(LPNMHDR)lParam;

		switch(nmhdr->code)
		{
		case LVN_ITEMCHANGED:
			UpdateSel((LPNMLISTVIEW)lParam);
			return TRUE;
		}

		return FALSE;

	case WM_COMMAND:
	case WM_CLOSE:
		Hide();
		return TRUE;
	}

	return FALSE;
}

void PropCompareDlg::UpdateSel(LPNMLISTVIEW item)
{
	if (item->uNewState & LVIS_SELECTED)
	{
		if (pPropList)
		{
			char buf[256];
			lview->GetItem(item->iItem,buf,256,1);
			pPropList->SetValue(index,buf);
		}
	}
}
