/*
	ParseFuncs.h
	Helper parsing functions for PropEdit
	12-19-01
*/

#ifndef __PARSEFUNCS__
#define __PARSEFUNCS__

#include "max.h"
#include "strclass.h"

int  GetDelimPos(char* str,int pos,char delim);
CStr InsertEscape(char* str,int index,char delim,char escape);
CStr InsertEscapes(char* str,char delim,char escape);

void StripToken(char* token);
bool GetToken(char* lineBuf,int* pos,char* token,char* tokenstr=0);
CStr BuildAutoDuckString(FILE* fp,int filepos);
CStr BuildAutoDuckString(char* buf);

CStr GetWordToken(FILE* fp,char* lineBuf,int* pos,bool bAdvance=TRUE);
bool FileAdvance(FILE* fp,char* lineBuf,int* pos,char delim);
CStr GetRemainLine(char* lineBuf,int* pos);
CStr GetRemainLinePartial(char* lineBuf,int* pos);
CStr GetRemainLineExact(char* lineBuf,int* pos);

bool AdvanceNextLine(char* lineBuf,int* pos);
bool IsAlpha(char* buf);
bool IsAlphaNum(char* buf);
bool HasAlpha(char* buf);
bool HasNum(char* buf);
bool HasAlphaNum(char* buf);
bool IsInstr(char* src,char* search,int start=0);
int  Instr(char* src,char* search,int start=0);
int  RInstr(char* src,char* search,int start=0);
int  CountChar(char* str,char chr);
bool IsBlank(char* str);
void BlankGroup(char* str,char delim);
int  NumWords(char* str);
CStr MakeAlphaNum(char* str);
CStr MakeAlphaNumS(char* str);

CStr Left(CStr src,int num);
CStr Right(CStr src,int num);
CStr ReplaceStr(CStr src,CStr search,CStr replace);
CStr StripLeft(char* src);
CStr StripRight(char* src);
bool HasData(CStr buf);
bool LineContainsAll(char* line,char chr);

// Nesting functions
int GetNestStart(char* str,int* pos);
CStr GetGroup(CStr src,int* pos);
CStr OneLineConvert(CStr src);

CStr GetPropVal(CStr src,CStr str);
CStr Shave(CStr line);

void TermLine(CStr& str);

CStr ExtractFile(CStr str);
void GetOption(char* src,char* out,char delim,int optnum);

#endif
