/*
	ParseFuncs.cpp
	Helper parsing functions
	(Moved from PropEdit)
	12-19-01
*/

#include "ParseFuncs.h"

int GetDelimPos(char* str,int pos,char delim)
{
	int  slen=strlen(str);

	for(int i=pos;i<slen;i++)
		if (str[i]==delim)
			return i;

	return -1;
}

CStr InsertEscape(char* str,int index,char delim,char escape)
{
	char buffer[512];
	int  len=strlen(str);
	int  bufpos=0;

	if (index>-1)
	{
		for(int i=0;i<len;i++)
		{
			if (i==index)
				buffer[bufpos++]=escape;

			buffer[bufpos++]=str[i];
		}
	}

	buffer[bufpos]='\0';

	return CStr(buffer);
}

CStr InsertEscapes(char* str,char delim,char escape)
{
	CStr strParsed=str;
	int  pos=0;

	while(pos<strParsed.Length())
	{
		pos=GetDelimPos(strParsed,pos,delim);
		if (pos==-1)
			return strParsed;

		strParsed=InsertEscape(strParsed,pos,delim,escape);
		pos+=2;
	} 

	return strParsed;
}

///////////////////////////////

void StripToken(char* token)
{
	char tmpToken[1024]="";
	int  len=strlen(token);
	int  start,end;
	int  pos=0;

	if (len<2)
	{
		if (token[0] == 10 ||
			token[0] == 13 ||
			token[0] == 32)
			token[0] = 0;

		return;
	}

	// Clear leading spaces
	for(start=0;start<len;start++)
	{
		if (token[start]!=' ' &&
			token[start]!=10  &&
			token[start]!=13)
			break;
	}

	// Clear trailing spaces
	for(end=len-1;end>start;end--)
	{
		if (token[end]!=' ' &&
			token[end]!=10  &&
			token[end]!=13)
			break;
	}

	// Copy string contents into temporary buffer
	for(int i=start;i<=end;i++)
		tmpToken[pos++]=token[i];

	tmpToken[pos]='\0';
	strcpy(token,tmpToken);
}

bool GetToken(char* lineBuf,int* pos,char* token,char* tokenstr)
{
	int  len=strlen(lineBuf);
	int  tokpos=0;
	int  tokstrlen;
	bool bTokOk;

	if (tokenstr==0)
		tokenstr="|@\r\n";

	tokstrlen=strlen(tokenstr);

	if (*pos>=len)
	{
		*token=NULL;
		return false;
	}

	for(int i=*pos;i<len;i++)
	{
		bTokOk=TRUE;
		for(int j=0;j<tokstrlen;j++)
		{
			if (lineBuf[i]==tokenstr[j])
			{
				bTokOk=FALSE;
				break;
			}
		}

		if (bTokOk)
			token[tokpos++]=lineBuf[i];
		else
			break;
	}

	token[tokpos]='\0';
	*pos=i+1;

	return true;
}

CStr BuildAutoDuckString(FILE* fp,int filepos)
{
	CStr strAutoDuck;
	char lineBuf[512];

	fseek(fp,filepos,SEEK_SET);

	while(fgets(lineBuf,512,fp))
	{
		// Break if we've made it to script code (non comment line)
		char* comment=strstr(lineBuf,"// ");
		
		if (comment==NULL)
			break;

		// Get rid of the comment delimiter and add to AutoDuck string
		comment+=3;
		strAutoDuck+=comment;
	}

	return strAutoDuck;
}

CStr BuildAutoDuckString(char* buf)
{
	CStr strAutoDuck;
	CStr strTemp;
	int  pos=0;
	int  buflen=strlen(buf);
	CStr eol="\n";

	while(pos<buflen)
	{
		// Get a line of text from the buffer
		strTemp=GetRemainLinePartial(buf,&pos);
	
		if (strTemp==CStr(""))
			continue;

		// Exit if we reach a non commented line
		if (Instr(strTemp,"// ")==-1)
			break;

		strAutoDuck+=strTemp+eol;
	}

	return strAutoDuck;
}

///////////////////////////////

CStr GetWordToken(FILE* fp,char* lineBuf,int* pos,bool bAdvance)
{
	char token[512];
	int  linelen;
	bool bOk;
	int  filepos;
	int  oldpos;
	char oldlineBuf[512];

	if (bAdvance==FALSE)
	{
		filepos=ftell(fp);
		oldpos=*pos;
		strcpy(oldlineBuf,lineBuf);
	}

	// line length without comments
	linelen=strlen(lineBuf);

	// Get new line if we've exceeded this one
	if (*pos>=linelen)
	{
		*pos=0;
		
		if (!fgets(lineBuf,512,fp))
			return CStr("");

		linelen=strlen(lineBuf);

		// Strip line after comment
		for(int i=0;i<linelen;i++)
		{
			if (lineBuf[i]==';')
			{
				lineBuf[i]='\0';
				break;
			}
		}

		linelen=strlen(lineBuf);
	}

	// Get token
	bOk=GetToken(lineBuf,pos,token," \n\t");
	StripToken(token);

	// Add space to prevent end of parse (if there is a zero sized token)
	if (bOk && token[0]=='\0')
	{
		token[0]=' ';
		token[1]='\0';
	}

	// Scan next line if we've reached the end
	if (!bOk)
	{
		//*pos=linelen+1;
		(*pos)++;
		CStr val=GetWordToken(fp,lineBuf,pos,bAdvance);

		if (bAdvance==FALSE)
		{
			fseek(fp,filepos,SEEK_SET);
			*pos=oldpos;
			strcpy(lineBuf,oldlineBuf);
		}

		return val;
	}

	if (bAdvance==FALSE)
	{
		fseek(fp,filepos,SEEK_SET);
		*pos=oldpos;
		strcpy(lineBuf,oldlineBuf);
	}

	return CStr(token);
}

bool FileAdvance(FILE* fp,char* lineBuf,int* pos,char delim)
{
	char tmpstr[2];
	CStr word;

	tmpstr[0]=delim;
	tmpstr[1]='\0';

	for(;;)
	{
		word=GetWordToken(fp,lineBuf,pos);
		
		if (word==CStr(tmpstr))
			return true;

		if (word==CStr(""))
			return false;
	}

	return false;
}

CStr GetRemainLine(char* lineBuf,int* pos)
{
	char tmpbuf[512];
	int  linelen=strlen(lineBuf);
	int  tmpbufpos=0;

	for(int i=*pos;i<linelen;i++)
	{
		// Filter unwanted characters
		if (lineBuf[i]!=10 &&
			lineBuf[i]!=13 &&
			lineBuf[i]!=8  &&
			lineBuf[i]!=9)
			tmpbuf[tmpbufpos++]=lineBuf[i];
	}

	tmpbuf[tmpbufpos]='\0';
	*pos=linelen+1;

	return CStr(tmpbuf);
}

CStr GetRemainLinePartial(char* lineBuf,int* pos)
{
	char tmpbuf[512];
	int  linelen=strlen(lineBuf);
	int  tmpbufpos=0;

	for(int i=*pos;i<linelen;i++)
	{
		if (lineBuf[i]=='\r' ||
			lineBuf[i]=='\n')
			break;

		// Filter unwanted characters
		if (lineBuf[i]!=10 &&
			lineBuf[i]!=13 &&
			lineBuf[i]!=8  &&
			lineBuf[i]!=9)
			tmpbuf[tmpbufpos++]=lineBuf[i];
	}

	tmpbuf[tmpbufpos]='\0';
	*pos=i+1;

	return CStr(tmpbuf);
}

CStr GetRemainLineExact(char* lineBuf,int* pos)
{
	char tmpbuf[512];
	int  linelen=strlen(lineBuf);
	int  tmpbufpos=0;

	for(int i=*pos;i<linelen;i++)
	{
		if (linelen     > i+1 &&
			lineBuf[i  ]==13  &&
			lineBuf[i+1]==10)
		{
			// Assume CR/LF and skip over
			tmpbuf[tmpbufpos]='\0';
			*pos=i+2;

			return CStr(tmpbuf);
		}

		if (lineBuf[i]==10)
			break;

		tmpbuf[tmpbufpos++]=lineBuf[i];
	}

	tmpbuf[tmpbufpos]='\0';
	*pos=i+1;

	return CStr(tmpbuf);
}

bool AdvanceNextLine(char* lineBuf,int* pos)
{
	int len=strlen(lineBuf);

	for(int i=*pos;i<len;i++)
	{
		if (lineBuf[i]=='\n')
		{
			*pos=i+1;
			return true;
		}
	}

	return false;
}

bool IsInstr(char* src,char* search,int start)
{
	int srclen=strlen(src);
	int searchlen=strlen(search);

	for(int i=start;i<srclen;i++)
	{
		for(int j=0;j<searchlen;j++)
		{
			if (src[i+j]!=search[j])
				break;

			if (j==searchlen-1)
				return true;
		}
	}

	return false;
}

int Instr(char* src,char* search,int start)
{
	int srclen=strlen(src);
	int searchlen=strlen(search);

	for(int i=start;i<srclen;i++)
	{
		for(int j=0;j<searchlen;j++)
		{
			if (src[i+j]!=search[j])
				break;

			if (j==searchlen-1)
				return i;
		}
	}

	return -1;
}

int RInstr(char* src,char* search,int start)
{
	int srclen=strlen(src);
	int searchlen=strlen(search);

	for(int i=srclen-searchlen;i>=0;i--)
	{
		for(int j=0;j<searchlen;j++)
		{
			if (src[i+j]!=search[j])
				break;

			if (j==searchlen-1)
				return i;
		}
	}

	return -1;
}

bool IsAlpha(char* buf)
{
	char sAlpha[]="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

	int  AlphaLen=strlen(sAlpha);
	int  BufLen=strlen(buf);

	for(int i=0;i<BufLen;i++)
	{
		for(int j=0;j<AlphaLen;j++)
		{
			if (buf[i]==sAlpha[j])
				break;

			if (j==AlphaLen-1)
				return false;
		}
	}

	return true;
}

bool IsAlphaNum(char* buf)
{
	char sAlpha[]="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";

	int  AlphaLen=strlen(sAlpha);
	int  BufLen=strlen(buf);

	for(int i=0;i<BufLen;i++)
	{
		for(int j=0;j<AlphaLen;j++)
		{
			if (buf[i]==sAlpha[j])
				break;

			if (j==AlphaLen-1)
				return false;
		}
	}

	return true;
}

CStr MakeAlphaNum(char* buf)
{
	CStr newStr;
	char sAlpha[]="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_/";
	char sChr[2]="";

	int  AlphaLen=strlen(sAlpha);
	int  BufLen=strlen(buf);

	for(int i=0;i<BufLen;i++)
	{
		for(int j=0;j<AlphaLen;j++)
		{
			if (buf[i]==sAlpha[j])
			{
				sChr[0]=buf[i];
				newStr+=sChr;
			}
		}
	}

	return newStr;
}

CStr MakeAlphaNumS(char* buf)
{
	CStr newStr;
	char sAlpha[]="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_ ";
	char sChr[2]="";

	int  AlphaLen=strlen(sAlpha);
	int  BufLen=strlen(buf);

	for(int i=0;i<BufLen;i++)
	{
		for(int j=0;j<AlphaLen;j++)
		{
			if (buf[i]==sAlpha[j])
			{
				sChr[0]=buf[i];
				newStr+=sChr;
			}
		}
	}

	return newStr;
}


bool HasAlpha(char* buf)
{
	char sAlpha[]="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

	int  AlphaLen=strlen(sAlpha);
	int  BufLen=strlen(buf);

	for(int i=0;i<BufLen;i++)
	{
		for(int j=0;j<AlphaLen;j++)
		{
			if (buf[i]==sAlpha[j])
				return true;
		}
	}

	return false;
}

bool HasNum(char* buf)
{
	char sAlpha[]="0123456789";

	int  AlphaLen=strlen(sAlpha);
	int  BufLen=strlen(buf);

	for(int i=0;i<BufLen;i++)
	{
		for(int j=0;j<AlphaLen;j++)
		{
			if (buf[i]==sAlpha[j])
				return true;
		}
	}

	return false;
}

bool HasAlphaNum(char* buf)
{
	char sAlpha[]="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

	int  AlphaLen=strlen(sAlpha);
	int  BufLen=strlen(buf);

	for(int i=0;i<BufLen;i++)
	{
		for(int j=0;j<AlphaLen;j++)
		{
			if (buf[i]==sAlpha[j])
				return true;
		}
	}

	return false;
}

int CountChar(char* str,char chr)
{
	int len=strlen(str);
	int count=0;

	for(int i=0;i<len;i++)
		if (str[i]==chr)
			count++;

	return count;
}

void BlankGroups(char* str,char delimStart,char delimEnd)
{
	bool bBlank=false;

	// Must be an even number of quotes
	int len=strlen(str);

	if (delimStart!=delimEnd)
	{
		for(int i=0;i<len;i++)
		{
			if (str[i]==delimStart)
				bBlank=true;

			if (str[i]==delimEnd)
			{
				bBlank=false;
				str[i]='*';
			}

			if (bBlank)
				str[i]='*';
		}
	}
	else
	{
		for(int i=0;i<len;i++)
		{
			if (str[i]==delimStart)
			{
				bBlank=!bBlank;
				str[i]='*';
			}

			if (bBlank)
				str[i]='*';
		}
	}
}

bool IsBlank(char* str)
{
	int len=strlen(str);

	for(int i=0;i<len;i++)
	{
		if (str[i]!=' '  &&
			str[i]!='\t' &&
			str[i]!=10   &&
			str[i]!=13)
			return false;
	}

	return true;
}

int NumWords(char* str)
{
	char token[128];
	char tmpbuf[1024];
	int  pos=0;
	int  count=0;
	int  len=strlen(str);

	strcpy(tmpbuf,str);
	BlankGroups(tmpbuf,'\"','\"');
	BlankGroups(tmpbuf,'(',')');
	BlankGroups(tmpbuf,'[',']');
	BlankGroups(tmpbuf,'{','}');

	while(GetToken(tmpbuf,&pos,token," \n"))
	{
		if (!IsBlank(token))
			count++;
	}

	return count;
}

CStr StripLeft(char* src)
{
	int len=strlen(src);
	int pos=0;

	char tmpbuf[2];
	CStr strOut;
	tmpbuf[1]='\0';

	for(int i=0;i<len;i++)
	{
		if (src[i]!=' '  &&
			src[i]!='\t' &&
			src[i]!=10   &&
			src[i]!=13)
		{
			for(int j=i;j<len;j++)
			{
				tmpbuf[0]=src[j];
				strOut+=tmpbuf;
			}

			return strOut;
		}
	}

	return strOut;
}

CStr StripRight(char* src)
{
	int len=strlen(src);
	int pos=0;

	char tmpbuf[2];
	CStr strOut;
	char str[2048];
	tmpbuf[1]='\0';

	strcpy(str,src);

	for(int i=len;i>=0;i--)
	{
		if (str[i]!=' '  &&
			str[i]!='\t' &&
			str[i]!=10   &&
			str[i]!=13   &&
			str[i]!=0)
		{
			str[i+1]='\0';
			return CStr(str);
		}
	}

	return CStr(str);
}

CStr Left(CStr src,int num)
{
	return src.Substr(0,num);
}

CStr Right(CStr src,int num)
{
	return src.Substr(num,src.Length());
}

CStr ReplaceStr(CStr src,CStr search,CStr replace)
{
	CStr newStr=src;
	int  pos=0;

	while((pos=Instr(newStr,search,pos))!=-1)
	{
		newStr=Left(newStr,pos)+replace+Right(newStr,pos+search.Length());
		pos+=replace.Length();
	}

	return newStr;
}

bool HasData(CStr buf)
{
	if (buf.Length()==0)
		return false;

	if (buf.Length()<4 && !HasAlphaNum(buf))
		return false;

	return true;
}

int GetNestStart(char* str,int* pos)
{
	int len=strlen(str);

	for(;(*pos)<len;(*pos)++)
	{
		if (str[*pos]=='(')
			return *pos;

		if (str[*pos]=='[')
			return *pos;

		if (str[*pos]=='{')
			return *pos;

		// Check if invalid character before nest start
		if (str[*pos]!=' '  &&
			str[*pos]!='\t' &&
			str[*pos]!=10   &&
			str[*pos]!=13)
			return *pos;
	}

	return *pos;
}

CStr GetGroup(CStr src,int* pos)
{
	int  parenNest=0;
	int  brackNest=0;
	int  squigNest=0;
	int  len=src.Length();
	CStr strGroup;

	for(;*pos<len;(*pos)++)
	{
		if (src[*pos]=='(')
			parenNest++;

		if (src[*pos]==')')
			parenNest--;

		if (src[*pos]=='[')
			brackNest++;

		if (src[*pos]==']')
			brackNest--;

		if (src[*pos]=='{')
			squigNest++;

		if (src[*pos]=='}')
			squigNest--;

		// Check if there's a nesting mismatch
		if (parenNest<0 ||
			brackNest<0 ||
			squigNest<0)
			return CStr("");

		strGroup+=src.Substr(*pos,1);

		// Check if end of group
		if (parenNest==0 &&
			brackNest==0 &&
			squigNest==0)
			return strGroup;
	}

	return CStr("");
}

CStr OneLineConvert(CStr src)
{
	char token[1024];
	char cstr[2];
	cstr[1]='\0';

	cstr[0]=10;
	src=ReplaceStr(src,cstr,"");
	cstr[0]=13;
	src=ReplaceStr(src,cstr," ");
	
	src=ReplaceStr(src,"( ","(");
	src=ReplaceStr(src,"[ ","[");
	src=ReplaceStr(src,"{ ","{");

	src=ReplaceStr(src," )",")");
	src=ReplaceStr(src," ]","]");
	src=ReplaceStr(src," }","}");

	strcpy(token,src);
	StripToken(token);
	src=token;

	src=ReplaceStr(src," ",", ");
	src=ReplaceStr(src,", ,","");
	src=ReplaceStr(src," ","");
	src=ReplaceStr(src,",",", ");

	return src;
}

CStr Shave(CStr line)
{
	char* buf;
	CStr  str;

	buf = new char[line.Length()+1];
	strcpy(buf,line);

	StripToken(buf);
	str = buf;

	delete [] buf;

	return str;
}

bool LineContainsAll(char* line,char chr)
{
	int len=strlen(line);

	for(int i=0;i<len;i++)
	{
		if (line[i]!=chr)
			return false;
	}

	return true;
}

CStr GetPropVal(CStr src,CStr str)
{
	// Make search case insensitive
	CStr lcsrc = src;
	CStr lcstr = str;

	lcsrc.toLower();
	lcstr.toLower();

	// Blank field groups so they're treated as a single token
	BlankGroups(lcsrc,'\"','\"');
	BlankGroups(lcsrc,'(',')');
	BlankGroups(lcsrc,'[',']');
	BlankGroups(lcsrc,'{','}');

	int pos   = Instr(lcsrc,lcstr);

	if (pos == -1)
		return CStr("");

	int eqpos = Instr(lcsrc,"=",pos+1);

	if (eqpos == -1)
		return CStr("TRUE");

	// Find the first non-space from the equal sign
	int len = lcsrc.Length();

	for(int i=eqpos+1;i<len;i++)
	{
		if (lcsrc[i]!=' ')
		{
			// We've found the starting point of the value, now find the end
			for(int j=i;j<len;j++)
				if (lcsrc[j]==' ')
					return src.Substr(i,j-i);

			return src.Substr(i,len);
		}
	}

	return CStr("");
}

void TermLine(CStr& str)
{
	int len = str.Length();

	for(int i=0;i<len;i++)
	{
		if (str[i]==10 ||
			str[i]==13)
		{
			str[i]=0;
			return;
		}
	}
}

CStr ExtractFile(CStr str)
{
	int spos, epos;

	spos = RInstr(str,"\\");

	if (!spos)
		spos = Instr(str,":");

	if (!spos)
		spos = 0;

	epos = RInstr(str,".");

	if (!epos)
		epos = str.Length()-1;

	if (epos < 0)
		epos = 0;

	epos = epos - spos;

	return str.Substr(spos+1,epos-1);
}

void GetOption(char* src,char* out,char delim,int optnum)
{
	char sDelim[2];
	sDelim[0] = delim;
	sDelim[1] = 0;

	int start = 0;
	int end = Instr(src,sDelim,1);

	for(int i=0;i<optnum;i++)
	{
		start = Instr(src,sDelim,start+1)+1;
		
		if (start == 0)
			start = -1;

		end = Instr(src,sDelim,start+1);
	}

	if (start == -1)
	{
		*out = 0;
		return;
	}

	if (end == -1)
		end = strlen(src);

	int pos;
	for(i=start,pos=0;i<end;i++,pos++)
	{
		out[pos] = src[i];
	}

	out[pos] = 0;
}
