/*
	ExtScript.cpp
	External Script Viewer
	1-28-01
*/

#include "ExtScript.h"
#include "Resource.h"

ExtScriptDlg::ExtScriptDlg(HINSTANCE hInstance,HWND hwndParent) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_EXTSCRIPT),hwndParent)
{
	pRichText=new RichText(hInstance,GetDlgItem(hwnd,IDC_SCRIPTVIEW));
}

ExtScriptDlg::~ExtScriptDlg()
{
	if (pRichText)
		delete pRichText;
}

void ExtScriptDlg::SetTitle(CStr str)
{
	char windowTitle[128];
	sprintf(windowTitle,"External Script - [File: %s]",(char*)str);
	SetWindowText(hwnd,windowTitle);
}

void ExtScriptDlg::Highlight(CStr keyword)
{
	// Find the definition of the script in the file
	CStr strSearch=CStr("Script ")+keyword;
	int  index=pRichText->Search(strSearch,RTS_WHOLEWORD);
	
	if (index!=-1)
		pRichText->HighlightLine(index);
}

BOOL ExtScriptDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_ACTIVATE:
		if (LOWORD(wParam)==WA_INACTIVE)
			EnableAccelerators();
		else
			DisableAccelerators();
		
		return TRUE;

	case WM_CLOSE:
		Hide();
		return TRUE;
	}

	return FALSE;
}
