/*
	MergeRenameDlg.cpp
	aml 4-22-01
*/

#include "MergeRenameDlg.h"
#include "Resource.h"

MergeRenameDlg::MergeRenameDlg(HINSTANCE hInstance, HWND hwndParent,CStr name) :
	ModalDlgWindow(hInstance,MAKEINTRESOURCE(IDD_MERGENAME),hwndParent)
{
	strName = name;
}

MergeRenameDlg::~MergeRenameDlg()
{
	ReleaseICustEdit(IEdit);
}

BOOL MergeRenameDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		{
			ICustEdit* IEdit = GetICustEdit(GetDlgItem(hwnd,IDC_MERGENAME));
			IEdit->SetText(strName);
			ReleaseICustEdit(IEdit);
		}
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_OPDONE:
			{
				char buf[256];

				ICustEdit* IEdit = GetICustEdit(GetDlgItem(hwnd,IDC_MERGENAME));
				IEdit->GetText(buf,255);
				ReleaseICustEdit(IEdit);
				strName = buf;

				EndDialog(hwnd,0);
			}
			return TRUE;
		}
	}

	return FALSE;
}

CStr MergeRenameDlg::GetName()
{
	return strName;
}

void MergeRenameDlg::SetName(CStr& name)
{
	strName = name;
}
