/*
	ConflictDlg.cpp
	Dialog to allow user to select how a merge conflict will be resolved
	4-2-01
*/

#include "ConflictDlg.h"
#include "Resource.h"
#include <assert.h>

ConflictDlg::ConflictDlg(HINSTANCE hInstance, HWND hwndParent) :
	ModalDlgWindow(hInstance,MAKEINTRESOURCE(IDD_MERGECONFLICT),hwndParent)
{
	bApplyAll = false;
	rmode = RESOLVE_DELSRC;	
	bDisableMerge = false;
	dmode = DISPMODE_GEOM;
	renameName[0] = '\0';

	bAutoRename = false;
}

ConflictDlg::~ConflictDlg()
{

}

void ConflictDlg::Show()
{
	bApplyAll = false;
	rmode = RESOLVE_DELSRC;
	ModalDlgWindow::Show();
}

void ConflictDlg::SetItemName(char* name)
{
	assert(strlen(name)<1024);
	strcpy(itemName,name);
}

ResolveMode ConflictDlg::GetResolveMode()
{
	return rmode;
}

BOOL ConflictDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		{
			SetDlgItemText(hwnd,IDC_ITEMNAME,itemName);
			
			CheckRadioButton(hwnd,IDC_DISCARDSRC,IDC_MERGEITEM,IDC_DISCARDSRC);
			SendDlgItemMessage(hwnd,IDC_DISCARDSRC,BM_SETCHECK,(WPARAM)TRUE,0);
			
			EnableWindow(GetDlgItem(hwnd,IDC_MERGEITEM),!bDisableMerge);

			switch(dmode)
			{
			case DISPMODE_GEOM:
				SetWindowText(hwnd,"Geometry Merge Conflict");
				SetWindowText(GetDlgItem(hwnd,IDC_DISCARDSRC),"Discard the original node");
				SetWindowText(GetDlgItem(hwnd,IDC_DISCARDMERGE),"Discard the merge node");
				SetWindowText(GetDlgItem(hwnd,IDC_MERGEITEM),"Rename the node");
				break;

			case DISPMODE_MTL:
				SetWindowText(hwnd,"Material Merge Conflict");
				SetWindowText(GetDlgItem(hwnd,IDC_DISCARDSRC),"Discard the original material");
				SetWindowText(GetDlgItem(hwnd,IDC_DISCARDMERGE),"Discard the merge material");
				SetWindowText(GetDlgItem(hwnd,IDC_MERGEITEM),"Rename the material");

				ShowWindow(GetDlgItem(hwnd,IDC_AUTORENAME),SW_HIDE);
				ShowWindow(GetDlgItem(hwnd,IDC_RENAMETRIGGERLINKS),SW_HIDE);
				break;
			}

			return TRUE;
		}

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_DISCARDSRC:
			if (IsDlgButtonChecked(hwnd,IDC_DISCARDSRC)==BST_CHECKED)
				rmode = RESOLVE_DELSRC;

			EnableWindow(GetDlgItem(hwnd,IDC_RENAMETRIGGERLINKS),FALSE);
			return TRUE;

		case IDC_DISCARDMERGE:
			if (IsDlgButtonChecked(hwnd,IDC_DISCARDMERGE)==BST_CHECKED)
				rmode = RESOLVE_DELMERGE;

			EnableWindow(GetDlgItem(hwnd,IDC_RENAMETRIGGERLINKS),FALSE);
			return TRUE;

		case IDC_MERGEITEM:
			if (IsDlgButtonChecked(hwnd,IDC_MERGEITEM)==BST_CHECKED)
				rmode = RESOLVE_MERGE;

			EnableWindow(GetDlgItem(hwnd,IDC_RENAMETRIGGERLINKS),FALSE);
			return TRUE;

		case IDC_AUTORENAME:
			if (IsDlgButtonChecked(hwnd,IDC_AUTORENAME)==BST_CHECKED)
			{
				rmode = RESOLVE_AUTORENAME;
				EnableWindow(GetDlgItem(hwnd,IDC_RENAMETRIGGERLINKS),TRUE);
			}
			else
			{
				EnableWindow(GetDlgItem(hwnd,IDC_RENAMETRIGGERLINKS),FALSE);
			}
			return TRUE;

		case IDC_RENAMETRIGGERLINKS:
			bAutoRename = !bAutoRename;
			return TRUE;

		case IDC_APPLYALL:
			bApplyAll = !bApplyAll;
			return TRUE;

		case IDOK:
			EndDialog(hwnd,0);
			return TRUE;
		}
		break;
	}

	return FALSE;
}

void ConflictDlg::SetRenameName(char* name)
{
	// A name can only be set if we're applying it to everything
	if (bApplyAll)
	{
		if (strlen(name)>1023)
			return;

		strcpy(renameName,name); 
	}
}
