#include <next.h>
#include <appdata.h>
#include "linkoptions.h"
#include "linkman.h"
#include "linkui.h"

extern HINSTANCE hInstance;

LinkOptions* GetLinkOptions( void )
{
	LinkOptions *options;

	ReferenceTarget *scene = gInterface->GetScenePointer();
	AppDataChunk* pad = scene->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_OPTIONS_ID );

	// Return the link options if they exist
	if( pad && pad->data )
	{
		options = (LinkOptions *) pad->data;
		if( options->m_Version != vLINKOPTIONS_CURRENT_VERSION )
		{
			// for now, don't be backward compatible. This will force the dialog
			// to use the default values
			scene->RemoveAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_OPTIONS_ID );
			return NULL;
		}
		return options;
	}
	
	return NULL;	
}

void SetLinkOptions( LinkOptions* options )
{
	LinkOptions *link_options;
	AppDataChunk* pad;
	ReferenceTarget *scene;

	assert( options );

	scene = gInterface->GetScenePointer();	
	pad = scene->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_OPTIONS_ID );
	
	if( !pad )
	{
		link_options = new LinkOptions;		
		scene->AddAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_OPTIONS_ID, sizeof( LinkOptions ), (void*) link_options );	
	}
	else
	{
		link_options = (LinkOptions *) pad->data;		
	}

	*link_options = *options;
	link_options->m_Version = vLINKOPTIONS_CURRENT_VERSION;
}

void	SetLinkFromObjectName( INode *node, char *name )
{
	AppDataChunk* pad;
	char *name_buff;
	
	pad = node->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_FROM_CHUNK_ID );	
	if( !pad )
	{
		name_buff = (char *) malloc( strlen( name ) + 1 );
		node->AddAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_FROM_CHUNK_ID, strlen( name ) + 1, name_buff );
	}
	else
	{
		node->RemoveAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_FROM_CHUNK_ID );
		name_buff = (char *) malloc( strlen( name ) + 1 );
		node->AddAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_FROM_CHUNK_ID, strlen( name ) + 1, name_buff );
	}
	
	strcpy( name_buff, name );	
}

char*	GetLinkFromObjectName( INode *node )
{
	AppDataChunk* pad;

	pad = node->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_FROM_CHUNK_ID );	
	if( !pad )
	{
		return NULL;
	}
	
	return (char *) pad->data;
}

void	SetLinkToObjectName( INode *node, char *name )
{
	AppDataChunk* pad;
	char *name_buff;
	
	pad = node->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_TO_CHUNK_ID );	
	if( !pad )
	{
		name_buff = (char *) malloc( strlen( name ) + 1 );
		node->AddAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_TO_CHUNK_ID, strlen( name ) + 1, name_buff );		
	}
	else
	{
		node->RemoveAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_TO_CHUNK_ID );
		name_buff = (char *) malloc( strlen( name ) + 1 );
		node->AddAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_TO_CHUNK_ID, strlen( name ) + 1, name_buff );		
	}
	
	strcpy( name_buff, name );	
}

char*	GetLinkToObjectName( INode *node )
{
	AppDataChunk* pad;

	pad = node->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_LINK_TO_CHUNK_ID );	
	if( !pad )
	{
		return NULL;
	}
	
	return (char *) pad->data;
}

static INT_PTR CALLBACK LinkOptionsDlgProc(
		HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static LinkOptionsDlg *dlg = NULL;
	
	switch(msg) {
	case WM_INITDIALOG:
	{
		dlg = (LinkOptionsDlg*) lParam;

		if( GetLinkMan()->GetSelectChildren())
		{
			SendDlgItemMessage( hWnd, IDC_SELECT_CHILDREN, BM_SETCHECK, BST_CHECKED, 0 );
		}
		if( GetLinkMan()->GetSelectParents())
		{
			SendDlgItemMessage( hWnd, IDC_SELECT_PARENTS, BM_SETCHECK, BST_CHECKED, 0 );
		}
		if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_OFF )
		{
			SendDlgItemMessage( hWnd, IDC_LINKS_OFF, BM_SETCHECK, BST_CHECKED, 0 );
		}
		if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_ALL )
		{
			SendDlgItemMessage( hWnd, IDC_LINKS_ALL, BM_SETCHECK, BST_CHECKED, 0 );
		}
		if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SYSTEM )
		{
			SendDlgItemMessage( hWnd, IDC_LINKS_SYSTEM, BM_SETCHECK, BST_CHECKED, 0 );
		}

		break;
	}

	case CC_COLOR_CHANGE:
	{
		IColorSwatch *cs = (IColorSwatch*)lParam;
		GetLinkMan()->SetLinkColor( cs->GetColor());
		break;
	}

	case WM_COMMAND:
		switch (LOWORD(wParam)) 
		{
			case IDCANCEL:
				DestroyLinkOptionsDialog();				
				break;

			case IDC_SELECT_CHILDREN:
			{
				BOOL select_children;

				select_children = 
					SendDlgItemMessage( hWnd, IDC_SELECT_CHILDREN, BM_GETCHECK, 0, 0 ) == BST_CHECKED;

				if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SYSTEM )
				{			
					SendDlgItemMessage( hWnd, IDC_LINKS_ALL, BM_SETCHECK, BST_CHECKED, 0 );
					SendDlgItemMessage( hWnd, IDC_LINKS_SYSTEM, BM_SETCHECK, BST_UNCHECKED, 0 );					
					GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_ALL );	
					UpdateWindow( hWnd );
				}
				GetLinkMan()->SetSelectChildren(( select_children == TRUE ));
				LinkUI::SetSelectChildren( select_children == TRUE );
				break;
			}

			case IDC_SELECT_PARENTS:
			{
				BOOL select_parents;

				select_parents = 
					SendDlgItemMessage( hWnd, IDC_SELECT_PARENTS, BM_GETCHECK, 0, 0 ) == BST_CHECKED;

				if( GetLinkMan()->GetDisplayMode() == ILinkMan::DISPLAY_MODE_SYSTEM )
				{	
					SendDlgItemMessage( hWnd, IDC_LINKS_ALL, BM_SETCHECK, BST_CHECKED, 0 );
					SendDlgItemMessage( hWnd, IDC_LINKS_SYSTEM, BM_SETCHECK, BST_UNCHECKED, 0 );					
					GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_ALL );	
					UpdateWindow( hWnd );
				}
				
				GetLinkMan()->SetSelectParents(( select_parents == TRUE ));
				LinkUI::SetSelectParents( select_parents == TRUE );
				break;
			}

			case IDC_LINKS_OFF:
				GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_OFF );		
				break;

			case IDC_LINKS_ALL:
				GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_ALL );	
				break;

			case IDC_LINKS_SELECTED:
				GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_SELECTED );	
				break;

			case IDC_LINKS_SYSTEM:
			{
				// Show System and Select Children/Parents options are mutually exclusive
				SendDlgItemMessage( hWnd, IDC_SELECT_CHILDREN, BM_SETCHECK, BST_UNCHECKED, 0 );
				SendDlgItemMessage( hWnd, IDC_SELECT_PARENTS, BM_SETCHECK, BST_UNCHECKED, 0 );					
				GetLinkMan()->SetSelectChildren( false );
				GetLinkMan()->SetSelectParents( false );
				LinkUI::SetSelectChildren( false );
				LinkUI::SetSelectParents( false );
				GetLinkMan()->SetDisplayMode( ILinkMan::DISPLAY_MODE_SYSTEM );	
				break;
			}
		}
	}
	return FALSE;
}

void	LinkOptionsDlg::Show( void )
{
	m_wnd = CreateDialogParam(
		hInstance,
		MAKEINTRESOURCE(IDD_LINK_OPTIONS),
		gInterface->GetMAXHWnd(),
		LinkOptionsDlgProc,
		(LPARAM)this);	
	TSTR title = "Link Options";
	SetWindowText( m_wnd, title );
	gInterface->RegisterDlgWnd( m_wnd );
	//ip->RegisterTimeChangeCallback(this);
	//reactorActionCB = new ReactorActionCB<Reactor>(cont);
	//ip->GetActionManager()->ActivateActionTable(reactorActionCB, kReactorActions);
}

void	LinkOptionsDlg::Hide( void )
{
	gInterface->UnRegisterDlgWnd( m_wnd );
	DestroyWindow( m_wnd );	
}

void	LinkOptionsDlg::SwatchSetColor( Color color )
{
	m_color = color;
}