#ifndef __LINK_LINKUI_H__
#define __LINK_LINKUI_H__

#include <max.h>
#include <bmmlib.h>
#include <bitmap.h>
#include <inode.h>
#include <guplib.h>
#include <iparamb2.h>
#include <Notify.h>
//#include "../sharedbl/linkman.h"

#define vLINK_OBJ_CLASS_ID Class_ID(0x3d980018, 0x6002ebf)
#define vLINK_UI_CLASS_ID Class_ID(0x23186540, 0x3acf73bb)
#define vLINK_SHORTCUT_ID	 0x7ad83de5

void			DestroyLinkOptionsDialog( void );
ActionTable*	GetLinkActions( void );

class LinkUI : public GUP {
	
	static void link_selchange_handler(void* param, NotifyInfo* info );
	bool bLockSelChange;

	public:

		ICUIFrame *iFrame;
				
		HWND hWnd; // our CUI winhandle

		LinkUI () { bLockSelChange = false; }
		~LinkUI	() {}
	
		// GUP Methods
		DWORD	Start			( );
		void	Stop			( );
		DWORD	Control			( DWORD parameter );
		
		void    Refresh();

		inline bool GetSelLock() { return bLockSelChange; }

		static	void			SetSelectChildren( bool on );
		static	void			SetSelectParents( bool on );
};

class LinkUIClassDesc:public ClassDesc 
{
public:

	int 			IsPublic()					{ return TRUE; }
	void *			Create( BOOL loading )		{ return new LinkUI; }
	const TCHAR *	ClassName()					{ return _T("TriggerLink"); }
	SClass_ID		SuperClassID()				{ return GUP_CLASS_ID; }
	Class_ID 		ClassID()					{ return vLINK_UI_CLASS_ID; }
	const TCHAR* 	Category()					{ return _T("");  }	
	
	//You only need to add the action stuff to one Class Desc
	int             NumActionTables() { return 1; }
	ActionTable*  GetActionTable(int i) { return GetLinkActions(); }
};

// Accelerator table callback for Link operations
class LinkActionCB : public ActionCallback 
{
public:		
	BOOL ExecuteAction( int id );
};

class LinkObject: public HelperObject
{
  private:
	friend class LinkUI;
	  
	 Mesh 	mesh;
	//BOOL 	parentSelected;

	// This will notify the link object that it's been selected (aml)
	void SelUpdate(INode* node);

  public:
	  enum
	  {
		REF_ID_FROM,
		REF_ID_TO,
		NUM_REFS
	  };

	// our trigger link references.
	INode* 	from_node;
	INode*	to_node;
	INode*	link_node;
	int		sel_op_id;
	int		ref_count;
	
	Color	m_Color;
	
	BOOL	suspendSnap;	// just like in SimpleObject

	LinkObject() :
		suspendSnap(FALSE),
		from_node(NULL),
		to_node(NULL),
		link_node(NULL),
		sel_op_id( -1 ),
		ref_count( 0 ),
		m_Color( Color( 1, 1, 0 ))
	{ 
		
		BuildMesh();
	}

	// helper for our display routine
	void 	GetLinePoints(TimeValue t, Point3* q, float len); 
	int		DrawLink(TimeValue t, Point3& from, Point3& to, ViewExp *vpt,
							bool draw_arrow, Point3& arrow_origin, bool from_selected );
	void 	GetMat(TimeValue t, INode* inode, ViewExp* vpt, Matrix3& tm);	
	
	void	IncRef( void );
	void	DecRef( void );

	void BuildMesh(void);

	// from GeomObject
	Mesh* GetRenderMesh(TimeValue t, INode *inode, View& view, BOOL& needDelete)
	{
		needDelete=FALSE;
		return &mesh;
	}
	PatchMesh* GetRenderPatchMesh(TimeValue t, INode *inode, View& view, BOOL& needDelete)
	{
		return NULL;
	}


	// from Object 
	void GetDeformBBox(TimeValue t, Box3& box, Matrix3 *tm, BOOL useSel )
	{
		BuildMesh();
		box = mesh.getBoundingBox(tm);
	}

	int 	IsRenderable(void) { return FALSE; }	

	void	InitNodeName(TSTR& s)	{ s = "TriggerLink"; }

	int IntersectRay(TimeValue t, Ray& ray, float& at, Point3& norm)
	{
		/*BuildMesh();
		return mesh.IntersectRay(ray, at, norm);*/
		return 0;
	}

	ObjectState Eval(TimeValue t)	
	{ 
		return ObjectState(this); 
	}


	// from BaseObject
	TCHAR*	GetObjectName(void)	{ return "TriggerLink"; }

	CreateMouseCallBack* GetCreateMouseCallBack(void)
	{	
		return NULL;
	}

	int Display(TimeValue t, INode* inode, ViewExp *vpt, int flags);

	/*int HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt)
	{
		// Never let someone actually select the link by clicking on it
		return FALSE;
	}*/

	void Snap(TimeValue t, INode* inode, SnapInfo *snap, IPoint2 *p, ViewExp *vpt) 
	{
		return;		
	}

	void GetWorldBoundBox(TimeValue t, INode *inode, ViewExp* vpt, Box3& box )
	{
		/*
		Matrix3 mat = inode->GetObjectTM(t);
		//BuildMesh();
		box = mesh.getBoundingBox();		
		box = box * mat;*/

		if(( to_node == NULL ) || ( from_node == NULL ))
		{
			return;
		}

		Matrix3 mat;

		box.Init();
		mat = to_node->GetNodeTM(0);
		box += mat.GetTrans();

		mat = from_node->GetNodeTM(0);
		box += mat.GetTrans();	

		return;

	}

	void GetLocalBoundBox(TimeValue t, INode *inode,ViewExp* vpt,  Box3& box ) 
	{
		return;
		//BuildMesh();
		box = mesh.getBoundingBox();
		box.pmin = box.pmax;
	}

	// from ReferenceMaker
	int NumRefs() { return NUM_REFS; }

	RefTargetHandle GetReference(int i) 
	{
		switch(i) 
		{
			case REF_ID_FROM:
				return (RefTargetHandle) from_node;
			case REF_ID_TO:
				return (RefTargetHandle) to_node;									
		}
		return NULL;
	}

	void SetReference(int i, RefTargetHandle rtarg) 
	{
		switch(i) 
		{
			case REF_ID_FROM: 
				from_node = (INode *) rtarg;
				return;
			case REF_ID_TO:
				to_node = (INode *) rtarg;
				return;			
		}
	}

	//void BeginEditParams(IObjParam *ip, ULONG flags,Animatable *prev);
	//void EndEditParams(IObjParam *ip, ULONG flags,Animatable *next);

	RefResult NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, PartID& partID,RefMessage message);

	RefTargetHandle Clone(RemapDir &remap = NoRemap());

	// from Animatible
	Class_ID ClassID(void)			{ return vLINK_OBJ_CLASS_ID; }
	void	GetClassName(TSTR& s)	{ s = "NExt Link"; }
	void	DeleteThis(void)			
	{ 
		delete this; 
	}
		
};

class LinkObjClassDesc : public ClassDesc2
{
  public:
	int 	IsPublic(void) 				{ return FALSE; }

	void*	Create(BOOL loading=FALSE) { return new LinkObject(); }

	int	BeginCreate(Interface* i)		{ return 0; }
	int	EndCreate(Interface* i)			{ return 0; }

	const TCHAR* ClassName(void)		{ return "NExt Link"; }
	SClass_ID SuperClassID(void)		{ return HELPER_CLASS_ID; }
	Class_ID ClassID(void)				{ return vLINK_OBJ_CLASS_ID; }
	const TCHAR* Category(void)		{ return ""; }				
};

#endif // __LINK_LINKUI_H__
