/*
	SkelOptionsDlg.cpp
	Skeleton Export Options Dialog
	1-17-01
*/

#include "SkelOptionsDlg.h"
#include "Resource.h"
#include "path.h"

SkeletonOptionsDlg::SkeletonOptionsDlg(HINSTANCE hInstance,HWND hwndParent,Interface* ip) :
	MSDlgWindow(hInstance, MAKEINTRESOURCE(IDD_SKELOPTIONS), hwndParent),
	SkeletonExporter(hwnd,ip)
{
	this->ip=ip;
	Show();
}

SkeletonOptionsDlg::~SkeletonOptionsDlg()
{

}

BOOL SkeletonOptionsDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lPARAM)
{
	switch(msg)
	{
	case WM_ACTIVATE:
		if (LOWORD(wParam)==WA_INACTIVE)
			EnableAccelerators();
		else
			DisableAccelerators();
		
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			Hide();
			return TRUE;

		case IDC_SKELEXPORTNOW:
			Export();
			return TRUE;
		}
		return TRUE;

	case WM_CLOSE:
		Hide();
		return TRUE;
	}

	return FALSE;
}

void SkeletonOptionsDlg::Export()
{
	char Filename[256];
	CStr strFilename;
	CStr strEnv;
	bool bExportLeaves;
	GetDlgItemText(hwnd,IDC_EXPORTNAME,Filename,256);

	if (IsDlgButtonChecked(hwnd,IDC_PROCLEAF) == BST_CHECKED)
		bExportLeaves = true;
	else
		bExportLeaves = false;

	strFilename=CStr(Filename)+".ske";

	strEnv=getenv(APP_ENV);

	if (strEnv==CStr(""))
	{
		char errMsg[256];
		sprintf(errMsg,"Environment variable '%s' not set.  Can't continue.",APP_ENV);
		MessageBox(hwnd,errMsg,"Export Animations",MB_OK|MB_ICONSTOP);
		return;
	}

	if (!SkeletonExporter::Export(strEnv+CStr(SKEL_PATH)+strFilename,!bExportLeaves))
	{
		char strErr[256];
		sprintf(strErr,"Couldn't write to '%s'.",Filename);
		MessageBox(hwnd,strErr,"Skeleton Exporter",MB_ICONWARNING|MB_OK);
	}
	else
		MessageBox(hwnd,"Export Successful.","Skeleton Exporter",MB_ICONINFORMATION|MB_OK);
}
