/*
	SkelExporter.cpp
	Skeleton Exporter
	1-17-01
*/

#include "SkelExporter.h"

SkeletonExporter::SkeletonExporter(HWND hwnd,Interface* ip)
{
	this->ip=ip;
	errHwnd=hwnd;
	skeleton=NULL;
}

SkeletonExporter::~SkeletonExporter()
{
	if (skeleton)
		delete skeleton;
}

bool SkeletonExporter::Export(char* Filename, bool bIgnoreLeaves)
{
	FILE* fp=fopen(Filename,"wb");

	if (!fp)
		return false;

	int numNodes=ip->GetSelNodeCount();

	if (numNodes<1)
		return false;

	skeleton=new CSkeletonData(ip->GetSelNode(0), bIgnoreLeaves);

	skeleton->Write(fp);
	fclose(fp);

	return true;
}
