/*
	NExtScript.cpp
	Neversoft MAXScript Extensions
	4-17-01  aml
*/

#include "../NExt/NExt.h"
#include "../NExt/FaceFlags/FaceFlags.h"					// cross dependent with NExt.gup
#include "../NExt/Material/NExtMat.h"
#include "../NExt/Material/NExtMultiMat.h"
#include "max.h"

#include "MAXScrpt/MAXScrpt.h"
#include "MAXScrpt/definsfn.h"
	def_visible_primitive(NSsetFlag,"NSsetFlag");
	def_visible_primitive(NSgetFlag,"NSgetFlag");
	def_visible_primitive(NSenablePass,"NSenablePass");
	def_visible_primitive(NSdisablePass,"NSdisablePass");
	def_visible_primitive(NSfacePassEnabled,"NSfacePassEnabled");
	def_visible_primitive(NSinfo,"NSinfo");
	def_visible_primitive(NSgetFaceMtl, "NSgetFaceMtl");
	def_visible_primitive(NSpassEnabled, "NSpassEnabled");
	def_visible_primitive(NSgetMapUV, "NSgetMapUV");
	def_visible_primitive(NSbreak,"NSbreak");

#include "MAXScrpt/numbers.h"		// this evil header disables def_visible_primitive
#include "MAXScrpt/maxmats.h"
#include "MAXScrpt/3dmath.h"

#define ip   MAXScript_interface
Interface*   gInterface = MAXScript_interface;

TCHAR *GetString(int id)
{
	static TCHAR buf[256];

	if (hInstance)
		return LoadString(hInstance, id, buf, sizeof(buf)) ? buf : NULL;
	return NULL;
}

Value* NSinfo_cf(Value **arg_list, int count)
{
	char strMsg[256];
	sprintf(strMsg,"The NeverSoft MAXScript Extensions have been successfully initialized!\naml BUILT: %s  %s",__DATE__,__TIME__);

	MessageBox(ip->GetMAXHWnd(),strMsg,"Welcome to NExtScript",MB_ICONINFORMATION|MB_OK);
	return &ok;
}

Mtl*	GetSubMaterial( Mtl* base_mtl, int mtl_id )
{
    if( base_mtl )
    {
        Class_ID clID = base_mtl->ClassID();

		if( ( base_mtl->ClassID() == Class_ID( MULTI_CLASS_ID, 0 )) ||
			( base_mtl->ClassID() == vNEXT_MULTI_MATERIAL_CLASS_ID ))
        {            
            Mtl *sub_mtl= NULL;

            if( base_mtl->NumSubMtls())
            {
                if( mtl_id >= base_mtl->NumSubMtls()) 
				{
					mtl_id %= base_mtl->NumSubMtls();
				}
            }
            else
            {                
                return NULL;
            }
            
			sub_mtl = base_mtl->GetSubMtl( mtl_id );
			if( sub_mtl == NULL )
			{
				return NULL;
			}
            if(	( sub_mtl->ClassID() == Class_ID( MULTI_CLASS_ID, 0 )) ||				
				( sub_mtl->ClassID() == vNEXT_MULTI_MATERIAL_CLASS_ID ))
            {
				throw RuntimeError("Nested MultiMaterials detected.  This is unsupported!");
				return NULL;
            }
            
			return sub_mtl;            
        }
		else
		{
			return base_mtl;
		}
    }

    return NULL;
}

Value* NSgetFaceMtl_cf(Value **arg_list, int count)
{
	check_arg_count(NSgetFaceMtl, 2, count);

	// Do type checking
	type_check(arg_list[1], Integer, "< second parameter must be integer (referring to face number) >");

	INode* node = arg_list[0]->to_node();
	int    face = arg_list[1]->to_int();

	if (!node)
		throw RuntimeError("getFaceMtl: An invalid node was specified.");

	Object* obj = node->EvalWorldState(0).obj;

	if (!obj->CanConvertToType( triObjectClassID ))
		throw RuntimeError("getFaceMtl: Couldn't convert node to triobject.");

	TriObject* triobj = (TriObject*)obj->ConvertToType(0,Class_ID(TRIOBJ_CLASS_ID,0));
	Mesh&      mesh   = triobj->GetMesh();

	if (face<0)
		throw RuntimeError("nsGetFaceMtl: Invalid face index.");

	int numFaces = mesh.getNumFaces();
	if (face>numFaces-1)
	{
		char strErr[256];
		sprintf(strErr,"nsGetFaceMtl: Invalid face index.  Mesh only has %i faces.",numFaces);
		throw RuntimeError(strErr);
	}


	// Get face material
	Mtl* mtl    = node->GetMtl();
	int  matID  = mesh.getFaceMtlIndex(face);

	Mtl* newMtl = GetSubMaterial(mtl, matID);

	if (triobj!=obj)
		triobj->DeleteThis();

	/*
	CStr nname = node->GetName();
	CStr mtlName = mtl->GetName();
	CStr newMtlName = newMtl->GetName();
	*/

	//return new MAXMaterial(newMtl);
	//return new Value(newMtl);
	return MAXClass::make_wrapper_for(newMtl);
}

Value* NSpassEnabled_cf(Value **arg_list, int count)
{
	check_arg_count(NSpassEnabled, 2, count);

	// Do type checking
	type_check(arg_list[1], Integer, "< second parameter must be integer (referring to pass number) >");

	Mtl*  mtl  = arg_list[0]->to_mtl();
	int   pass = arg_list[1]->to_int();

	if (pass<1 || pass>4)
		throw RuntimeError("nsPassEnabled: param 2 (pass) must be 1-4");

	if (!mtl)
		throw RuntimeError("nsPassEnabled: The given material (param 1) is invalid.");

	if (mtl->ClassID()!=NEXT_MATERIAL_CLASS_ID)
		return &false_value;

	INExtMaterial* next_mat = dynamic_cast<INExtMaterial*> ( mtl );

	if (next_mat->PassEnabled(pass-1))
		return &true_value;

	return &false_value;
}

Value* NSsetFlag_cf(Value **arg_list, int count)
{
	check_arg_count(NSsetFlag, 4,count);

	// Do type checking
	//type_check(arg_list[0], Mesh,    "< first parameter must be mesh >");
	type_check(arg_list[1], Integer, "< second parameter must be integer (referring to face number) >");
	type_check(arg_list[2], Integer, "< third parameter must be a Neversoft Flag global (referring to the flag to change) >");
	type_check(arg_list[3], Boolean, "< fourth parameter must be a boolean specifying to set or unset the flag >");

	// Grab the values we want off the virtual stack
	Mesh* mesh    = arg_list[0]->to_mesh();
	int   face    = arg_list[1]->to_int();
	int   flag    = arg_list[2]->to_int();
	BOOL  enabled = arg_list[3]->to_bool();

	if (!mesh)
		throw RuntimeError("NSsetFlag: first parameter is not a valid mesh");

	int numFaces = mesh->getNumFaces();
	if (face>numFaces-1)
	{
		char strErr[256];
		sprintf(strErr,"NSsetFlag: Invalid face index.  Mesh only has %i faces.",numFaces);
		throw RuntimeError(strErr);
	}

	if (face<0)
		throw RuntimeError("NSsetFlag: Invalid face index.");

	FlagType nsflag;
	bool     rVal;

	IFaceDataMgr* pFDMgr = static_cast<IFaceDataMgr*>(mesh->GetInterface( FACEDATAMGR_INTERFACE ));
	if( !pFDMgr )
		return &undefined;

	FaceFlagsData* fdc = dynamic_cast<FaceFlagsData*>( pFDMgr->GetFaceDataChan( vFACE_FLAGS_CHANNEL_ID ));
	if( fdc == NULL )
	{
		// The mesh does not have our face-data channel so we will add it here
		fdc = new FaceFlagsData();
		fdc->FacesCreated( 0, mesh->getNumFaces());

		pFDMgr->AddFaceDataChan( fdc );
	}

	fdc->GetValue(face, nsflag);

	// Check the status of the indicated flag
	if (nsflag & (1 << flag))
		rVal = true;
	else
		rVal = false;

	// Set the flag to our new setting
	if (enabled)
		nsflag |= (1 << flag);
	else
		nsflag &= ~(1 << flag);

	fdc->SetValue(face, nsflag);
	
	if (rVal)
		return &true_value;
	
	return &false_value;
}

Value* NSgetFlag_cf(Value **arg_list,int count)
{
	check_arg_count(NSgetFlag, 3,count);

	// Do type checking
	type_check(arg_list[1], Integer, "< second parameter must be integer (referring to face number) >");
	type_check(arg_list[2], Integer, "< third parameter must be a Neversoft Flag global (referring to the flag to check) >");

	Mesh* mesh = arg_list[0]->to_mesh();
	int   face = arg_list[1]->to_int();
	int   flag = arg_list[2]->to_int();

	if (!mesh)
		throw RuntimeError("NSgetFlag: first parameter is not a valid mesh");

	int numFaces = mesh->getNumFaces();
	if (face>numFaces-1)
	{
		char strErr[256];
		sprintf(strErr,"NSgetFlag: Invalid face index.  Mesh only has %i faces.",numFaces);
		throw RuntimeError(strErr);
	}

	if (face<0)
		throw RuntimeError("NSgetFlag: Invalid face index.");

	FlagType nsflag;

	IFaceDataMgr* pFDMgr = static_cast<IFaceDataMgr*>(mesh->GetInterface( FACEDATAMGR_INTERFACE ));
	if( !pFDMgr )
		return &undefined;

	FaceFlagsData* fdc = dynamic_cast<FaceFlagsData*>( pFDMgr->GetFaceDataChan( vFACE_FLAGS_CHANNEL_ID ));
	if( fdc == NULL )
		return &false_value;

	fdc->GetValue(face, nsflag);

	// Check the status of the indicated flag
	if (nsflag & (1 << flag))
		return &true_value;

	return &false_value;
}

Value* NSfacePassEnabled_cf(Value **arg_list,int count)
{
	check_arg_count(NSfacePassEnabled, 3, count);

	// Do type checking
	type_check(arg_list[1], Integer, "< second parameter must be integer (referring to face number) >");
	type_check(arg_list[2], Integer, "< third parameter is the pass number 1-4 >");

	Mesh* mesh = arg_list[0]->to_mesh();
	int   face = arg_list[1]->to_int();
	int   pass = arg_list[2]->to_int();

	if (!mesh)
		throw RuntimeError("NSfacePassEnabled: first parameter is not a valid mesh");

	int numFaces = mesh->getNumFaces();
	if (face>numFaces-1)
	{
		char strErr[256];
		sprintf(strErr,"NSfacePassEnabled: Invalid face index.  Mesh only has %i faces.",numFaces);
		throw RuntimeError(strErr);
	}

	if (face<0)
		throw RuntimeError("NSfacePassEnabled: Invalid face index.");

	if (pass<1 || pass>4)
		throw RuntimeError("NSfacePassEnabled: The pass (param 3) is out of range (must be 1-4).");

	FlagType nsflag;

	IFaceDataMgr* pFDMgr = static_cast<IFaceDataMgr*>(mesh->GetInterface( FACEDATAMGR_INTERFACE ));
	if( !pFDMgr )
		return &undefined;

	FaceFlagsData* fdc = dynamic_cast<FaceFlagsData*>( pFDMgr->GetFaceDataChan( vFACE_FLAGS_CHANNEL_ID ));
	if( fdc == NULL )
		return &undefined;

	fdc->GetValue(face, nsflag);

	switch(pass)
	{
	case 1:
		if (!(nsflag & mFD_PASS_1_DISABLED))
			return &true_value;
		break;

	case 2:
		if (nsflag & mFD_PASS_2_ENABLED)
			return &true_value;
		break;

	case 3:
		if (nsflag & mFD_PASS_3_ENABLED)
			return &true_value;
		break;

	case 4:
		if (nsflag & mFD_PASS_4_ENABLED)
			return &true_value;
		break;
	}

	return &false_value;
}

Value* NSenablePass_cf(Value **arg_list,int count)
{
	check_arg_count(NSgetFlag, 3,count);
	
	// Do type checking
	type_check(arg_list[1], Integer, "< second parameter must be integer (referring to face number) >");
	type_check(arg_list[2], Integer, "< third parameter is the pass number 1-4 >");

	Mesh* mesh = arg_list[0]->to_mesh();
	int   face = arg_list[1]->to_int();
	int   pass = arg_list[2]->to_int();

	if (!mesh)
		throw RuntimeError("NSenablePass: first parameter is not a valid mesh");

	int numFaces = mesh->getNumFaces();
	if (face>numFaces-1)
	{
		char strErr[256];
		sprintf(strErr,"NSenablePass: Invalid face index.  Mesh only has %i faces.",numFaces);
		throw RuntimeError(strErr);
	}

	if (face<0)
		throw RuntimeError("NSenablePass: Invalid face index.");

	if (pass<1 || pass>4)
		throw RuntimeError("NSenablePass: The pass (param 3) is out of range (must be 1-4).");

	FlagType nsflag;

	IFaceDataMgr* pFDMgr = static_cast<IFaceDataMgr*>(mesh->GetInterface( FACEDATAMGR_INTERFACE ));
	if( !pFDMgr )
		return &undefined;

	FaceFlagsData* fdc = dynamic_cast<FaceFlagsData*>( pFDMgr->GetFaceDataChan( vFACE_FLAGS_CHANNEL_ID ));
	if( fdc == NULL )
	{
		// The mesh does not have our face-data channel so we will add it here
		fdc = new FaceFlagsData();
		fdc->FacesCreated( 0, mesh->getNumFaces());

		pFDMgr->AddFaceDataChan( fdc );
	}

	fdc->GetValue(face, nsflag);

	switch(pass)
	{
	case 1:
		nsflag &= ~mFD_PASS_1_DISABLED;
		break;
	case 2:
		nsflag |= mFD_PASS_2_ENABLED;
		break;
	case 3:
		nsflag |= mFD_PASS_3_ENABLED;
		break;
	case 4:
		nsflag |= mFD_PASS_4_ENABLED;
		break;
	}

	fdc->SetValue(face, nsflag);

	return &ok;
}

Value* NSdisablePass_cf(Value **arg_list,int count)
{
	check_arg_count(NSgetFlag, 3,count);
	
	// Do type checking
	type_check(arg_list[1], Integer, "< second parameter must be integer (referring to face number) >");
	type_check(arg_list[2], Integer, "< third parameter is the pass number 1-4 >");

	Mesh* mesh = arg_list[0]->to_mesh();
	int   face = arg_list[1]->to_int();
	int   pass = arg_list[2]->to_int();

	if (!mesh)
		throw RuntimeError("NSdisablePass: first parameter is not a valid mesh");

	int numFaces = mesh->getNumFaces();
	if (face>numFaces-1)
	{
		char strErr[256];
		sprintf(strErr,"NSdisablePass: Invalid face index.  Mesh only has %i faces.",numFaces);
		throw RuntimeError(strErr);
	}

	if (face<0)
		throw RuntimeError("NSdisablePass: Invalid face index.");

	if (pass<1 || pass>4)
		throw RuntimeError("NSdisablePass: The pass (param 3) is out of range (must be 1-4).");

	FlagType nsflag;

	IFaceDataMgr* pFDMgr = static_cast<IFaceDataMgr*>(mesh->GetInterface( FACEDATAMGR_INTERFACE ));
	if( !pFDMgr )
		return &undefined;

	FaceFlagsData* fdc = dynamic_cast<FaceFlagsData*>( pFDMgr->GetFaceDataChan( vFACE_FLAGS_CHANNEL_ID ));
	if( fdc == NULL )
	{
		// The mesh does not have our face-data channel so we will add it here
		fdc = new FaceFlagsData();
		fdc->FacesCreated( 0, mesh->getNumFaces());

		pFDMgr->AddFaceDataChan( fdc );
	}

	fdc->GetValue(face, nsflag);

	switch(pass)
	{
	case 1:
		nsflag |= mFD_PASS_1_DISABLED;
		break;
	case 2:
		nsflag &= ~mFD_PASS_2_ENABLED;
		break;
	case 3:
		nsflag &= ~mFD_PASS_3_ENABLED;
		break;
	case 4:
		nsflag &= ~mFD_PASS_4_ENABLED;
		break;
	}

	fdc->SetValue(face, nsflag);

	return &ok;
}

Value* NSgetMapUV_cf(Value **arg_list,int count)
{
	check_arg_count(NSgetFlag, 5,count);

	type_check(arg_list[1], Integer, "< second parameter must be integer specifying pass (1-4) >");

	Mtl* mtl = arg_list[0]->to_mtl();

	if (!mtl)
		throw RuntimeError("nsGetMapUV: Invalid material");

	int  pass = arg_list[1]->to_int();

	if (pass<1 || pass>4)
		throw RuntimeError("nsGetMapUV: Invalid pass (must be 1-4)");

	Mesh* mesh = arg_list[2]->to_mesh();

	if (!mesh)
		throw RuntimeError("nsGetMapUV: Invalid mesh");

	int  face = arg_list[3]->to_int();

	if (face<0)
		throw RuntimeError("nsGetMapUV: Invalid face id");

	int numFaces = mesh->getNumFaces();
	if (face>numFaces-1)
	{
		char strErr[256];
		sprintf(strErr,"nsGetMapUV: Invalid face index.  Mesh only has %i faces.",numFaces);
		throw RuntimeError(strErr);
	}


	int  vert = arg_list[4]->to_int();

	if (vert<1 || vert>3)
		throw RuntimeError("nsGetMapUV: Invalid vert ID (must be 1 - 3)");

	if (mtl->ClassID() == NEXT_MATERIAL_CLASS_ID)
	{
		INExtMaterial* next_mat = dynamic_cast<INExtMaterial*>(mtl);

		if (next_mat)
		{
			Texmap* tex = next_mat->GetTexmap(pass-1);

			if (tex && next_mat->MapEnabled(pass-1))
			{
				UVGen* uvgen = tex->GetTheUVGen();
				int    channel;

				if (uvgen)
				{
					// Map channels are only used if the UVGen is set to explicit
					if (uvgen->GetUVWSource()==UVWSRC_EXPLICIT)
						channel = tex->GetMapChannel();
					else
						channel = pass;
				}
				else
				{
					// No UVGen on material (assume incremental)
					channel = pass;
				}

				// Grab data for current channel
				TVFace* face_list  = mesh->mapFaces(channel);
				UVVert* tvert_list = mesh->mapVerts(channel);

				if (!face_list || !tvert_list)
				{
					face_list  = mesh->tvFace;
					tvert_list = mesh->tVerts;
				}

				if (!face_list || !tvert_list)
					return &undefined;				// Missing map coords

				return new Point3Value(tvert_list[face_list[face].t[vert-1]]);
			}
		}
	}

	return &undefined;
}

Value* NSbreak_cf(Value **arg_list,int count)
{
	__asm int 3;
	return &ok;
}
