//****************************************************************************
//* MODULE:         Tools/LibMaker
//* FILENAME:       libmaker.h
//* OWNER:          Gary Jesdanun
//* CREATION DATE:  1/29/2003
//****************************************************************************

#ifndef __LIBMAKER_H__
#define __LIBMAKER_H__

#include <stdlib.h>

#include <core/defines.h>
#include <core/support.h>

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

namespace IoUtils
{
	class CVirtualOutputFile;
}

struct SFileInfo
{
	int		fileSize;
	uint32	fileName;
	uint32	extName;

	char*	pDataBuf;
	int		patchAddress;
	int		patchOffset;
	char	debugName[_MAX_PATH];
};

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

class CLibMaker
{
public:
	CLibMaker();
	~CLibMaker();

public:
	bool			AddFile( const char* pFileName, uint32 fileNameChecksum, uint32 fileExtensionChecksum );
	bool			OutputFiles( IoUtils::CVirtualOutputFile* pOutputFile, bool reverseByteOrder );

protected:
	void			delete_files();

protected:
	enum
	{
		vMAX_FILES = 1024
	};

	SFileInfo		m_fileList[vMAX_FILES];
	int				m_numFiles;
};

void split_file_ext( const char* pSrcBuf, char* pFileBuf, char* pExtBuf );

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

#endif