/*
	ObjectIO.h
	Functions responsible for Reading and Posting NxObjects to/from memory
*/

#ifndef __OBJECTIO__
#define __OBJECTIO__

#include "WorldStructs.h"
#include "NxTexture.h"
#include "NxMaterial.h"

NxObject* ReadObject(void *pMem);
int  StoreObject(NxObject* obj, void *pMem);

void ReadTexture(NxTexture* pTexture, void *pMem);
int  StoreTexture(NxTexture* pTexture, void *pMem);

NxMaterial* ReadMaterial(void *pMem);
int  StoreMaterial(NxMaterial* pMtl, void *pMem);

#endif
