/*
	MemIO.cpp
	Functions for handling reading and writting datatypes from/to memory

	aml - 9-29-03
*/

#include "stdafx.h"
#include <string.h>

int WriteString(unsigned char** data, char* str)
{
	size_t size = strlen(str);

	memcpy(*data, &size, sizeof(int));
	(*data) += sizeof(int);
	memcpy(*data, (char*)str, size);
	(*data) += size;

	return (int)size;
}

void GetString(unsigned char** data, char* str)
{
	int   size;
	char* buf;

	memcpy(&size, *data, sizeof(int));
	(*data) += sizeof(int);
	buf = new char[size + 1];
	memcpy(buf, *data, size);
	buf[size] = '\0';
	(*data) += size;

	strcpy(str, buf);
	delete [] buf;
}

int GetStringSize(unsigned char** data)
{
	int size;
	memcpy(&size, *data, sizeof(int));

	return size + sizeof(int);
}  

int Write(unsigned char** data, unsigned int size, void* pSrcData)
{
	memcpy(*data, pSrcData, size);
	(*data) += size;

	return size;
}

void Read(unsigned char** data, unsigned int size, void* pDestData)
{
	memcpy(pDestData, *data, size);
	(*data) += size;
}
