#include <stdlib.h>
#include <fstream.h>
#include "Genlib/Utility.h"
#include "Genlib/VirtualFile.h"
#include <gel/scripting/parse.h>
#include <gel/scripting/symboltable.h>
#include <gel/scripting/array.h>
#include <gel/scripting/struct.h>
#include <gel/scripting/script.h>
#include <gel/scripting/checksum.h>
#include <gel/scripting/component.h>
#include "models.h"
#include "levelassetlister.h"

static void sOutputModel(const char *p_model_name)
{
	if (IsPed(p_model_name) || IsAnimal(p_model_name))
	{
		OutputPedFile(&theOutputPedFile, p_model_name);
	}
	else
	{
		AttemptOutputFile(&theOutputFile, p_model_name);
	}
}

void WriteModelFileNames()
{
	Script::CArray *p_node_array=Script::GetArray("NodeArray",Script::ASSERT);
	for (int i=0; i<p_node_array->GetSize(); ++i)
	{
		Script::CStruct *p_node=p_node_array->GetStructure(i);
		const char *p_model_name="";
		if (p_node->GetString("Model",&p_model_name))
		{
			sOutputModel(p_model_name);
		}
		if (p_node->GetString("ShadowModel",&p_model_name))
		{
			sOutputModel(p_model_name);
		}
	}
}
