#include <stdlib.h>
#include <fstream.h>
#include "Genlib/Utility.h"
#include "Genlib/VirtualFile.h"
#include <gel/scripting/parse.h>
#include <gel/scripting/symboltable.h>
#include <gel/scripting/array.h>
#include <gel/scripting/struct.h>
#include <gel/scripting/script.h>
#include <gel/scripting/checksum.h>
#include <gel/scripting/component.h>
#include "anims.h"
#include "levelassetlister.h"

static ELoadAnimDest sLoadAnimDest=PERM_ANIM_DATABASE;

void LoadAnimCommandsShouldWriteTo(ELoadAnimDest dest)
{
	sLoadAnimDest=dest;
}

bool ScriptLoadAnim(Script::CStruct *pParams, Script::CScript *pScript)
{
	const char *p_file_name="";
	pParams->GetString("name",&p_file_name);

	char p_full_file_name[_MAX_PATH];
	sprintf(p_full_file_name,"%s\\data\\%s",GetProjRoot(),p_file_name);
	strcat(p_full_file_name, GetPlatformExtension());

	switch (sLoadAnimDest)
	{
	case PERM_ANIM_DATABASE:
		thePermAnimDatabase.AddFile( p_full_file_name, 0 );
		break;
	case LEVEL_PRE_TXT_FILE:
		if (!AnimFileIsPermanentlyLoaded(p_full_file_name) &&
			TestExistence(p_full_file_name,__LINE__,false))
		{
			theOutputFile.WriteString( p_full_file_name, true );
		}
		break;
	default:
		break;
	}

	return true;
}
