/*
	InterMaxLink.cpp
	This DLL provides functions for facilitating access to a shared memory
	block between InterMax.gup and other Windows applications

	aml - 9-3-03
*/

#ifndef __INTERMAXLINK_H__
#define __INTERMAXLINK_H__

#include <windows.h>

#define  MULTIBLOCK_TRANS_HEADER_ID   0xFFFFFFFF	// Reserved NotifyCode for multi block initial header data
#define  MULTIBLOCK_TRANS_BLOCK_ID    0xFFFFFFFE	// Reserved NotifyCode for multi block segment transfer
#define  MULTIBLOCK_TRANS_ACK_ID      0xFFFFFFFD	// Reserved NotifyCode for multi block recieved acknowledge

unsigned int imlGetBlockSize();
bool imlGetBlockOwner(char* str, int size);
int imlRegisterClient(char* name, int (*cbNotify)(void*,DWORD,DWORD,int,int));
bool imlUnregisterClient();
bool imlUnregisterClientByID(int ID);
bool imlUnregisterClientByName(char* name);
bool imlIsClientRegistered(char* name);
void imlBroadcastClients(DWORD notifyCode, DWORD argSize, int arg1, int arg2);
void* imlLockSection(int clientID = -1);
bool imlUnlockSection(DWORD notifyCode, DWORD size, int arg1 = 0, int arg2 = 0);
bool imlAreClientsUpdated();
bool imlBlockAck();
bool imlWaitForReads(int timeout = 0);
void imlUpdate();
bool imlTransferBlock(int ID, void* pData, int size);
void imlEnumClients(bool (*func)(char* name));

#endif
