/******
shcommon.c
GameSpy Common Code for Shinobi
  
Copyright (c) 2000 GameSpy Industries, Inc

18002 Skypark Circle
Irvine, CA 92614
(949)798-4200
Fax (949)798-4299

******


******/


#include <shinobi.h>
#include "sg_sysrt.h"
#include "transport.h"
#include "states.h"

int test_main(int ,char**);

#define PROBE_DEVICES			(TR_DEVICE_DCLAN | TR_DEVICE_EXTMODEM	|	TR_DEVICE_SERIALPPP	| TR_DEVICE_INTMODEM)

static Uint32 gFrameCount;
static int		stack_state = 0, last_state = 0;	// Current state of the NexGenIP stack.
NetworkInfo3	*g_NetInfo;										// Used to store network connection info (flash RAM or manual).

//--------------------------------------------------------------------------------------//
// Debug Codes
//--------------------------------------------------------------------------------------//

#define	DEBUG_DEPTH		48
	char	debug_buffer	[DEBUG_DEPTH+1][64];
	int		debug_line	=	0;

void scrollup()
{
	// scroll window - ouch
	int n,m;
	for (n=1;n<=DEBUG_DEPTH;n++)
	{
		for (m=0;m<64;m++)
		debug_buffer[n-1][m]=debug_buffer[n][m];
	}
	debug_line=DEBUG_DEPTH;
	debug_buffer[debug_line][0]=0;
}

void NUMsg(char *in_format, ...)
{
	static char msg[8192];
	int n;
	va_list ap;
    char *p;

	va_start(ap, in_format);
	vsprintf(msg, in_format, ap);
	va_end(ap);

	n=0;
	// check if at bottom of window
	if (debug_line>DEBUG_DEPTH) scrollup();

	// scan through
	for (p = msg; *p !=0; p++)
	{
		if (*p == (char)10 || *p == (char)13 )
		{
			debug_buffer[debug_line][n] = 0;
			debug_line++;
			n=0;
			if (debug_line>DEBUG_DEPTH)
				scrollup();
		}
		else
			debug_buffer[debug_line][n++]= *p;
	}
	debug_buffer[debug_line][n++]=0;
	debug_line++;
}


//  Initialize Serial Terminal Settings
//
void	NUDebugInit(void)
{

	int	n,m;

	// no initialization
	debug_line=0;
	for (n=0;n<DEBUG_DEPTH;n++)
		for(m=0;m<64;m++)
			debug_buffer[n][m]	=	(char)0;


    NUMsg("\nDebug interface initialized...\n");
}


void	NUDebugRefresh()
{


	int n;
	for (n=0;n<DEBUG_DEPTH;n++)
	{
		njPrintC(NJM_LOCATION(4,n+8),&debug_buffer[n][0]);
	}

}


//void *vSyncCallbackProc(void)
void DrawScreen(void)
{
/**** -- if we prefer to print the time
	SYS_RTC_DATE date;
	Uint32 count;
	syRtcGetDate(&date);
	syRtcDateToCount(&date, &count);
	njPrint(NJM_LOCATION(30, 4),"%d/%d/%d %d:%d:%d (%d)",date.month,date.day, date.year,date.hour,date.minute,date.second,count);
*****/
	njPrintC(NJM_LOCATION(2, 4), "GameSpy Test Shell");
	njPrintH(NJM_LOCATION(30, 4), gFrameCount++, 8);
	njPrintC(NJM_LOCATION(2,8), "Press START to toggle connection");

	switch (stack_state)
	{
		default :
			njPrintC(NJM_LOCATION(2,6),"STATE : Nothing going on");
			break;
		case	TR_STATE_PROBE_DCLAN:
			njPrintC(NJM_LOCATION(2,6),"STATE : Probe LAN");
			break;
		case	TR_STATE_PROBE_EXTMODEM:
			njPrintC(NJM_LOCATION(2,6),"STATE : Probe Ext Modem");
			break;
		case	TR_STATE_PROBE_SERIALPPP:
			njPrintC(NJM_LOCATION(2,6),"STATE : Probe Serial");
			break;
		case	TR_STATE_PROBE_INTMODEM:
			njPrintC(NJM_LOCATION(2,6),"STATE : Probe Int Modem");
			break;
		case	TR_STATE_POLL_DEV:
			njPrintC(NJM_LOCATION(2,6),"STATE : Poll Dev");
			break;
		case	TR_STATE_RESET_DEV:
			njPrintC(NJM_LOCATION(2,6),"STATE : Reset Modem");
			break;
		case	TR_STATE_POLL_PPP:
			njPrintC(NJM_LOCATION(2,6),"STATE : Poll PPP");
			break;
		case	TR_STATE_CONNECTED:
			njPrintC(NJM_LOCATION(2,6),"STATE : Connected");
			break;
		case	TR_STATE_IDLE:
			njPrintC(NJM_LOCATION(2,6),"STATE : Idle");
			break;

	}

	NUDebugRefresh();
	//njWaitVSync();
}


void vSyncCallbackProc(void)
{

	gFrameCount++;

// Call the main connect loop function for extra processing time (important for socket code!)...
	if(stack_state == TR_STATE_CONNECTED)
		trYield();

}

static void WhileConnectedCallback(void)
{
}

static void DisconnectionCallback(void)
{
}

static void DeviceResetCallback(void)
{
}


static void DialFailCallback(void)
{
	
	NUMsg("\nDial fail: %d\n",trGetDisconnectReason());
}


void njUserInit(void)
{
	int						probe_devices;		// Bit-field used to select the devices to probe for.

	
	gFrameCount = 0;

    /* Check the cable for NTSC/PAL or VGA.. works properly for SCART. */
    switch (syCblCheck())
	{
	/* Initialize the display device and set the frame buffer based on the video mode. */
	case SYE_CBL_NTSC:  /* U.S./North America NTSC (60Hz) and Brazil PAL-M (60Hz). */
	    sbInitSystem (NJD_RESOLUTION_640x480_NTSCNI, NJD_FRAMEBUFFER_MODE_RGB565, 1);
	    break;
	case SYE_CBL_PAL:   /* Europe PAL (50Hz) and Argentina PAL-N (50Hz). */
	    sbInitSystem (NJD_RESOLUTION_640x544_PALNI, NJD_FRAMEBUFFER_MODE_RGB565, 1);
	    break;
	case SYE_CBL_VGA:   /* Standard VGA. */
	    sbInitSystem (NJD_RESOLUTION_VGA, NJD_FRAMEBUFFER_MODE_RGB565, 1);
	    break;
	default:
	    syBtExit();     /* Unknown video type, return to Dreamcast BootROM. */
	}
    njSetBorderColor( 0x00000000 ) ;
	njInitVertexBuffer(10000, 0, 100000, 0, 0);
	njInitPrint(NULL, 0, 0);
	njPrintSize(8);
	njSetBackColor(0x00008F00, 0x00008F00, 0x0000000);

	njSetVSyncFunction(vSyncCallbackProc);

    // NETWORK INITIALIZATION CODE

// Initialise the stack state machine...
	trInit(PROBE_DEVICES);

// Configure the state machine callbacks...
	trSetConnectionCallback(WhileConnectedCallback);
	trSetOnDisconnectCallback(DisconnectionCallback);
	trSetOnDeviceResetCallback(DeviceResetCallback);
	trSetOnDialFailureCallback(DialFailCallback);


// Enable NexGenIP debugging here if needed...
	//ngDebugSetLevel(0);
	//ngDebugSetModule(NG_DBG_PPP,		1);
  //ngDebugSetModule(NG_DBG_PPPOE,	1);
  //ngDebugSetModule(NG_DBG_DHCP,		1);

	NUDebugInit();

	
}

static void Connect(void)
{
	SYS_RTC_DATE			time;				// Stores the current time from the real-time clock.
	int								transport;	// Transport device chosen by the stack.
	int								err;

// Initialise the real-time clock functions...
	syRtcInit();
	syRtcGetDate(&time);

// Allocate memory to store the ISP network information...
	g_NetInfo = (NetworkInfo3 *)gsimalloc(sizeof(NetworkInfo3));

	if(!g_NetInfo)
	{
	#ifdef DEBUG
		ngPrintf("Could not allocate memory for the network info structure\n");
	#endif
		return;
	}

// Get the network info stored in flash RAM...
// (The NULL param instructs the library to dynamically allocate memory for the work area.)
	if(trGetFlashNetInfo(NULL, g_NetInfo) != NTD_OK)
		return;

// Ask the stack to choose the most appropriate transport device to use...
	transport = trChooseTransportDevice();


	syRtcFinish();		// Shutdown the real-time clock functions (no longer needed).
// Start the dial-up procedure...
	err						= trConnect(transport, g_NetInfo);	// 'TR_TRANSPORT_AUTO' could be passed here to tell the stack
																										//	to automatically select a suitable transport device.
	if(err)
	{
		trFreeFlashNetInfo();	// Free any memory dynamically allocated by the network info library.
		gsifree(g_NetInfo);
		g_NetInfo = NULL;
	}
}








// -------------- //
//  Disconnect()  //
// -------------- //
static void Disconnect()
{
	trDisconnect();	// Start the disconnection procedure.
}


/*===============================================================*/
/* Main loop of application.				     */
/*===============================================================*/

Sint32 njUserMain(void)
{
	const PDS_PERIPHERAL* per;
	Uint32 controller;

	char *args[]={""};

	last_state = stack_state;
	stack_state = trGetStackState();
	
	if (stack_state != last_state && stack_state == TR_STATE_CONNECTED)
		test_main(1 ,args);


// Pass idle CPU time to the NexGenIP stack while waiting for a Vsync...
	trYield();

	
	per = pdGetPeripheral(PDD_PORT_A0);
	
	if (per->press & NJD_DGT_ST)
	{
		(stack_state == TR_STATE_IDLE) ? Connect() : Disconnect();	// If not idle then connect, else disconnect.
	
	}
	DrawScreen();
	return NJD_USER_CONTINUE;
}


/*===============================================================*/
/* Finalize application					  */
/*===============================================================*/

void njUserExit(void)
{
	
	sbExitSystem();
	syBtExit();
}
