/******
qrcppsample.h
GameSpy Query & Reporting SDK C++ Sample App
  
Copyright 2000 GameSpy Industries, Inc

18002 Skypark Circle
Irvine, CA 92614
(949)798-4200
Fax(949)798-4299

******

 This source file includes a "sample" game shell which demonstrates
 how to use the GameSpy Query & Reporting SDK

 Please see the  GameSpy Query & Reporting SDK documentation for more 
 information

******/

#ifndef _QRCPPSAMPLE_H_
#define _QRCPPSAMPLE_H_


/********
INCLUDES
********/
#include <stdlib.h>
#include <stdio.h>
#define WIN32_LEAN_AND_MEAN
#include <conio.h>
#include <afx.h>
#include "..\gqueryreporting.h"

/********
DEFINES
********/
#define GAME_VERSION "2.00"
#define GAME_NAME "gmtest"
#define MAX_PLAYERS 32
#define BASE_PORT 26900


class CPlayer
{
public:

	CString pname;
	int pfrags;
	int pdeaths;
	int pskill;
	int pping;
	CString pteam;
	CPlayer();
	virtual ~CPlayer();


};

class CMyGame
{
private:
	CPlayer players[MAX_PLAYERS];
	CString mapname;
	CString hostname;
	CString gamemode;
	CString gametype;
	int locationid;
	int numplayers;
	int maxplayers;
	int fraglimit;
	int timelimit;
	int teamplay;
	int rankingson;
	int hostport;
	qr_t query_reporting_rec;
	void DoGameStuff(void);
public:
	void run();
	void basic_callback(char *outbuf, int maxlen); 
	void info_callback(char *outbuf, int maxlen);
	void rules_callback(char *outbuf, int maxlen);
	void players_callback(char *outbuf, int maxlen);
	CMyGame(char *hostname_);
	virtual ~CMyGame();

};

#endif