/******
qrcppsample.cpp
GameSpy Query & Reporting SDK C++ Sample App
  
Copyright 2000 GameSpy Industries, Inc

18002 Skypark Circle
Irvine, CA 92614
(949)798-4200
Fax(949)798-4299

******


 This source file includes a "sample" game shell which demonstrates
 how to use the GameSpy Query & Reporting SDK

 Please see the GameSpy Query & Reporting SDK documentation for more 
 information

******/

#include "qrcppsample.h"

//just to give us bogus data
char *constnames[MAX_PLAYERS]={"Joe Player","L33t 0n3","Raptor","Gr81","Flubber","Sarge","Void","runaway","Ph3ar","wh00t","gr1nder","Mace","stacy","lamby","Thrush"};


/*********
These c-style callback stubs are used by the SDK. The current game object
(passed in qr_init) is given in userdata, so we know what object to reference
**********/

void c_players_callback(char *outbuf, int maxlen, void *userdata)
{
	((CMyGame *)userdata)->players_callback(outbuf, maxlen);
}

void c_rules_callback(char *outbuf, int maxlen, void *userdata)
{
	((CMyGame *)userdata)->rules_callback(outbuf, maxlen);
}

void c_info_callback(char *outbuf, int maxlen, void *userdata)
{
	((CMyGame *)userdata)->info_callback(outbuf, maxlen);
}

void c_basic_callback(char *outbuf, int maxlen, void *userdata)
{
	((CMyGame *)userdata)->basic_callback(outbuf, maxlen);
}

/**********
A simple player object. Constructor just fills with bogus data
************/
CPlayer::CPlayer()
{
	int team;

	pfrags = rand() % 32;
	pdeaths = rand() % 32;
	pskill = rand() % 1000;
	pping = rand() % 500;
	team = rand() % 3;
	if (team == 0)
		pteam = "Red";
	else if (team == 1)
		pteam = "Blue";		
	else if (team == 2)
		pteam = "";
}

CPlayer::~CPlayer()
{
}

/***********
A simple game object. Consists of some data and a main loop function.
***********/
CMyGame::CMyGame(char *hostname_)
{
	int i;
	
	numplayers = rand() % 15;
	maxplayers = MAX_PLAYERS;
	for (i = 0 ; i < numplayers ; i++)
	{ //give the players some names
		players[i].pname = constnames[i];
	}
	mapname = "gmtmap1";
	gametype = "arena";
	hostname = hostname_;
	gamemode = "openplaying";
	fraglimit = 0;
	timelimit = 40;
	teamplay = 1;
	locationid = 1;
	rankingson = 1;
	hostport = 25000;

	char secret_key[9];
	//set the secret key, in a semi-obfuscated manner
	secret_key[0] = 'H';
	secret_key[1] = 'A';
	secret_key[2] = '6';
	secret_key[3] = 'z';
	secret_key[4] = 'k';
	secret_key[5] = 'S';
	secret_key[6] = '\0';
	
	if (qr_init(&query_reporting_rec,NULL,BASE_PORT,GAME_NAME, secret_key, c_basic_callback, 
		c_info_callback, c_rules_callback, c_players_callback, this) != 0)
	{
		printf("Error starting query sockets\n");
		return;
	}
}

CMyGame::~CMyGame()
{
	/*
	We don't really need to set the mode to exiting here, since we immediately
	send the statechanged heartbeat and kill off the query sockets 
	gamemode = "exiting";*/

	qr_send_exiting(query_reporting_rec);
	qr_shutdown(query_reporting_rec);
}

/*******
 DoGameStuff
Simulate whatever else a game server does 
********/
void CMyGame::DoGameStuff(void)
{
	Sleep(100);
}

/*******************
CMyGame::run
Simulates a main game loop
*****************/
void CMyGame::run()
{
	
	DoGameStuff();
	qr_process_queries(query_reporting_rec);
}

/*************
basic_callback
sends a (sample) response to the basic query 
includes the following keys:
\gamename\
\gamever\
\location\
*************/
void CMyGame::basic_callback(char *outbuf, int maxlen)
{

	sprintf(outbuf, "\\gamename\\%s\\gamever\\%s\\location\\%d",
			GAME_NAME,GAME_VERSION,locationid);
	printf("Basic callback, sent: %s\n\n",outbuf);
}

/************
info_callback
Sends a (sample) response to the info query 
including the following keys:
\hostname\
\hostport\
\mapname\
\gametype\
\numplayers\
\maxplayers\
\gamemode\
************/
void CMyGame::info_callback(char *outbuf, int maxlen)
{
	char keyvalue[200];

	sprintf(keyvalue,"\\hostname\\%s",hostname);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\hostport\\%d",hostport);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\mapname\\%s",mapname);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\gametype\\%s",gametype);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\numplayers\\%d",numplayers);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\maxplayers\\%d",maxplayers);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\gamemode\\%s",gamemode);
	strcat(outbuf, keyvalue);
	printf("Info callback, sent: %s\n\n",outbuf);

}

/***************
rules_callback
Sends a response to the rules query. You may
need to add custom fields for your game in here. Some are provided
as an example 
The following rules are included:
\timelimit\
\fraglimit\
\teamplay\
\rankedserver\
****************/
void CMyGame::rules_callback(char *outbuf, int maxlen)
{
	char keyvalue[80];

	sprintf(keyvalue,"\\timelimit\\%d",timelimit);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\fraglimit\\%d",fraglimit);
	strcat(outbuf, keyvalue);
	sprintf(keyvalue,"\\teamplay\\%d",teamplay);
	strcat(outbuf, keyvalue);
	//sample custom key/value
	sprintf(keyvalue,"\\rankedserver\\%d",rankingson);
	strcat(outbuf, keyvalue);
	printf("Rules callback, sent: %s\n\n",outbuf);

}

/***************
players_callback
sends the players and their information. 
Note that \ characters are not stripped out of player names. If
your game allows players or team names with the \ character, you will need
to strip or change it here. 
The following keys are included for each player:
\player_N\
\frags_N\
\deaths_N\
\skill_N\
\ping_N\
\team_N\
***************/
void CMyGame::players_callback(char *outbuf, int maxlen)
{
	char keyvalue[160];
	int i;

	for (i = 0; i < numplayers ; i++)
	{
		sprintf(keyvalue,
			"\\player_%d\\%s\\frags_%d\\%d\\deaths_%d\\%d\\skill_%d\\%d\\ping_%d\\%d\\team_%d\\%s",
			i, players[i].pname,
			i, players[i].pfrags,
			i, players[i].pdeaths,
			i, players[i].pskill,
			i, players[i].pping,
			i, players[i].pteam);
		strcat(outbuf, keyvalue);
	}
	printf("Players callback, sent: %s\n\n",outbuf);	

}
/************
We'll actually start up two completely seperate "game servers"
Each one initializes the Query & Reporting SDK and calls processs on it during
their main loop
************/

int main(int argc, char* argv[])
{
	CMyGame mygame1("Test Game Server 1"), mygame2("Test Game Server 2");

	srand( GetTickCount() );
	
	printf("Press any key to quit\n");
	while (!_kbhit())
	{
		mygame1.run();
		mygame2.run();
	}
	return 0;

}
