var GAMEID = 706;

var debug = new ActiveXObject("Statsmaster.DebugLog");
var it = new ActiveXObject("Statsmaster.IndexedTable");
var st = new ActiveXObject("Statsmaster.StringTable");
var fileSystem = new ActiveXObject("Scripting.FileSystemObject");
var plookup = new ActiveXObject("Statsmaster.PlayerInfoLookup");
var pastGames = new ActiveXObject("Statsmaster.PastGameResults");

var TIME_PERIOD		= 7;	// days

var LOG_SUCCESS 	= 0;
var LOG_ERROR 		= 1;
var LOG_WARNING 	= 2;
var LOG_INFORMATION = 4;

var CAT_GENERAL				= 0
// Column enumeration
var COL_NUM_GAMES     		= 0;
var COL_RATING				= 1;

// These column numbers are relative to the gametype column offsets above
var COL_HIGH_SCORE  		= 0;	
var COL_HIGH_COMBO  		= 1;
var COL_HIGH_SCORE_NICK		= 2;
var COL_HIGH_COMBO_NICK		= 3;

// Best day score columns
var COL_DAY_HIGH_SCORE 		= 0;	
var COL_DAY_HIGH_COMBO 		= 1;
var COL_DAY_HIGH_NICK		= 2;
var COL_DAY_HIGH_SCORE_LEVEL= 3;
var COL_DAY_HIGH_COMBO_LEVEL= 4;

//				 Load_NJ	 Load_NY	 Load_FL	 Load_SD	 Load_HI	 Load_VC	Load_SJ	   Load_RU	   Load_SE	   Load_VN	  Load_HN	  Load_SC2	 
var map_crcs = [ 0xf6c822d4, 0x7276630a, 0xd7720de9, 0xee1c63cf, 0x399bd4e8, 0xd0f0229, 0x9a44ec8, 0x9db7727c, 0x991b5359, 0x73be7e94, 0xa7ff414b, 0x8ca30405];
//					  nettrickattack	netgraffiti netscorechallenge	netcombomambo	netslap		netking		netgoalattack netctf	  netfirefight
var gametype_crcs = [ 0x30c2ffa3,		0x5e2ea50c, 0x1498240a, 		0xc50affd0,		0xf9d5d933, 0x6ef8fda0, 0xec200eaa,   0x6c5ff266, 0xbff33600 ];

function GenerateHighScoreMonthly()
{
	var i, j, k, map;
	var date = new Date();
	var ms = date.getTime();
	ms -= ( 1000 * 60 * 60 * 24 * TIME_PERIOD );	// subtract a week's-worth of ms

	var start_date = new Date();
	start_date.setTime( ms );
	var s = (start_date.getMonth() + 1) + "/";
	s += start_date.getDate() + "/";
	s += start_date.getYear();
	var s_date = start_date.getYear() + "-" + ( start_date.getMonth() + 1 ) + "-" + start_date.getDate();

	var start_day = Math.floor((((( ms / 1000 ) / 60 ) / 60 ) / 24 ));
	debug.LogString(GAMEID, LOG_INFORMATION, "Generating periodic high score file for day " + start_day );

	var filename = "thug/web/hs_mo.tmp";
    var file = fileSystem.CreateTextFile( filename, true);

	file.Write( s + "\n" );
	for( map = 0; map < map_crcs.length; map++ )
	{
		file.Write( "Level:" + map_crcs[map] + "\n" );
		// Sort by level, then by descending scores
		var rows = it.GetRows2( GAMEID, "profileid, c0, c2", "c0 desc", "catagoryid > " + start_day + " AND c0 > 0" + " AND c3 = " + map, 50, 0 );
		for( row = rows.lbound(2) ; row <= rows.ubound(2) ; row++)
		{
			var rating, score, index, name;

			pid = rows.getItem( 0, row );
			score = rows.getItem( 1, row );
			index = rows.getItem( 2, row );
			if( index > 0 )
			{
				rating = it.GetIntValue( GAMEID, pid, CAT_GENERAL, COL_RATING, 0 );
				name = st.GetString( index );
				file.Write( score + ":" + rating + ":" + name + "\n" );
			}
			
		}
	}

	file.Close();

	var out_filename = "thug/web/hs_mo.txt";
    fileSystem.CopyFile( filename, out_filename, true );
}
