 /*
GameSpy GHTTP SDK 
Dan "Mr. Pants" Schoenblum
dan@gamespy.com

Copyright 1999-2001 GameSpy Industries, Inc

18002 Skypark Circle
Irvine, California 92614
949.798.4200 (Tel)
949.798.4299 (Fax)
devsupport@gamespy.com
*/

#include <stdio.h>
#include <stdlib.h>
#if defined(applec) || defined(THINK_C) || defined(__MWERKS__) && !defined(__KATANA__) && !defined(__mips64)
	#include ":::nonport.h"
	#include "::ghttp.h"
#else
	#include "../../nonport.h"
	#include "../ghttp.h"
#endif

#ifdef __KATANA__
void NUMsg(char *in_format, ...);
#define printf NUMsg
#endif

#ifdef UNDER_CE
void RetailOutputA(CHAR *tszErr, ...);
#define printf RetailOutputA
#endif

static int finishedCount;
struct
{
	int started;
	GHTTPResult result;
} results[5];

static char * stateStrings[] =
{
	"Host Lookup",
	"Connecting",
	"Sending Request",
	"Posting",
	"Waiting",
	"Receiving Status",
	"Receiving Headers",
	"Receiving File"
};

static char * resultStrings[] =
{
	"GHTTPSuccess",
	"GHTTPOutOfMemory",
	"GHTTPBufferOverflow",
	"GHTTPParseURLFailed",
	"GHTTPHostLookupFailed",
	"GHTTPSocketFailed",
	"GHTTPConnectFailed",
	"GHTTPBadResponse",
	"GHTTPRequestRejected",
	"GHTTPUnauthorized",
	"GHTTPForbidden",
	"GHTTPFileNotFound",
	"GHTTPServerError",
	"GHTTPFileWriteFailed",
	"GHTTPFileReadFailed"
};

static GHTTPBool CompletedCallback
(
	GHTTPRequest request,
	GHTTPResult result,
	char * buffer,
	int bufferLen,
	void * param
)
{
	int index = (int)param;

	finishedCount--;

	// Save off the result.
	///////////////////////
	results[index].started = 1;
	results[index].result = result;

	// Check the result and print out some info.
	////////////////////////////////////////////
	if(result == GHTTPSuccess)
		printf("%d finished\n", index);
	else
		printf("%d failed: %s\n", index, resultStrings[result]);

	// Don't free this buffer, its from the stack.
	//////////////////////////////////////////////
	if(index == 1)
		return GHTTPFalse;

	// Free the buffer (if there is one).
	/////////////////////////////////////
	return GHTTPTrue;
}

void ProgressCallback
(
	GHTTPRequest request,
	GHTTPState state,
	const char * buffer,
	int bufferLen,
	int bytesReceived,
	int totalSize,
	void * param
)
{
	int index = (int)param;

	// Show the current state.
	//////////////////////////
	printf("%d state: %s", index, stateStrings[state]);

	// If we're receiving the file, show the progress.
	//////////////////////////////////////////////////
	if(state == GHTTPReceivingFile)
	{
		// Display based on if we know the total size.
		//////////////////////////////////////////////
		if(totalSize != -1)
			printf(" (%d / %d bytes)\n", bytesReceived, totalSize);
		else
			printf(" (%d bytes)\n", bytesReceived);
	}
	else
		printf("\n");
}

static GHTTPBool CheckRequest(GHTTPRequest request, int index)
{
	if(request == -1)
	{
		printf("FAILED TO START REQUEST %d\n", index);
		return GHTTPFalse;
	}

	return GHTTPTrue;
}

#if defined(__KATANA__) || defined(__mips64)
int test_main(int argc, char **argv)
#else
int main(int argc, char **argv)
#endif
{
	int i;
	char buffer[1024];
	GHTTPRequest request;

	// get a file
	request = ghttpGetFile(
		"http://planetquake.com/excessive/contest/servers.txt",
		GHTTPFalse,
		CompletedCallback,
		(void *)0);

	if(CheckRequest(request, 0))
		finishedCount++;
	else
		results[0].started = 0;

	// put a file into our own buffer, with progress updates
	request = ghttpGetFileEx(
		"http://planetquake.com/excessive/contest/info.txt",
		NULL,
		buffer, sizeof(buffer),
		NULL,
		GHTTPFalse,
		GHTTPFalse,
		ProgressCallback,
		CompletedCallback,
		(void *)1);
	
	if(CheckRequest(request, 1))
		finishedCount++;
	else
		results[1].started = 0;

	// download an image
	request = ghttpSaveFile(
		"http://www.planetquake.com/excessive/images/logo.gif",
		"excessive.gif",
		GHTTPFalse,
		CompletedCallback,
		(void *)2);
	
	if(CheckRequest(request, 2))
		finishedCount++;
	else
		results[2].started = 0;

	// download an excessive screenshot
	request = ghttpSaveFileEx(
		"http://www.planetquake.com/excessive/plutonium/12_large.jpg",
		"excessive.jpg",
		NULL,
		NULL,
		GHTTPFalse,
		GHTTPFalse,
		ProgressCallback,
		CompletedCallback,
		(void *)3);
	
	if(CheckRequest(request, 3))
		finishedCount++;
	else
		results[3].started = 0;

	// stream a page
	request = ghttpStreamFileEx(
		"toolshed.down.net",
		NULL,
		NULL,
		GHTTPFalse,
		GHTTPFalse,
		ProgressCallback,
		CompletedCallback,
		(void *)4);
	
	if(CheckRequest(request, 4))
		finishedCount++;
	else
		results[4].started = 0;

	do
	{
		ghttpThink();
		msleep(20);
	}
	while(finishedCount);

	ghttpCleanup();

	printf("Results:\n");
	for(i = 0 ; i < 5 ; i++)
	{
		if(results[i].started == 0)
			printf("%d: Failed to start\n", i);
		else
			printf("%d: %s\n", i, resultStrings[results[i].result]);
	}

	return 0;
}