/******
cecommon.c
GameSpy Common Code for Windows CE
  
Copyright (c) 2000 GameSpy Industries, Inc

18002 Skypark Circle
Irvine, CA 92614
(949)798-4200
Fax (949)798-4299

******


******/

#include "cecommon.h"

int main(int ,char**);

#pragma comment(lib, "mras")

typedef struct _RAS_STATE_STR
{
    DWORD dwRasState;
    LPTSTR szState;
} RAS_STATE_STR, *PRAS_STATE_STRING;

// Array of RAS status code --> String Representations.
RAS_STATE_STR g_rgrasstates[] =
{
    {RASCS_OpenPort,            TEXT("OpenPort")},
    {RASCS_PortOpened,          TEXT("PortOpened")},
    {RASCS_ConnectDevice,       TEXT("ConnectDevice")},
    {RASCS_DeviceConnected,     TEXT("DeviceConnected")},
    {RASCS_AllDevicesConnected, TEXT("AllDevicesConnected")},
    {RASCS_Authenticate,        TEXT("Authenticate")},
    {RASCS_AuthNotify,          TEXT("AuthNotify")},
    {RASCS_AuthRetry,           TEXT("AuthRetry")},
    {RASCS_AuthCallback,        TEXT("AuthCallback")},
    {RASCS_AuthChangePassword,  TEXT("AuthChangePassword")},
    {RASCS_AuthProject,         TEXT("AuthProject")},
    {RASCS_AuthLinkSpeed,       TEXT("AuthLinkSpeed")},
    {RASCS_AuthAck,             TEXT("AuthAck")},
    {RASCS_ReAuthenticate,      TEXT("ReAuthenticate")},
    {RASCS_Authenticated,       TEXT("Authenticated")},
    {RASCS_PrepareForCallback,  TEXT("PrepareForCallback")},
    {RASCS_WaitForModemReset,   TEXT("WaitForModemReset")},
    {RASCS_WaitForCallback,     TEXT("WaitForCallback")},
    {RASCS_Projected,           TEXT("Projected")},
    {RASCS_Interactive,         TEXT("Interactive")},
    {RASCS_RetryAuthentication, TEXT("RetryAuthentication")},
    {RASCS_CallbackSetByCaller, TEXT("CallbackSetByCaller")},
    {RASCS_PasswordExpired,     TEXT("PasswordExpired")},
    {RASCS_Connected,           TEXT("Connected")},
    {RASCS_Disconnected,        TEXT("Disconnected")},
    {(DWORD)-1,                 TEXT("Unknown RAS Connection State")}
};


HWND      g_hwndApp = 0;                                // HWND of the application
HRASCONN  g_hrasconn = 0;


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Function:

    RetailOutput

Description:

    Simple Retail Output mechanism.  If the function outputs
    the passed-in String and variables to the debug output stream.

Arguments:

    TCHAR *tszDest       - TEXT String to output

    ... (variable arg)   - List of variable arguments to embed in output
                           (similar to printf format)

Return Value:

    None

-------------------------------------------------------------------*/

void RetailOutput(TCHAR *tszErr, ...)
{
    TCHAR tszErrOut[1024];

    va_list valist;

    va_start (valist,tszErr);
    wvsprintf (tszErrOut, tszErr, valist);
    OutputDebugString (tszErrOut);

    va_end (valist);
}

void RetailOutputA(CHAR *tszErr, ...)
{
    CHAR tszErrOut[1024];
	WCHAR wszErrOut[1024];

    va_list valist;

    va_start (valist,tszErr);
    vsprintf (tszErrOut, tszErr, valist);
	MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,tszErrOut,-1,wszErrOut,1024);
    OutputDebugString (wszErrOut);

    va_end (valist);
}



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Function:

    GetStateStr

Description:

    Converts the passed-in RAS state code to it's string representation

Arguments:

    DWORD dwState       - State to convert to string representation
  
Return Value:

    String representation of 'dwState'

-------------------------------------------------------------------*/
LPTSTR
GetStateStr(DWORD dwState)
{
    DWORD i;

    for (i = 0; g_rgrasstates[i].dwRasState != (DWORD)-1; i++)
    {
        if (g_rgrasstates[i].dwRasState == dwState)
            break;
    }

    return g_rgrasstates[i].szState;
}



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Function:

    WndProc

Description:

    Window message processing routine for the main application window.
    The main purpose of this function is to exit the app when the user
    presses <Escape> or <F12>.

Arguments:

    HWND hWnd           - Window handle

    UINT uMessage       - Message identifier
  
    WPARAM wParam       - First message parameter
    
    LPARAM lParam       - Second message parameter
  
Return Value:

    Zero if the message was processed.  The return value from 
    DefWindowProc otherwise.

-------------------------------------------------------------------*/
LRESULT CALLBACK
WndProc(HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam)
{
    RASCONNSTATE RasState;

    switch (uMessage)
    {
    case WM_RASDIALEVENT:
        RasState = (RASCONNSTATE)wParam;

        switch (RasState)
        {
        case RASCS_AuthNotify:
            RetailOutput(TEXT("%s: Ecode=%d"), GetStateStr(RasState), lParam);
            switch (lParam) {
                case ERROR_RESTRICTED_LOGON_HOURS:
                    RetailOutput(TEXT("\tAUTH_ERR_REST_HOUR"));
                    break;

                case ERROR_ACCT_DISABLED:
                    RetailOutput(TEXT("\tAUTH_ERR_ACCT_DISABLED"));
                    break;

                case ERROR_PASSWD_EXPIRED:
                    RetailOutput(TEXT("\tAUTH_ERR_PWD_EXP"));
                    break;

                case ERROR_NO_DIALIN_PERMISSION:
                    RetailOutput(TEXT("\tAUTH_ERR_NO_DIALIN"));
                    break;

                case ERROR_CHANGING_PASSWORD:
                    RetailOutput(TEXT("\tAUTH_ERR_CHG_PWD"));
                    break;

                default:
                    RetailOutput(TEXT("\tAUTH_ERR_UNKNOWN"));
            }
            break;

        case RASCS_Connected:
            RetailOutput(TEXT("Connected"));
//            g_fExit = TRUE;
            break;

        case RASCS_Disconnected:
            RetailOutput(TEXT("Disconnected: Ecode %d"), lParam);
 //           g_fExit = TRUE;
            break;

        default:
            RetailOutput(GetStateStr(RasState));
            break;
        }
        RetailOutput(TEXT("\n"));
        break;

    case WM_KEYDOWN:
        switch (wParam)
        {
        case VK_ESCAPE:
        case VK_F12:
			PostQuitMessage(0);
            return 0;
        } 
        break;

    case WM_DESTROY:
        PostQuitMessage(0);
        return 0L;

    } 

    return DefWindowProc (hWnd, uMessage, wParam, lParam);
}


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Function:

    AppInit

Description:

    This function registers a window class, and creates a window for
    the application.

Arguments:

    hPrev               - Hinstance of another process running the program

    nCmdShow            - Whether the app should be shown (ignored)

Return Value:

    TRUE on success, FALSE on failure.

-------------------------------------------------------------------*/
BOOL 
AppInit(HINSTANCE hCurr, HINSTANCE hPrev, int nCmdShow)
{
    WNDCLASS cls;          

    if (!hPrev)
    {
        //  Register a class for the main application window
        cls.hCursor        = NULL;
        cls.hIcon          = NULL;
        cls.lpszMenuName   = NULL;
        cls.hbrBackground  = NULL;
        cls.hInstance      = hCurr;
        cls.lpszClassName  = TEXT("cecommon");
        cls.lpfnWndProc    = (WNDPROC)WndProc;
        cls.style          = 0;
        cls.cbWndExtra     = 0;
        cls.cbClsExtra     = 0;

        if (!RegisterClass(&cls))
            return FALSE;
    }

    g_hwndApp = CreateWindowEx (0, TEXT("cecommon"), TEXT("cecommon"), WS_VISIBLE, 
                                0, 0, 640, 480, NULL, NULL, hCurr, NULL);

    return TRUE;
}

BOOL BeginRasDial(LPTSTR szDialEntry, HINSTANCE hCurr, HINSTANCE hPrev)
{
	RASDIALPARAMS rasdialparams;
	BOOL fPassword;
	DWORD ret;
	BYTE          byRasConnData[10 * sizeof(RASCONN)];
	RASCONN       *prasconn;
	DWORD         nConnections, nSize,i;
	RASCONNSTATUS connstatus;

// Get the current number of RAS connections
    prasconn = (RASCONN*)byRasConnData;
    prasconn->dwSize = sizeof(RASCONN);
    nConnections = 0;
    nSize = sizeof(byRasConnData);
    if (RasEnumConnections(prasconn, &nSize, &nConnections) != SUCCESS)
    {
        RetailOutput(TEXT("Error in RasEnumConnections (0x%08x)\r\n"), GetLastError());
        return FALSE;
    }

	if (nConnections > 0) //we already have a connection, we can just reuse it
	{
		for (i = 0; i < nConnections; i++)
        {
			if (!_tcscmp(szDialEntry, prasconn[i].szEntryName))
			{
				connstatus.dwSize = sizeof(connstatus);
				RasGetConnectStatus(prasconn[i].hrasconn,&connstatus);
				if (connstatus.rasconnstate == RASCS_Connected)
				{
					g_hrasconn = prasconn[i].hrasconn;
					return TRUE;
				} else
					RasHangUp(prasconn[i].hrasconn);
			}
		}
	}

    memset(&rasdialparams, 0, sizeof(rasdialparams));
    rasdialparams.dwSize = sizeof(rasdialparams);

	if (g_hrasconn != 0)
	{
		RetailOutput(TEXT("Already connected! Use HANGUP first!"));
		return FALSE;
	}

	lstrcpy(rasdialparams.szEntryName,szDialEntry);
     // Load the dial params for this entry
    ret = RasGetEntryDialParams(NULL, &rasdialparams, &fPassword);
	if (ret != 0)
	{
		RetailOutput(TEXT("Unable to open Dial Entry, %d\r\n"),ret);
		return FALSE;
	}
	RetailOutput(TEXT("Opened RasEntry '%s', UserName='%s' PW='%s' Domain='%s'\n"),
                       rasdialparams.szEntryName, rasdialparams.szUserName,
                        rasdialparams.szPassword, rasdialparams.szDomain);

	if (g_hwndApp == 0)
	{
        // Call initialization procedure
        if (!AppInit(hCurr, hPrev,SW_SHOW))
            return FALSE;
	}
    if (RasDial(NULL, NULL, &rasdialparams, 0xFFFFFFFF, g_hwndApp, &g_hrasconn) != SUCCESS)
    {
		RetailOutput(TEXT("Error - failure in RasDial\r\n"));
		return FALSE;
	}
    RetailOutput(TEXT("RasDial successful, hRasConn = 0x%08x\r\n"), g_hrasconn); 
	return TRUE;
}

BOOL WaitForRASConnect()
{
	RASCONNSTATUS connstatus;
    MSG           msg;

	if (g_hrasconn == 0)
		return FALSE;
	while (1)
	{
		if (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
        {
                // There's a message waiting in the queue for us.  Retrieve
                // it and dispatch it, unless it's a WM_QUIT.
			if (msg.message == WM_QUIT)
				break;
            TranslateMessage(&msg); 
            DispatchMessage(&msg);
        }
		connstatus.dwSize = sizeof(connstatus);
		RasGetConnectStatus(g_hrasconn,&connstatus);
		if (connstatus.rasconnstate == RASCS_Connected)
			return TRUE;
		else if (connstatus.rasconnstate == RASCS_Disconnected)
			return FALSE;
	}
	return FALSE;
}

int APIENTRY 
WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR pCmdLine, int nCmdShow)
{
	char fakecmdline[1][1]={""};

	if (BeginRasDial(TEXT("ISP0"),hInstance,hPrevInstance))
	{
		if (WaitForRASConnect())
		{
			RetailOutput(TEXT("CONNECTED VIA RAS!!\r\n"));
			main(0,(char **)fakecmdline);
			/* note: we don't hang up at this point so we can run again
			immediately without having to redial */
			return 0;



		}

	}
	RetailOutput(TEXT("UNABLE TO CONNECT!!\r\n"));
	return 0;

}