// rigidbodysounds.q
// Contains structures which define the sound setups available for rigidbodies.

// Additional rigidbody specific sound parameters are as follows.  All have default values which should work well for most situations:
// CollideMuteDelay:
//		number of milliseconds after a skater collision sounds before another skater collision sound can be played by that rigidbody
// GlobalCollideMuteDelay:
//		number of milliseconds after a skater collision sounds before another skater collision sound can be played by any rigidbody
// BounceVelocityCallbackThreshold:
//		bounce velocity in inches per second below which bounce sounds are not played
// BounceVelocityFullSpeed:
//		bounce velocity in inches per second which generates a maximum volume sound
//
// These parameters can be added to a sound setup structure as so:
//	TrashCan = {
//		CollideSound	= { GrindMetalOff02		minVol=0	maxVol=100	minPitch=80	maxPitch=100 }
//		BounceSound		= { GrindMetalOn02		minVol=0	maxVol=100	minPitch=90	maxPitch=120 }
//		BounceVelocityCallbackThreshold = 20
//	}

RigidBodySounds = {
	
	Default = {
		// CollideSound	= { }
		// BounceSound		= { }
	}

	MetalTrashCan = {
		CollideSound	= { HitMetalCan  minVol=90	maxVol=200	minPitch=90	maxPitch=120 }
		BounceSound		= { Bouncy_MetalTrashHit02  minVol=50	maxVol=180	minPitch=60	maxPitch=100 }
		BounceVelocityCallbackThreshold = 40
		BounceVelocityFullSpeed = 400
	}
	
	SkaterBoardWhenBail = {
		// CollideSound	= // no Collide Sound!
		BounceSound		= { BoardBounce01 minVol=10 maxVol=90 minpitch=80 maxpitch=130 }
		BounceVelocityCallbackThreshold = 40
		;BounceVelocityFullSpeed = 300
	}
	
	Metal50GalDrum = {
		CollideSound	= { Bouncy_MetalDrumHit01  minVol=200	maxVol=250	minPitch=100	maxPitch=130 }
		BounceSound		= { Bouncy_MetalDrumHit02  minVol=100	maxVol=180	minPitch=60	maxPitch=100 }
		BounceVelocityCallbackThreshold = 40
		BounceVelocityFullSpeed = 300
	}
	
	AluminumCan = {
		CollideSound	= { Bouncy_AluminumCanHit01 minVol=175	maxVol=250	minPitch=100	maxPitch=150 }
		BounceSound		= { Bouncy_AluminumCanHit02 minVol=50	maxVol=150	minPitch=100	maxPitch=120 }
		BounceVelocityCallbackThreshold = 20
	}
		
	MetalChair = {
		CollideSound	= { Bouncy_MetalChairHit01 minVol=200	maxVol=300	minPitch=100	maxPitch=150 }
		BounceSound		= { Bouncy_MetalChairHit02 minVol=50	maxVol=100	minPitch=100	maxPitch=200 }
		CollideMuteDelay = 500
		BounceVelocityCallbackThreshold = 40
	}
	
	PlasticTrashCan = {
		CollideSound	= { Bouncy_PlasticHit03  minVol=200	maxVol=250	minPitch=120	maxPitch=130 }
		BounceSound		= { Bouncy_PlasticHit02 minVol=100	maxVol=180	minPitch=40	maxPitch=80 }
		BounceVelocityCallbackThreshold = 40
		BounceVelocityFullSpeed = 300
	}

	
	Plastic50GalDrum = {
		// CollideSound	= { }
		// BounceSound		= { }
	}
	
	PlasticChair = {
		// CollideSound	= { }
		// BounceSound		= { }
	}
	
	SmallTrafficCone = {
		CollideSound	= { Bouncy_OrangeConeHit01		minVol=120	maxVol=160	minPitch=110	maxPitch=130 }
		BounceSound		= { Bouncy_OrangeConeHit01		minVol=30	maxVol=100	minPitch=90	maxPitch=100 }
		BounceVelocityCallbackThreshold = 30
	}
	
	BigTrafficCone = {
		CollideSound	= { Bouncy_OrangeConeHit01		minVol=120	maxVol=220	minPitch=80	maxPitch=90 }
		BounceSound		= { Bouncy_OrangeConeHit01		minVol=30	maxVol=100	minPitch=40	maxPitch=70 }
		BounceVelocityCallbackThreshold = 30
	}
	
	WoodSign = {
		// CollideSound	= { }
		// BounceSound		= { }
	}
	
	WoodChair = {
		// CollideSound	= { }
		// BounceSound		= { }
	}
	
	WoodTrafficBarrier = {
		
	
	}
	
	Wood50GalBarrel = {
		CollideSound	= { Bouncy_WoodenBarrelHit01  minVol=150	maxVol=250	minPitch=70	maxPitch=100 }
		BounceSound		= { Bouncy_WoodenBarrelHit02  minVol=60	maxVol=150	minPitch=50	maxPitch=80 }
		BounceVelocityCallbackThreshold = 40
		BounceVelocityFullSpeed = 400
	
	}
	
	Basketball = {
		CollideSound	= { Bouncy_BasketballHit01 	minVol=100	maxVol=160	minPitch=110	maxPitch=130 }
		BounceSound		= { Bouncy_BasketballHit01 	minVol=50	maxVol=100	minPitch=60	maxPitch=110 }
		BounceVelocityCallbackThreshold = 50
	}
	
	RedRubberRecessBall = {
		// CollideSound	= { }
		// BounceSound		= { }
	}
	
	BigPottedPlant = {
		// CollideSound	= { }
		// BounceSound		= { }
	}
	
	SmallPottedPlant = {
		// CollideSound	= { }
		// BounceSound		= { }
	}
	
	CardboardBox = {
		CollideSound	= { Bouncy_CardboardBoxHit01		minVol=120	maxVol=160	minPitch=110	maxPitch=130 }
		BounceSound		= { Bouncy_CardboardBoxHit02		minVol=30	maxVol=100	minPitch=90	maxPitch=100 }
		BounceVelocityCallbackThreshold = 30
	}
	
	BottleNonBreak = {
		CollideSound	= { Bouncy_BottleNonBreakHit01		minVol=120	maxVol=160	minPitch=110	maxPitch=130 }
		BounceSound		= { Bouncy_BottleNonBreakHit02		minVol=30	maxVol=100	minPitch=90	maxPitch=110 }
		BounceVelocityCallbackThreshold = 50
	}
	
	
	
	
	
	
	
	
	
	
	
	//
	//
	//		**** Level Specific ****
	//
	//
	
	
	NJ_RubberDuck = {
		CollideSound	= { Bouncy_RubberDuckHit01 minVol=80	maxVol=130	minPitch=100	maxPitch=120 }
		BounceSound		= { Bouncy_RubberDuckHit01 minVol=30	maxVol=100	minPitch=90	maxPitch=100 }
		BounceVelocityCallbackThreshold = 20
	}
	
	NJ_Tombstone = {
		CollideSound	= { Bouncy_TombstoneHit01  minVol=60	maxVol=120	minPitch=80	maxPitch=140 }
		BounceSound		= { Bouncy_TombstoneHit02  minVol=30	maxVol=90	minPitch=50	maxPitch=150 }
		BounceVelocityCallbackThreshold = 40
		GlobalCollideMuteDelay = 20
		CollideMuteDelay = 500
	}
	
	NY_FlimsyConstructionSign = {
	
    }
	
	NY_SmallMetalSign = {
	
	}
	
	NY_CartUmbrellas = {
	
	}
	
	FL_BeachBall = {
		CollideSound	= { Bouncy_BeachBallHit02 	minVol=150	maxVol=250	minPitch=110	maxPitch=130 }
		BounceSound		= { Bouncy_BeachBallHit02 	minVol=80	maxVol=130	minPitch=100	maxPitch=110 }
		BounceVelocityCallbackThreshold = 50
	}
	
	SD_HeavyStoneTrash = {
		//CollideSound	= { Bouncy_TombstoneHit02  minVol=80	maxVol=250	minPitch=40	maxPitch=60 }
		//BounceSound		= { Bouncy_TombstoneHit02  minVol=50	maxVol=200	minPitch=50	maxPitch=150 }
		//BounceVelocityCallbackThreshold = 40
		//GlobalCollideMuteDelay = 20
		//CollideMuteDelay = 500
	
	}
	
	HI_LargeTiki = {
		CollideSound	= { Bouncy_WoodenBarrelHit02  minVol=150	maxVol=250	minPitch=70	maxPitch=100 }
		BounceSound		= { Bouncy_WoodenBarrelHit02  minVol=60	maxVol=150	minPitch=50	maxPitch=80 }
		BounceVelocityCallbackThreshold = 40
		BounceVelocityFullSpeed = 400
	}
	
	HI_MedTiki = {
		CollideSound	= { Bouncy_WoodenBarrelHit02  minVol=100	maxVol=150	minPitch=90	maxPitch=120 }
		BounceSound		= { Bouncy_WoodenBarrelHit02  minVol=30	maxVol=60	minPitch=70	maxPitch=100 }
		BounceVelocityCallbackThreshold = 40
		BounceVelocityFullSpeed = 400
	}
	
	HI_SmallTiki = {
		CollideSound	= { Bouncy_WoodenBarrelHit02  minVol=80	maxVol=120	minPitch=110	maxPitch=130 }
		BounceSound		= { Bouncy_WoodenBarrelHit02  minVol=20	maxVol=50	minPitch=100	maxPitch=130 }
		BounceVelocityCallbackThreshold = 40
		BounceVelocityFullSpeed = 400
	}
	
	HI_PlasticChair = {
		CollideSound	= { Bouncy_PlasticChairHit01  minVol=100	maxVol=130	minPitch=90	maxPitch=110 }
		BounceSound		= { Bouncy_PlasticChairHit02  minVol=60	maxVol=150	minPitch=90	maxPitch=110 }
		BounceVelocityCallbackThreshold = 40
		BounceVelocityFullSpeed = 400
	
	}
	
	HI_PlasticLoungeChair = {
		CollideSound	= { Bouncy_MetalChairHit02  minVol=150	maxVol=225	minPitch=90	maxPitch=110 }
		BounceSound		= { Bouncy_MetalChairHit03  minVol=80	maxVol=120	minPitch=50	maxPitch=110 }
		BounceVelocityCallbackThreshold = 40
		//BounceVelocityFullSpeed = 400
	
	}
	
	HI_Umbrellas = {
		CollideSound	= { Bouncy_UmbrellaHit01  minVol=120	maxVol=200	minPitch=90	maxPitch=110 }
		BounceSound		= { Bouncy_UmbrellaHit02  minVol=60	maxVol=100	minPitch=90	maxPitch=110 }
		BounceVelocityCallbackThreshold = 40
		//BounceVelocityFullSpeed = 400
	}
	
	HI_PottedPlant = {
		CollideSound	= { BonkBush  minVol=100	maxVol=180	minPitch=90	maxPitch=110 }
		BounceSound		= { BonkBush  minVol=20	maxVol=80	minPitch=90	maxPitch=110 }
		BounceVelocityCallbackThreshold = 40
		BounceVelocityFullSpeed = 400
	}
	
	HI_BarStool = {
		CollideSound	= { Bouncy_MetalHit01  minVol=80	maxVol=140	minPitch=110	maxPitch=130 }
		BounceSound		= { Bouncy_MetalHit01  minVol=20	maxVol=80	minPitch=100	maxPitch=110 }
		BounceVelocityCallbackThreshold = 40
		//BounceVelocityFullSpeed = 400
	
	}
	
	HI_Table = {
		CollideSound	= { Bouncy_MetalHit01  minVol=100	maxVol=180	minPitch=90	maxPitch=110 }
		BounceSound		= { Bouncy_MetalHit01  minVol=20	maxVol=80	minPitch=90	maxPitch=110 }
		BounceVelocityCallbackThreshold = 40
		
	
	}
	
	RU_Snowman = {
		CollideSound	= { Bouncy_SnowmanHit01 	minVol=80	maxVol=120	minPitch=180	maxPitch=210 }
		BounceSound		= { Bouncy_SnowmanHit01 	minVol=30	maxVol=60	minPitch=120	maxPitch=150 }
		BounceVelocityCallbackThreshold = 50
	
	}
	
	
}


