;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	Level Flags used in the levels
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
// IMPORTANT: Flags from 0-63 will get reset each time the level
// is loaded.
// Flags from 64-127 will be persistent, and will be saved to the memory
// Card
// Any flags defined above 127 will be COMMON to all levels and should not
// be used by designers for individual levels

// LEVEL INDEPENDENT FLAGS
// these flags are used to tell if the Proset objects are on for a particular level
// see gamemenu.q, the Pro trick Objects section
FLAG_G_COMP_GEO_ON			=128
FLAG_PROSET1_GEO_ON			=129
FLAG_PROSET2_GEO_ON			=130
FLAG_PROSET3_GEO_ON			=131
FLAG_PROSET4_GEO_ON			=132
FLAG_PROSET5_GEO_ON			=133
FLAG_PROSET6_GEO_ON			=134
FLAG_PROSET7_GEO_ON			=135




//--------------------------//
// SF2 Specific Level Flags //
//--------------------------//

FLAG_SF2_PAYLOADS_OUT   =   0
FLAG_SF2_SEAL_SPOT01    =   1
FLAG_SF2_SEAL_SPOT02    =   2
FLAG_SF2_SEAL_SPOT03    =   3
FLAG_SF2_SEAL_SPOT04    =   4
FLAG_SF2_BOX01_MOVED    =   5
FLAG_SF2_BOX02_MOVED    =   6
FLAG_SF2_BOX03_MOVED    =   7
FLAG_SF2_BOX04_MOVED    =   8

                     
Script ResetLevelFlags 
	// loop through flags 0-63 and set them back to defaults
	<flag_num>=0
	begin
		UnSetFlag flag = <flag_num>
		<flag_num>=(<flag_num> + 1)
	repeat 64
Endscript


// *******************************
//		cash flags
// *******************************

LEVEL_CASH_ICON_1	= 64
LEVEL_CASH_ICON_2	= 65
LEVEL_CASH_ICON_3	= 66
LEVEL_CASH_ICON_4	= 67
LEVEL_CASH_ICON_5	= 68
LEVEL_CASH_ICON_6	= 69
LEVEL_CASH_ICON_7	= 70
LEVEL_CASH_ICON_8	= 71
LEVEL_CASH_ICON_9	= 72
LEVEL_CASH_ICON_10	= 73
LEVEL_CASH_ICON_11	= 74
LEVEL_CASH_ICON_12	= 75
LEVEL_CASH_ICON_13	= 76
LEVEL_CASH_ICON_14	= 77
LEVEL_CASH_ICON_15	= 78
LEVEL_CASH_ICON_16	= 79
LEVEL_CASH_ICON_17	= 80
LEVEL_CASH_ICON_18	= 81
LEVEL_CASH_ICON_19	= 82
LEVEL_CASH_ICON_20	= 83
LEVEL_CASH_ICON_21	= 84
LEVEL_CASH_ICON_22	= 85
LEVEL_CASH_ICON_23	= 86
LEVEL_CASH_ICON_24	= 87
LEVEL_CASH_ICON_25	= 88

