
;ICON_ON_VALUE = DE_ICON_ON_VALUE
;OPTION_ON_VALUE = DE_OPTION_ON_VALUE

UNHIGHLIGHTED_TEXT_COLOR = DE_UNHIGHLIGHTED_TEXT_COLOR
HIGHLIGHTED_TEXT_COLOR = DE_HIGHLIGHTED_TEXT_COLOR
HIGHLIGHT_BAR_COLOR = DE_HIGHLIGHT_BAR_COLOR
MENU_TITLE_COLOR = DE_MENU_TITLE_COLOR


// DE Theme
DE_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[50 80 112 100] // entry 10 goal ped talking color
]

DE_HUD_COLOR = [118 30 2 98]
DE_BALANCE_METER_COLOR = [118 30 2 90]
DE_BALANCE_ARROW_COLOR = [100 100 100 128]
DE_HUD_SPECIAL_COLOR   = [128 128 128 78]
DE_SPECIAL_BAR_COLORS=[
	[128 0 9 128]
	[128 128 128 78]
	[128 0 9 128]
]

DE_ICON_ON_VALUE = [118 30 2 98]
DE_BOX_ICON_COLOR = [128 40 12 108]
DE_ICON_TWITCH_VALUE = [118 87 9 128]
DE_SUBMENU_TITLE_ICON_COLOR = [128 40 12 88]

DE_GRADIENT_VALUE = [118 30 2 80]
DE_BG_PARTS_COLOR = [128 30 12 98]

DE_TEXT_TWITCH_VALUE = [121 79 5 128]
DE_HIGHLIGHTED_TEXT_COLOR = [128 30 12 108]
DE_UNHIGHLIGHTED_TEXT_COLOR = [108 112 122 80]
DE_ALT_COLOR = [120 75 75 128]

DE_HIGHLIGHT_BAR_COLOR = [1 16 21 55]
DE_MENU_TITLE_COLOR = [92 101 109 108]

DE_STAT_ON = [128 30 12 60]
DE_STAT_OFF = [11 36 51 100]
DE_DEF_STAT_ON = [60 0 0 60]
DE_DEF_STAT_OFF = [11 36 51 50]

//DE_SPEECH_BOX_COLOR = [128 64 57 108]
DE_SPEECH_BOX_COLOR = [99 44 40 90]
DE_KEY_COLOR = [11 36 51 100]

// PA Theme
PA_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[128 100 0 108] // entry 10 goal ped talking color
]

PA_HUD_COLOR = [28 48 82 128]
PA_BALANCE_METER_COLOR = [28 48 82 108]
PA_BALANCE_ARROW_COLOR = [128 98 24 108]
PA_HUD_SPECIAL_COLOR   = [128 100 0 108]
PA_SPECIAL_BAR_COLORS=[
	[121 77 7 128]
	[128 30 12 108]
	[128 70 2 128]
]

PA_ICON_ON_VALUE = [128 100 0 108]
PA_BOX_ICON_COLOR = [128 100 0 108]
PA_ICON_TWITCH_VALUE = [128 128 128 128]
PA_SUBMENU_TITLE_ICON_COLOR = [128 100 0 38]

PA_GRADIENT_VALUE = [49 90 116 70]
PA_BG_PARTS_COLOR = [17 56 85 108]

PA_TEXT_TWITCH_VALUE = [128 128 128 128]
PA_HIGHLIGHTED_TEXT_COLOR = [128 100 0 108]
PA_UNHIGHLIGHTED_TEXT_COLOR = [88 105 112 128]
PA_ALT_COLOR = [40 80 128 128]

PA_HIGHLIGHT_BAR_COLOR = [0 0 0 0]
PA_MENU_TITLE_COLOR = [88 105 112 118]

PA_STAT_ON = [38 56 128 70]
PA_STAT_OFF = [60 60 75 70]
PA_DEF_STAT_ON = [25 32 67 80]
PA_DEF_STAT_OFF = [35 35 45 80]

PA_SPEECH_BOX_COLOR = [9 62 103 108]
PA_KEY_COLOR = [45 89 98 100]

// AL Theme
AL_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[13 89 117 128] // entry 10 goal ped talking color
]

AL_HUD_COLOR = [49 90 116 128]
AL_BALANCE_METER_COLOR = [8 112 100 128]
AL_BALANCE_ARROW_COLOR = [49 90 116 128]
AL_HUD_SPECIAL_COLOR   = [128 128 128 80]
AL_SPECIAL_BAR_COLORS=[
	[128 0 9 128]
	[81 107 128 128]
	[128 0 9 128]
]

AL_ICON_ON_VALUE = [13 89 117 128]
AL_BOX_ICON_COLOR = [98 121 128 48]
AL_ICON_TWITCH_VALUE = [128 128 128 128]
AL_SUBMENU_TITLE_ICON_COLOR = [8 112 100 110]

AL_GRADIENT_VALUE = [118 118 128 90]
AL_BG_PARTS_COLOR = [98 121 128 98]

AL_TEXT_TWITCH_VALUE = [2 128 70 128]
AL_HIGHLIGHTED_TEXT_COLOR = [13 89 117 128]
AL_UNHIGHLIGHTED_TEXT_COLOR = [128 128 128 78]
AL_ALT_COLOR = [63 90 97 128]

AL_HIGHLIGHT_BAR_COLOR = [8 112 100 57]
AL_MENU_TITLE_COLOR = [100 100 100 128]

AL_STAT_ON = [26 85 123 70]
AL_STAT_OFF = [65 65 75 80]
AL_DEF_STAT_ON = [30 50 65 80]
AL_DEF_STAT_OFF = [40 40 50 80]

AL_SPEECH_BOX_COLOR = [8 112 100 98]
AL_KEY_COLOR = [28 59 64 78]

// FU Theme
FU_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[96 82 67 100] // entry 10 goal ped talking color
]

FU_HUD_COLOR = [100 20 11 118]
FU_BALANCE_METER_COLOR = [80 80 80 118]
FU_BALANCE_ARROW_COLOR = [118 30 2 128]
FU_HUD_SPECIAL_COLOR   = [128 128 128 60]
FU_SPECIAL_BAR_COLORS=[
	[100 20 11 128]
	[128 128 128 108]
	[100 20 11 128]
]


FU_ICON_ON_VALUE = [128 128 128 98]
FU_BOX_ICON_COLOR = [50 50 50 128]
FU_ICON_TWITCH_VALUE = [115 20 20 120]
FU_SUBMENU_TITLE_ICON_COLOR = [50 50 50 108]

FU_GRADIENT_VALUE = [17 33 30 80]
FU_BG_PARTS_COLOR = [100 20 11 98]

FU_TEXT_TWITCH_VALUE = [0 0 0 0 ]
FU_HIGHLIGHTED_TEXT_COLOR = [100 20 11 128]
FU_UNHIGHLIGHTED_TEXT_COLOR = [96 82 67 80]
FU_ALT_COLOR = [128 15 9 128]

FU_HIGHLIGHT_BAR_COLOR = [100 20 11 64]
FU_MENU_TITLE_COLOR = [128 128 128 78]

FU_STAT_ON = [100 20 11 70]
FU_STAT_OFF = [50 50 50 80]
FU_DEF_STAT_ON = [50 5 2 70]
FU_DEF_STAT_OFF = [30 30 30 80]

FU_SPEECH_BOX_COLOR = [70 70 70 108]
FU_KEY_COLOR = [50 50 50 70]

// NS Theme
NS_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[122 67 1 98] // entry 10 goal ped talking color
]
 
NS_HUD_COLOR = [122 67 1 128]
NS_BALANCE_METER_COLOR = [122 67 1 90]
NS_BALANCE_ARROW_COLOR = [120 27 1 128]
NS_HUD_SPECIAL_COLOR   = [124 107 24 78]
NS_SPECIAL_BAR_COLORS=[
	[107 43 12 128]
	[20 20 20 80]
	[107 43 12 128]
]

NS_ICON_ON_VALUE = [128 128 128 78]
NS_BOX_ICON_COLOR = [128 128 128 100]
NS_ICON_TWITCH_VALUE = [122 67 1 128]
NS_SUBMENU_TITLE_ICON_COLOR = [50 50 50 118]

NS_GRADIENT_VALUE = [0 0 0 60]
NS_BG_PARTS_COLOR = [122 67 1 128]

NS_TEXT_TWITCH_VALUE = [0 0 0 128]
NS_HIGHLIGHTED_TEXT_COLOR = [120 27 1 108]
NS_UNHIGHLIGHTED_TEXT_COLOR = [103 123 125 75]
NS_ALT_COLOR = [117 91 11 128]

NS_HIGHLIGHT_BAR_COLOR = [23 18 10 80]
NS_MENU_TITLE_COLOR = [122 67 1 98]

NS_STAT_ON = [122 67 1 80]
NS_STAT_OFF = [65 65 65 80]
NS_DEF_STAT_ON = [78 42 7 80]
NS_DEF_STAT_OFF = [35 35 35 80]

NS_SPEECH_BOX_COLOR = [122 67 1 118]
NS_KEY_COLOR = [80 80 80 68]

// UG Theme
UG_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[120 33 17 100] // entry 10 goal ped talking color
]

UG_HUD_COLOR = [40 40 40 128]
UG_BALANCE_METER_COLOR = [40 40 40 128]
UG_BALANCE_ARROW_COLOR = [128 74 7 128]
UG_HUD_SPECIAL_COLOR   = [128 128 128 80]
UG_SPECIAL_BAR_COLORS=[
	[128 74 7 128]
	[128 38 7 128]
	[128 74 7 128]
]

UG_ICON_ON_VALUE = [120 33 17 108]
UG_BOX_ICON_COLOR = [128 128 128 128]
UG_ICON_TWITCH_VALUE = [23 65 105 50]
UG_SUBMENU_TITLE_ICON_COLOR = [0 0 0 100]

UG_GRADIENT_VALUE = [30 30 30 110]
UG_BG_PARTS_COLOR = [60 60 60 100]

UG_TEXT_TWITCH_VALUE = [0 0 0  128]
UG_HIGHLIGHTED_TEXT_COLOR = [128 74 7 108]
UG_UNHIGHLIGHTED_TEXT_COLOR = [74 85 112 90]
UG_ALT_COLOR = [128 15 9 128]

UG_HIGHLIGHT_BAR_COLOR = [30 30 30 128]
UG_MENU_TITLE_COLOR = [120 33 17 100]

UG_STAT_ON = [120 33 17 100]
UG_STAT_OFF = [120 33 17 30]
UG_DEF_STAT_ON = [40 40 40 100]
UG_DEF_STAT_OFF = [40 40 50 40]

UG_SPEECH_BOX_COLOR = [80 80 80 100]
UG_KEY_COLOR = [100 100 100 100]

// SP1 Theme
SP1_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[62 99 123 108] // entry 10 goal ped talking color
]

SP1_HUD_COLOR = [80 80 80 98]
SP1_BALANCE_METER_COLOR = [70 70 70 120]
SP1_BALANCE_ARROW_COLOR = [62 99 123 128]
SP1_HUD_SPECIAL_COLOR   = [128 128 128 78]
SP1_SPECIAL_BAR_COLORS=[
	[62 99 123 128]
	[128 128 128 48]
	[62 99 123 128]
]

SP1_ICON_ON_VALUE = [70 70 70 98]
SP1_BOX_ICON_COLOR = [0 0 0  108]
SP1_ICON_TWITCH_VALUE = [62 99 123 128]
SP1_SUBMENU_TITLE_ICON_COLOR = [0 0 0 88]

SP1_GRADIENT_VALUE = [30 54 84 100]
SP1_BG_PARTS_COLOR = [50 50 50 98]

SP1_TEXT_TWITCH_VALUE = [128 128 128 128]
SP1_HIGHLIGHTED_TEXT_COLOR = [62 99 123 108]
SP1_UNHIGHLIGHTED_TEXT_COLOR = [41 53 75 95]
SP1_ALT_COLOR = [100 100 100 128]

SP1_HIGHLIGHT_BAR_COLOR = [10 10 10 75]
SP1_MENU_TITLE_COLOR = [62 99 123 108]

SP1_STAT_ON = [62 99 123 118]
SP1_STAT_OFF = [11 36 51 100]
SP1_DEF_STAT_ON = [60 0 0 60]
SP1_DEF_STAT_OFF = [11 36 51 50]

SP1_SPEECH_BOX_COLOR = [62 99 123 108]
SP1_KEY_COLOR = [60 60 60 100]


// SP2 Theme
SP2_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[103 8 33 88] // entry 10 goal ped talking color
]

SP2_HUD_COLOR = [80 80 80 128]
SP2_BALANCE_METER_COLOR = [103 8 33 108]
SP2_BALANCE_ARROW_COLOR = [55 85 108 118]
SP2_HUD_SPECIAL_COLOR   = [128 128 128 108]
SP2_SPECIAL_BAR_COLORS=[
	[103 8 33 128]
	[55 85 108 100]
	[103 8 33 128]
]

SP2_ICON_ON_VALUE = [103 8 33 88]
SP2_BOX_ICON_COLOR = [0 0 0 128]
SP2_ICON_TWITCH_VALUE = [128 128 128 128]
SP2_SUBMENU_TITLE_ICON_COLOR = [60 60 60 38]

SP2_GRADIENT_VALUE = [55 85 108 70]
SP2_BG_PARTS_COLOR = [103 8 33 108]

SP2_TEXT_TWITCH_VALUE = [128 128 128 128]
SP2_HIGHLIGHTED_TEXT_COLOR = [103 8 33 108]
SP2_UNHIGHLIGHTED_TEXT_COLOR = [115 114 103 80]
SP2_ALT_COLOR = [90 90 90 128]

SP2_HIGHLIGHT_BAR_COLOR = [55 85 108 90]
SP2_MENU_TITLE_COLOR = [128 128 128 98]

SP2_STAT_ON = [55 85 108 128]
SP2_STAT_OFF = [60 60 75 70]
SP2_DEF_STAT_ON = [25 32 67 80]
SP2_DEF_STAT_OFF = [35 35 45 80]

SP2_SPEECH_BOX_COLOR = [80 80 80 88]
SP2_KEY_COLOR = [80 80 80 100]

// SP3 Theme
SP3_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[128 20 0 88] // entry 10 goal ped talking color
]

SP3_HUD_COLOR = [128 128 128 128]
SP3_BALANCE_METER_COLOR = [128 128 128 128]
SP3_BALANCE_ARROW_COLOR = [128 0 0 128]
SP3_HUD_SPECIAL_COLOR   = [100 100 100 100]
SP3_SPECIAL_BAR_COLORS=[
	[128 0 0 128]
	[128 128 128 128]
	[128 0 0 128]
]

SP3_ICON_ON_VALUE = [128 128 128 128]
SP3_BOX_ICON_COLOR = [0 0 0 68]
SP3_ICON_TWITCH_VALUE = [128 0 0 128]
SP3_SUBMENU_TITLE_ICON_COLOR = [128 128 128 110]

SP3_GRADIENT_VALUE = [90 90 90 100]
SP3_BG_PARTS_COLOR = [60 60 60 98]

SP3_TEXT_TWITCH_VALUE = [0 0 0 128]
SP3_HIGHLIGHTED_TEXT_COLOR = [128 20 0 128]
SP3_UNHIGHLIGHTED_TEXT_COLOR = [128 128 128 78]
SP3_ALT_COLOR = [0 0 0  128]

SP3_HIGHLIGHT_BAR_COLOR = [30 30 30 128]
SP3_MENU_TITLE_COLOR = [128 20 0 128]

SP3_STAT_ON = [128 30 0 120]
SP3_STAT_OFF = [65 65 75 80]
SP3_DEF_STAT_ON = [30 50 65 80]
SP3_DEF_STAT_OFF = [40 40 50 80]

SP3_SPEECH_BOX_COLOR = [60 60 60 98]
SP3_KEY_COLOR = [128 128 128 78]

// SP4 Theme
SP4_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[70 100 54 100] // entry 10 goal ped talking color
]

SP4_HUD_COLOR = [85 95 107 118]
SP4_BALANCE_METER_COLOR = [70 100 54 118]
SP4_BALANCE_ARROW_COLOR = [65 20 16 128]
SP4_HUD_SPECIAL_COLOR   = [128 128 128 90]
SP4_SPECIAL_BAR_COLORS=[
	[28 74 109 128]
	[65 20 16 60]
	[28 74 109 128]
]


SP4_ICON_ON_VALUE = [70 100 54 98]
SP4_BOX_ICON_COLOR = [50 50 50 128]
SP4_ICON_TWITCH_VALUE = [85 95 107 120]
SP4_SUBMENU_TITLE_ICON_COLOR = [50 50 50 108]

SP4_GRADIENT_VALUE = [126 118 87 80]
SP4_BG_PARTS_COLOR = [85 95 107 98]

SP4_TEXT_TWITCH_VALUE = [0 0 0 0 ]
SP4_HIGHLIGHTED_TEXT_COLOR = [70 100 54 128]
SP4_UNHIGHLIGHTED_TEXT_COLOR = [ 118 123 92 80]
SP4_ALT_COLOR = [126 118 87 128]

SP4_HIGHLIGHT_BAR_COLOR = [35 45 57 80]
SP4_MENU_TITLE_COLOR = [128 128 128 78]

SP4_STAT_ON = [28 74 109 128]
SP4_STAT_OFF = [50 50 50 60]
SP4_DEF_STAT_ON = [50 5 2 70]
SP4_DEF_STAT_OFF = [50 50 50 60]

SP4_SPEECH_BOX_COLOR = [70 100 54 108]
SP4_KEY_COLOR = [85 95 107 70]

// SP5 Theme
SP5_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[80 80 80 110] // entry 10 goal ped talking color
]
 
SP5_HUD_COLOR = [128 13 16 128]
SP5_BALANCE_METER_COLOR = [120 13 16 90]
SP5_BALANCE_ARROW_COLOR = [60 60 60 128]
SP5_HUD_SPECIAL_COLOR   = [118 118 118 89]
SP5_SPECIAL_BAR_COLORS=[
	[120 13 16 128]
	[20 20 20 80]
	[120 13 16 128]
]

SP5_ICON_ON_VALUE = [60 60 60 98]
SP5_BOX_ICON_COLOR = [90 90 90 80]
SP5_ICON_TWITCH_VALUE = [60 60 60 128]
SP5_SUBMENU_TITLE_ICON_COLOR = [120 13 16 118]

SP5_GRADIENT_VALUE = [0 0 0 88]
SP5_BG_PARTS_COLOR = [70 70 70 128]

SP5_TEXT_TWITCH_VALUE = [128 128 128 128]
SP5_HIGHLIGHTED_TEXT_COLOR = [120 13 16 108]
SP5_UNHIGHLIGHTED_TEXT_COLOR = [110 110 110 80]
SP5_ALT_COLOR = [110 110 110 128]

SP5_HIGHLIGHT_BAR_COLOR = [20 20 20 120]
SP5_MENU_TITLE_COLOR = [120 13 16 118]

SP5_STAT_ON = [109 24 24 80]
SP5_STAT_OFF = [65 65 65 80]
SP5_DEF_STAT_ON = [78 42 7 80]
SP5_DEF_STAT_OFF = [35 35 35 80]

SP5_SPEECH_BOX_COLOR = [80 80 80 118]
SP5_KEY_COLOR = [80 80 80 68]

// SS1 Theme
SS1_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[126 74 21 100] // entry 10 goal ped talking color
]

SS1_HUD_COLOR = [126 74 21 98]
SS1_BALANCE_METER_COLOR = [126 74 21 90]
SS1_BALANCE_ARROW_COLOR = [128 124 2 128]
SS1_HUD_SPECIAL_COLOR   = [128 128 128 78]
SS1_SPECIAL_BAR_COLORS=[
	[128 124 2 128]
	[73 0 125 78]
	[128 124 2 128]
]

SS1_ICON_ON_VALUE = [73 0 125 98]
SS1_BOX_ICON_COLOR = [128 40 12 108]
SS1_ICON_TWITCH_VALUE = [118 87 9 128]
SS1_SUBMENU_TITLE_ICON_COLOR = [0 0 0  88]

SS1_GRADIENT_VALUE = [20 20 20 90]
SS1_BG_PARTS_COLOR = [110 97 129 98]

SS1_TEXT_TWITCH_VALUE = [121 79 5 128]
SS1_HIGHLIGHTED_TEXT_COLOR = [126 74 21 108]
SS1_UNHIGHLIGHTED_TEXT_COLOR = [110 97 129 85]
SS1_ALT_COLOR = [120 75 75 128]

SS1_HIGHLIGHT_BAR_COLOR = [10 10 10 95]
SS1_MENU_TITLE_COLOR = [128 124 2 108]

SS1_STAT_ON = [73 0 125 60]
SS1_STAT_OFF = [11 36 51 100]
SS1_DEF_STAT_ON = [60 0 0 60]
SS1_DEF_STAT_OFF = [11 36 51 50]

SS1_SPEECH_BOX_COLOR = [60 60 60 108]
SS1_KEY_COLOR = [110 97 129 100]


// SS2 Theme
SS2_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[115 115 10 108] // entry 10 goal ped talking color
]

SS2_HUD_COLOR = [115 115 10 128]
SS2_BALANCE_METER_COLOR = [119 14 26 108]
SS2_BALANCE_ARROW_COLOR = [128 100 0 108]
SS2_HUD_SPECIAL_COLOR   = [128 100 0 108]
SS2_SPECIAL_BAR_COLORS=[
	[119 14 26 128]
	[115 115 10 80]
	[119 14 26 128]
]

SS2_ICON_ON_VALUE = [119 14 26 108]
SS2_BOX_ICON_COLOR = [128 100 0 108]
SS2_ICON_TWITCH_VALUE = [115 115 10]
SS2_SUBMENU_TITLE_ICON_COLOR = [128 100 0 38]

SS2_GRADIENT_VALUE = [49 90 116 100]
SS2_BG_PARTS_COLOR = [119 14 26 108]

SS2_TEXT_TWITCH_VALUE = [128 128 128 128]
SS2_HIGHLIGHTED_TEXT_COLOR = [115 115 10 108]
SS2_UNHIGHLIGHTED_TEXT_COLOR = [125 112 124 58]
SS2_ALT_COLOR = [119 14 26 128]

SS2_HIGHLIGHT_BAR_COLOR = [119 14 26 70]
SS2_MENU_TITLE_COLOR = [88 105 112 118]

SS2_STAT_ON = [128 100 0 70]
SS2_STAT_OFF = [60 60 75 70]
SS2_DEF_STAT_ON = [25 32 67 80]
SS2_DEF_STAT_OFF = [35 35 45 80]

SS2_SPEECH_BOX_COLOR = [49 90 116 108]
SS2_KEY_COLOR = [45 89 98 100]

// SS3 Theme
SS3_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[74 98 101 90] // entry 10 goal ped talking color
]

SS3_HUD_COLOR = [80 80 80 108]
SS3_BALANCE_METER_COLOR = [80 80 80 98]
SS3_BALANCE_ARROW_COLOR = [0 86 98 128]
SS3_HUD_SPECIAL_COLOR   = [128 128 128 80]
SS3_SPECIAL_BAR_COLORS=[
	[128 0 0 128]
	[0 86 98 128]
	[128 0 0 128]
]

SS3_ICON_ON_VALUE = [0 86 98 38]
SS3_BOX_ICON_COLOR = [0 86 98 48]
SS3_ICON_TWITCH_VALUE = [112 13 25 128]
SS3_SUBMENU_TITLE_ICON_COLOR = [0 86 98 128]

SS3_GRADIENT_VALUE = [70 70 70 108]
SS3_BG_PARTS_COLOR = [70 70 70 98]

SS3_TEXT_TWITCH_VALUE = [0 86 98 128]
SS3_HIGHLIGHTED_TEXT_COLOR = [112 13 25 128]
SS3_UNHIGHLIGHTED_TEXT_COLOR = [74 98 101 75]
SS3_ALT_COLOR = [0 86 98 128]

SS3_HIGHLIGHT_BAR_COLOR = [40 40 40 67]
SS3_MENU_TITLE_COLOR = [100 100 100 78]

SS3_STAT_ON = [0 86 98 100]
SS3_STAT_OFF = [65 65 75 80]
SS3_DEF_STAT_ON = [30 50 65 80]
SS3_DEF_STAT_OFF = [40 40 50 80]

SS3_SPEECH_BOX_COLOR = [60 60 60 98]
SS3_KEY_COLOR = [0 86 98 78]

// SS4 Theme
SS4_FONT_COLORS=[
	[88 105 112 128] // entry 1, normal gray/white
	[128 30 12 108] // entry 2, highlight color red
	[50 80 112 100] // entry 3,unhighlight color blue
	[9 107 36 100] // entry 4 green
	[123 99 3 100] // entry 5 yellow
	[0 128 128 100] // entry 6, highlight yellow color
	[128 0 128 100] // entry 7
	[30 50 80 100] // entry 8
	[88 105 112 128] // entry 9
	[30 50 80 100] // entry 10 goal ped talking color
]

SS4_HUD_COLOR = [100 20 11 118]
SS4_BALANCE_METER_COLOR = [80 80 80 118]
SS4_BALANCE_ARROW_COLOR = [118 30 2 128]
SS4_HUD_SPECIAL_COLOR   = [128 128 128 60]
SS4_SPECIAL_BAR_COLORS=[
	[100 20 11 128]
	[128 128 128 108]
	[100 20 11 128]
]


SS4_ICON_ON_VALUE = [128 128 128 98]
SS4_BOX_ICON_COLOR = [50 50 50 128]
SS4_ICON_TWITCH_VALUE = [115 20 20 120]
SS4_SUBMENU_TITLE_ICON_COLOR = [50 50 50 108]

SS4_GRADIENT_VALUE = [17 33 30 80]
SS4_BG_PARTS_COLOR = [100 20 11 98]

SS4_TEXT_TWITCH_VALUE = [0 0 0 0 ]
SS4_HIGHLIGHTED_TEXT_COLOR = [100 20 11 128]
SS4_UNHIGHLIGHTED_TEXT_COLOR = [60 60 60 90]
SS4_ALT_COLOR = [128 15 9 128]

SS4_HIGHLIGHT_BAR_COLOR = [100 20 11 64]
SS4_MENU_TITLE_COLOR = [128 128 128 78]

SS4_STAT_ON = [100 20 11 70]
SS4_STAT_OFF = [50 50 50 80]
SS4_DEF_STAT_ON = [50 5 2 70]
SS4_DEF_STAT_OFF = [30 30 30 80]

SS4_SPEECH_BOX_COLOR = [70 70 70 108]
SS4_KEY_COLOR = [50 50 50 70]

//End theme color values///////////////////////////////////

current_theme_prefix = 0
stored_theme_prefix = 0
last_theme_prefix = 99

THEME_COLOR_PREFIXES = 	[ "DE", "PA", "AL", "FU", "NS", "UG", "SP1", "SP2", "SP3", "SP4", "SP5", "SS1", "SS2", "SS3", "SS4" ]
THEME_PREFIXES = 		[ "DE", "PA", "AL", "FU", "NS", "UG", "SP",  "SP",  "SP",  "SP",  "SP",  "SP",  "SP",  "SP",  "SP"  ]

script theme_name_test
	FormatText TextName=value_name "%i_OPTION_ON_VALUE" i=(THEME_PREFIXES[current_theme_prefix])
    printf "%i" i=<value_name> 
endscript

script swap_themes_menu
	if not LevelIs load_skateshop
		pad_back_script = create_options_menu
		pause_menu_gradient on
	else
		pad_back_script = create_setup_options_menu
	endif

	FormatText ChecksumName=title_icon "%i_theme" i=(THEME_PREFIXES[current_theme_prefix])
	;make_new_themed_sub_menu title="THEMES" title_icon=<title_icon>
	make_new_themed_scrolling_menu title="INTERFACE THEMES" title_icon=<title_icon> ;dims=(300,227) pos=(229,80)
	
	if LevelIs load_skateshop
		FormatText ChecksumName=menu_title "%i_mainmenu" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
		FormatText ChecksumName=main_icon "%i_mainicon" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
		
		// title
		CreateScreenElement {
			type=SpriteElement
			parent=current_menu_anchor
			id=mm_title
			
			texture=<menu_title>
			just=[center center]
			pos=(460,240)
			scale = 1.3
			rot_angle=-12
			z_priority=1
			alpha=0.3
		}
		
		// icon
		CreateScreenElement {
			type=SpriteElement
			parent=current_menu_anchor
			id=mm_icon
			
			texture=<main_icon>
			just=[center center]
			pos=(460,200)
			scale = 3.0
			rot_angle=-12
			z_priority=1
			alpha=0.3
		}
	endif
	
	SetScreenElementProps { id=sub_menu
							event_handlers=[
								{ pad_back          generic_menu_pad_back params={ callback=<pad_back_script> }}
							]
						  }
	common_params={ pad_choose_script=set_current_theme centered=1 no_bg=no_bg highlight_bar_scale=( 2.3,0.7) }
	
	theme_menu_add_item text="CloudBuster" pad_choose_params={ theme_num=0 } <common_params> first_item=first_item
	theme_menu_add_item text="Retro Hawk" pad_choose_params={ theme_num=1 } <common_params> 
	theme_menu_add_item text="Chilled" pad_choose_params={ theme_num=2 } <common_params> 
	theme_menu_add_item text="Skullz 'n Stuff" pad_choose_params={ theme_num=3 } <common_params> 
	theme_menu_add_item text="Neversoft" pad_choose_params={ theme_num=4 } <common_params> 
	theme_menu_add_item text="T . H . U . G ." pad_choose_params={ theme_num=5 } <common_params>
	
	//make sure to enable themes that have been unlocked
	if GetGlobalFlag flag= BOARDS_UNLOCKED_BIRDHOUSE
		theme_menu_add_item text="Sponsor 1 - Birdhouse" pad_choose_params={ theme_num=6 } <common_params>
	else
		theme_menu_add_item text="Sponsor 1 - Birdhouse" pad_choose_params={ theme_num=6 } <common_params> not_focusable
	endif
	
	if GetGlobalFlag flag= BOARDS_UNLOCKED_ELEMENT
		theme_menu_add_item text="Sponsor 2 - Element" pad_choose_params={ theme_num=7 } <common_params> 
	else
		theme_menu_add_item text="Sponsor 2 - Element" pad_choose_params={ theme_num=7 } <common_params> not_focusable
	endif
	
	if GetGlobalFlag flag= BOARDS_UNLOCKED_FLIP
		theme_menu_add_item text="Sponsor 3 - Flip" pad_choose_params={ theme_num=8 } <common_params> 
	else
		theme_menu_add_item text="Sponsor 3 - Flip" pad_choose_params={ theme_num=8 } <common_params> not_focusable
	endif
	
	if GetGlobalFlag flag= BOARDS_UNLOCKED_GIRL
		theme_menu_add_item text="Sponsor 4 - Girl" pad_choose_params={ theme_num=9 } <common_params> 
	else
		theme_menu_add_item text="Sponsor 4 - Girl" pad_choose_params={ theme_num=9 } <common_params> not_focusable 
	endif
	
	if GetGlobalFlag flag= BOARDS_UNLOCKED_ZERO
		theme_menu_add_item text="Sponsor 5 - ZERO" pad_choose_params={ theme_num=10 } <common_params>
	else
		theme_menu_add_item text="Sponsor 5 - ZERO" pad_choose_params={ theme_num=10 } <common_params> not_focusable
	endif
	
	if GetGlobalFlag flag= SKATER_UNLOCKED_KISSDUDE
		theme_menu_add_item text="Secret 1 - KISS" pad_choose_params={ theme_num=11 } <common_params>
	else
		theme_menu_add_item text="Secret 1" pad_choose_params={ theme_num=11 } <common_params> not_focusable
	endif
	
	if GetGlobalFlag flag= SKATER_UNLOCKED_IRONMAN
		theme_menu_add_item text="Secret 2 - IronMan" pad_choose_params={ theme_num=12 } <common_params>
	else
		theme_menu_add_item text="Secret 2" pad_choose_params={ theme_num=12 } <common_params> not_focusable
	endif
	
	if GetGlobalFlag flag= SKATER_UNLOCKED_CREATURE
		theme_menu_add_item text="Secret 3 - T.H.U.D." pad_choose_params={ theme_num=13 } <common_params>
	else
		theme_menu_add_item text="Secret 3" pad_choose_params={ theme_num=13 } <common_params> not_focusable
	endif

	
    ;finish_themed_sub_menu
	finish_themed_scrolling_menu
endscript

script maybe_reset_theme
	
	// check if current theme is a sponsored one
	if((current_theme_prefix > 5) && (current_theme_prefix < 11))
		printf "resetting theme"
		
		set_current_theme theme_num=0 story_swap
	endif
    
endscript

script maybe_revert_theme
	select_skater_get_current_skater_name
		
	switch <current_skater>
	case Iron_Man
	case Gene
	case Creature
		return
	endswitch
	
	<i> = (current_theme_prefix)
	<j> = (stored_theme_prefix)
	
	if not (<i> = <j>)
		set_current_theme theme_num=<j> story_swap
	endif
	
endscript

script set_current_theme
    
	// destroy chapter intro text
	if ScreenElementExists id=chapter_intro_title
		DestroyScreenElement id=chapter_intro_title
	endif
	
	// temporarily change hud sponsor sprite
	setscreenelementprops id=generic_sponsor_logo texture=white2
	if ScreenElementExists id=(generic_sponsor_logo + 1)
		setscreenelementprops id=(generic_sponsor_logo + 1) texture=white2
	endif
	
	if ( (ScreenElementExists id=current_menu_anchor) || (GotParam loading_career) )
		// can't have anything on screen if we're gonna unload the fonts!!!
		if ScreenElementExists id=current_menu_anchor
			DestroyScreenElement id=current_menu_anchor
		endif
		pause_menu_gradient off
		dialog_box_exit no_pad_start
		
		// for changing themes from chapter menu
		if gotParam new_sponsor
			KillSpawnedScript name=chap_moving_bg
			KillSpawnedScript name=spawnscrip chap_new_rotating_bg
			KillSpawnedScript name=spawnscrip chap_new_rotating_bg_2
			KillSpawnedScript name=chap_graphic_crossfade
			KillSpawnedScript name=fadetoblack
			
			// destroy menu
			if ScreenElementExists id=current_menu_anchor
				DestroyScreenElement id=current_menu_anchor
			endif
			if ScreenElementExists id=fade_out_anchor
				DestroyScreenElement id=fade_out_anchor
			endif
			kill_blur start=0
			
			load_chapter_textures_to_main_memory unload
		endif
		
		SetScreenElementLock id=root_window off

		CreateScreenElement {
			type=ContainerElement
			parent=root_window		
			id=menu_parts_anchor
			
			dims=(640, 480)
			pos=(320, 240)
		}
		
		AssignAlias id=menu_parts_anchor alias=current_menu_anchor
		
		if LevelIs load_skateshop	
			build_top_and_bottom_blocks
			make_mainmenu_3d_plane
		endif
		
		// Can't create dialog box because it's textures are being swapped too!
		/*create_dialog_box { title="Swapping"
						text="Swapping themes now."
						pos=(310 ,183)
						just=[center center]
                        ;text_dims=(320,0)
					  }*/
		
		wait 5 gameframes
    endif
	
	change last_theme_prefix = ( current_theme_prefix + 0 ) // avoiding stupid checksum fake pointer crap
    change current_theme_prefix = <theme_num>
	if not GotParam dont_keep_it
		change stored_theme_prefix = <theme_num>
	endif

	// (TT#12551)if not skateshop then need to unload the unloadable anims
	if NOT LevelIs load_skateshop	
		do_unload_unloadable
    endif
	
	// unload last theme sprites
	load_theme_textures_to_main_memory unload
    // load new theme sprites
	load_theme_textures_to_main_memory
	printf "successfully loaded new theme textures"

    // update hud colors
	FormatText ChecksumName=hud_color "%i_HUD_COLOR" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
	FormatText ChecksumName=special_color "%i_HUD_SPECIAL_COLOR" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
	
	// change back hud sponsor sprite
	FormatText ChecksumName=sponsor_texture "%i_sponsor" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
	if ScreenElementExists id=generic_sponsor_logo
		setscreenelementprops id=generic_sponsor_logo texture=<sponsor_texture>
	endif
	if ScreenElementExists id=(generic_sponsor_logo + 1)
		setscreenelementprops id=(generic_sponsor_logo + 1) texture=<sponsor_texture>
	endif
	
	if ScreenElementExists id=the_score_sprite
		SetScreenElementProps id=the_score_sprite rgba=<hud_color>
	endif
	
	if ScreenElementExists id=(the_score_sprite + 1)
		SetScreenElementProps id=(the_score_sprite + 1) rgba=<hud_color>
	endif
	
	if ScreenElementExists id=cash_goal_sprite
		SetScreenElementProps id=cash_goal_sprite rgba=<hud_color>
	endif
	
	//update the mini HUD
	FormatText ChecksumName=rgba_off "%i_UNHIGHLIGHTED_TEXT_COLOR" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
	FormatText ChecksumName=rgba_on "%i_HIGHLIGHTED_TEXT_COLOR" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
	FormatText ChecksumName=sb_rgba "%i_SPEECH_BOX_COLOR" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
	if ScreenElementExists id=goal_counter_anchor
		SetScreenElementProps id=goal_counter_number_collected rgba=<rgba_on>
		SetScreenElementProps id=goal_counter_number_total rgba=<rgba_off>
		SetScreenElementProps id=mini_score_hud_box rgba=<sb_rgba>
	endif
	
	// update the special meter
    FormatText ChecksumName=bar_colors "%i_SPECIAL_BAR_COLORS" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
    change special_bar_colors = <bar_colors>
	
    if ScreenElementExists id=the_special_bar_special
		SetScreenElementProps id=the_special_bar_special rgba=<special_color>
		
		setSpecialBarColors skater=0
	endif
	
	if ScreenElementExists id=(the_special_bar_special + 1)
		SetScreenElementProps id=(the_special_bar_special + 1) rgba=<special_color>
		
		setSpecialBarColors skater=1
	endif
	
    // fonts swap to change color tables
	printf "begin theme font swap"
    PushMemProfile  "Fonts and Bitmaps"
	LoadLevelPreFile    "panelsprites.pre"
	
	FormatText ChecksumName=font_colors "%i_FONT_COLORS" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
	;UnloadFont "small"
	;UnloadFont "dialog"
    LoadFont "small" char_spacing=-3.1 space_spacing=12 color_tab=<font_colors>
	LoadFont "dialog" char_spacing=-3.0 space_spacing=12 color_tab=<font_colors>
	LoadFont buttons_font
	
	UnLoadPreFile    "panelsprites.pre" dont_assert
	PopMemProfile  //"Fonts and Bitmaps"
	printf "finished theme font swap"
	
    if not gotParam loading_career
		if not gotParam new_sponsor
			if not gotParam story_swap
				if not gotParam in_skater_select
					dialog_box_exit
					swap_themes_menu
				endif
			endif
		else
			; exit_pause_menu
		endif
	endif

	// (TT#12551)reload anims if they were unloaded
	if NOT LevelIs load_skateshop	
		do_load_unloadable
    endif
	
	FireEvent type=theme_change_done
endscript


script unload_current_theme
    
	// temporarily change hud sponsor sprite
	setscreenelementprops id=generic_sponsor_logo texture=white2
	if ScreenElementExists id=(generic_sponsor_logo + 1)
		setscreenelementprops id=(generic_sponsor_logo + 1) texture=white2
	endif
	
	if ( (ScreenElementExists id=current_menu_anchor) || (GotParam loading_career) )
		// can't have anything on screen if we're gonna unload the fonts!!!
		if ScreenElementExists id=current_menu_anchor
			DestroyScreenElement id=current_menu_anchor
		endif
		pause_menu_gradient off
		dialog_box_exit
		
        wait 5 gameframes
	endif
	
    // unload last theme sprites
	load_theme_textures_to_main_memory unload_current
endscript

script reload_current_theme
    
	// load new theme sprites
	load_theme_textures_to_main_memory
	printf "successfully loaded new theme textures"
	
    // update hud colors
	FormatText ChecksumName=hud_color "%i_HUD_COLOR" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
	FormatText ChecksumName=special_color "%i_HUD_SPECIAL_COLOR" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
	
	// change back hud sponsor sprite
	FormatText ChecksumName=sponsor_texture "%i_sponsor" i=(THEME_COLOR_PREFIXES[current_theme_prefix])
	setscreenelementprops id=generic_sponsor_logo texture=<sponsor_texture>
	if ScreenElementExists id=(generic_sponsor_logo + 1)
		setscreenelementprops id=(generic_sponsor_logo + 1) texture=<sponsor_texture>
	endif
	
    FireEvent type=theme_change_done
endscript


// color testing scripts

script spawn_color_test
	SpawnScript create_color_test
endscript

script create_color_test
	index=1
	begin
		printf "index = %i" i=<index>
		FormatText textname=text "\c%i COLOR %i \c0" i=<index>
        SetScreenElementLock off id=root_window
		CreateScreenElement{
			type=TextElement
			id=color_test
			text=<text>
			pos=(320,240)
			parent=root_window
			font=dialog
			just=[center center]
		}
        wait 1 second
		if ScreenElementExists id=color_test
			DestroyScreenElement id=color_test
		endif
		index = ( <index> + 1 )
	repeat 9
endscript
