/*****************************************************************************
**																			**
**			              Neversoft Entertainment	                        **
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		Sys Library												**
**																			**
**	Module:			File													**
**																			**
**	Created:		09/24/02	-	grj										**
**																			**
**	File name:		core/sys/AsyncFilesys.h									**
**																			**
*****************************************************************************/

#ifndef	__SYS_FILE_ASYNC_TYPES_H
#define	__SYS_FILE_ASYNC_TYPES_H

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/

/*****************************************************************************
**								   Defines									**
*****************************************************************************/

#define   	DEFAULT_MEMORY_TYPE		(0)

namespace File
{


/*****************************************************************************
**							     Type Defines								**
*****************************************************************************/

enum EAsyncMemoryType	// This belongs below the p-line, but need to think of a general way communicate
{						// this above the p-line.
#ifdef __PLAT_NGPS__
	MEM_EE = DEFAULT_MEMORY_TYPE,
	MEM_IOP,
#endif // __PLAT_NGPS__

#ifdef __PLAT_NGC__
	MEM_DRAM = DEFAULT_MEMORY_TYPE,
	MEM_ARAM,
#endif // __PLAT_NGC__

#ifdef __PLAT_XBOX__
	MEM_MAIN = DEFAULT_MEMORY_TYPE,		// Only 1 type for XBox
#endif //__PLAT_XBOX__
};

enum EAsyncFunctionType
{
	FUNC_IDLE,
	FUNC_OPEN,
	FUNC_LOAD,
	FUNC_READ,
	FUNC_WRITE,
	FUNC_SEEK,
	FUNC_CLOSE,
};

/*****************************************************************************
**							 Private Declarations							**
*****************************************************************************/

/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/

/*****************************************************************************
**							  Public Declarations							**
*****************************************************************************/

/*****************************************************************************
**							   Public Prototypes							**
*****************************************************************************/

/*****************************************************************************
**								Inline Functions							**
*****************************************************************************/


} // namespace File

#endif  // __SYS_FILE_ASYNC_TYPES_H
