/*****************************************************************************
**																			**
**			              Neversoft Entertainment.			                **
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		PS2														**
**																			**
**	Module:			Scripting                  								**
**																			**
**	File name:		Scripting/ftables.cpp          							**
**																			**
**	Created by:		09/15/00	-	ksh										**
**																			**
**	Description:	Lists of C-functions & class member functions callable 	**
**                  from scripts.                                           **
**																			**
*****************************************************************************/

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/

#include <scripting/ftables.h>
#include <scripting/cfuncs.h>
#include <scripting/skfuncs.h>
#include <scripting/mcfuncs.h>

#include <gel/scripting/struct.h>

#include <modules/FrontEnd/FrontEnd.h>
#include <sk/modules/skate/skate.h>
#include <modules/Skate/GameMode.h>
#include <modules/Skate/goalmanager.h>

#include <sk/objects/pathman.h>

#include <sk/gamenet/gamenet.h>
#ifdef __PLAT_NGPS__
#include <sk/gamenet/lobby.h>
#include <sk/gamenet/ngps/p_content.h>
#include <sk/gamenet/ngps/p_buddy.h>
#include <sk/gamenet/ngps/p_stats.h>
#endif

#include <gel/objtrack.h>
#include <gel/components/trickcomponent.h>

#include <sys/File/PRE.h>
#include <sys/File/pip.h>
#include <sys/replay/replay.h>

#include <gfx/Nx.h>
#include <gfx/NxFontMan.h>
#include <gfx/NxTexMan.h>
#include <gfx/NxLightMan.h>
#include <gfx/NxLoadScreen.h>
#include <gfx/NxViewMan.h>
#include <gfx/2D/ScreenElemMan.h>
#include <gfx/FaceMassage.h>
#include <gfx/nxweather.h>

#include <sk/ParkEditor2/ParkEd.h>
#include <sk/objects/gap.h>



#ifdef __PLAT_NGC__
#include <sys/ngc/p_display.h>
#endif		// __PLAT_NGC__
			  
/*****************************************************************************
**								DBG Information								**
*****************************************************************************/



namespace Script
{

/*****************************************************************************
**								  Externals									**
*****************************************************************************/

/*****************************************************************************
**								   Defines									**
*****************************************************************************/

/*****************************************************************************
**								Private Types								**
*****************************************************************************/

/*****************************************************************************
**								 Private Data								**
*****************************************************************************/

/*****************************************************************************
**								 Public Data								**
*****************************************************************************/

// A list of all the C functions callable from scripts.
// The name in quotes must be the same as the way it appears in q scripts. (case insensitive)
SCFunction CFunctionLookupTable[]=
{
    {"Wait",				CFuncs::ScriptWait},
	{"WaitForEvent",		Obj::ScriptWaitForEvent},
	{"Block",				CFuncs::ScriptBlock},

    // Prints the contents of the passed structure.
    {"PrintStruct",         CFuncs::ScriptPrintStruct},
	
	// Prints the script's event handler table.
    {"PrintEventHandlerTable",	CFuncs::ScriptPrintEventHandlerTable},
    
    {"AllocateSplitScreenDMA",	CFuncs::ScriptAllocateSplitScreenDMA},
										
										
    // Printf "Default printf text"
    {"Printf",				CFuncs::ScriptPrintf},
	{"ScriptAssert",		CFuncs::ScriptScriptAssert},
	{"PrintScriptInfo",		CFuncs::ScriptPrintScriptInfo},
	{"FormatText",			CFuncs::ScriptFormatText},
	
	{"SetHackFlag",			CFuncs::ScriptSetHackFlag},
	{"HackFlagIsSet",		CFuncs::ScriptHackFlagIsSet},
	{"SetCurrentSkaterProfile",	CFuncs::ScriptSetCurrentSkaterProfile},
	{"CurrentSkaterProfileIs",	CFuncs::ScriptCurrentSkaterProfileIs},
	{"AddSkaterProfile",		CFuncs::ScriptAddSkaterProfile},
	{"AddTemporaryProfile",		CFuncs::ScriptAddTemporaryProfile},
	{"RememberTemporaryAppearance",CFuncs::ScriptRememberTemporaryAppearance},
	{"RestoreTemporaryAppearance",	CFuncs::ScriptRestoreTemporaryAppearance},
	{"SyncPlayer2Profile",	CFuncs::ScriptSyncPlayer2Profile},
	
	{"UnloadAllLevelGeometry",	CFuncs::ScriptUnloadAllLevelGeometry},
	
    // LoadLevelGeometry "blaa"
	{"QuickReload",			CFuncs::ScriptQuickReload},
	{"UnloadScene",			CFuncs::ScriptUnloadScene},
	{"LoadScene",			CFuncs::ScriptLoadScene},
	{"LoadCollision",		CFuncs::ScriptLoadCollision},
	{"AddScene",			CFuncs::ScriptAddScene},
	{"AddCollision",		CFuncs::ScriptAddCollision},
	{"ToggleAddScenes",		Nx::ScriptToggleAddScenes},
	{"SetScreenBlur",		Nx::ScriptSetScreenBlur},
    // LoadNodeArray "blaa.qb"
    {"LoadNodeArray",		CFuncs::ScriptLoadNodeArray},
    {"ReLoadNodeArray",		CFuncs::ScriptReLoadNodeArray},
	{"ParseNodeArray",		CFuncs::ScriptParseNodeArray},
    
    // SetBackgroundColor r=0 g=0 b=0 alpha=0
    {"SetBackgroundColor",  CFuncs::ScriptSetBackgroundColor},
    
    // Won't do anything yet ...   
    // SetAmbientColor r=0 g=0 b=0 alpha=0                                         
//    {"SetBSPAmbientColor",  CFuncs::ScriptSetBSPAmbientColor},
//    {"SetDFFAmbientColor",  CFuncs::ScriptSetDFFAmbientColor},
//    {"SetDFFDirectColor",  CFuncs::ScriptSetDFFDirectColor},
//	{"SetDFFDirectRotation", Mdl::ScriptSetDirectionalLightDirection},
//	{"SetDFFDirectActive", Mdl::ScriptSetDirectionalLightActive},
	
	{"SetDynamicLightModulationFactor", CFuncs::ScriptSetDynamicLightModulationFactor},
    
    // Sets the clipping distances.
    // SetClippingDistances Near=100 Far=1000
    {"SetClippingDistances",    CFuncs::ScriptSetClippingDistances},
	{"SetTrivialFarZClip",		CFuncs::ScriptSetTrivialFarZClip},
    
	// Sets the default world size (for viewing dffs)
    // SetWorldSize Size=100
//    {"SetWorldSize",    CFuncs::ScriptSetWorldSize},

    // Sets the movement( translational ) velocity for the camera in the viewer
	{"SetMovementVelocity", CFuncs::ScriptSetMovementVelocity },
	// Sets the rotational velocity for the camera in the viewer
	{"SetRotateVelocity", CFuncs::ScriptSetRotateVelocity},

	{"SkaterLastScoreLandedGreaterThan", CFuncs::ScriptLastScoreLandedGreaterThan},
	{"SkaterLastScoreLandedLessThan", CFuncs::ScriptLastScoreLandedLessThan},
	{"SkaterTotalScoreGreaterThan", CFuncs::ScriptTotalScoreGreaterThan},
	{"AnySkaterTotalScoreAtLeast", CFuncs::ScriptAnyTotalScoreAtLeast},
	{"OnlyOneSkaterLeft", CFuncs::ScriptOnlyOneSkaterLeft},
	{"SkaterTotalScoreLessThan", CFuncs::ScriptTotalScoreLessThan},
	{"SkaterCurrentScorePotGreaterThan", CFuncs::ScriptCurrentScorePotGreaterThan},
	{"SkaterCurrentScorePotLessThan", CFuncs::ScriptCurrentScorePotLessThan},
	{"SkaterGetScoreInfo", CFuncs::ScriptSkaterGetScoreInfo},

	{"SkaterSpeedGreaterThan", CFuncs::ScriptSkaterSpeedGreaterThan},
	{"SkaterSpeedLessThan", CFuncs::ScriptSkaterSpeedLessThan},

	{"ToggleAlwaysSpecial", CFuncs::ScriptToggleAlwaysSpecial},

	{"Debounce",			CFuncs::ScriptDebounce},
	{"SetStatOverride",		CFuncs::ScriptSetStatOverride},
	{"ToggleRails",			CFuncs::ScriptToggleRails},
	{"ToggleRigidBodyDebug", CFuncs::ScriptToggleRigidBodyDebug},
	{"CheckForHoles",		CFuncs::ScriptCheckForHoles},
	
	{"OnReload",			CFuncs::ScriptOnReload},
	{"ResetEngine",			CFuncs::ScriptResetEngine},
	{"ResetSkaters",		CFuncs::ScriptResetSkaters},
	{"ToggleMetrics",		CFuncs::ScriptToggleMetrics},
	{"ToggleVRAMViewer",	CFuncs::ScriptToggleVRAMViewer},
	{"ToggleLightViewer",	CFuncs::ScriptToggleLightViewer},
	{"DumpVRAMUsage",		CFuncs::ScriptDumpVRAMUsage},
	{"SetVRAMPackContext",	CFuncs::ScriptSetVRAMPackContext},
	{"Cleanup",	    		CFuncs::ScriptCleanup},
	{"ProximCleanup",  		CFuncs::ScriptProximCleanup},
	{"LoadQB",				CFuncs::ScriptLoadQB},
	{"UnloadQB",			CFuncs::ScriptUnloadQB},
	{"DebugRenderIgnore",	CFuncs::ScriptDebugRenderIgnore},
	{"debugrendermode",		CFuncs::ScriptSetDebugRenderMode},
	{"debugtoggletextureupload",		CFuncs::ScriptToggleTextureUpload},
	{"debugtoggletexturedraw",		CFuncs::ScriptToggleTextureDraw},
	{"debugtogglepointdraw",		CFuncs::ScriptTogglePointDraw},
	{"debugrendertest1",			CFuncs::ScriptRenderTest1},
	{"debugrendertest2",			CFuncs::ScriptRenderTest2},

    {"IsZero",					CFuncs::ScriptIsZero},
	{"CastToInteger",			CFuncs::ScriptCastToInteger},
	{"StringToInteger",			CFuncs::ScriptStringToInteger},
	{"IntegerEquals",			CFuncs::ScriptIntegerEquals},
	{"ChecksumEquals",			CFuncs::ScriptChecksumEquals},
	{"StringEquals",			CFuncs::ScriptStringEquals},
	{"ArrayContains",			CFuncs::ScriptArrayContains},
	{"GetArraySize",			CFuncs::ScriptGetArraySize},
	{"SetArrayElement",			CFuncs::ScriptSetArrayElement},
	{"Get3DArrayData",			CFuncs::ScriptGet3DArrayData},
	{"Get2DArrayData",			CFuncs::ScriptGet2DArrayData},
	{"GetNDArrayData",			CFuncs::ScriptGetNDArrayData},
	{"AddParams",				CFuncs::ScriptAddParams},
	{"RemoveComponent",			CFuncs::ScriptRemoveComponent},
	{"SetScriptString",			CFuncs::ScriptSetScriptString},
	{"GetScriptString",			CFuncs::ScriptGetScriptString},
    {"KenTest1",				CFuncs::ScriptKenTest1},
    {"KenTest2",				CFuncs::ScriptKenTest2},
	{"AppendSuffix",			CFuncs::ScriptAppendSuffix},
	{"FindNearestRailPoint",	CFuncs::ScriptFindNearestRailPoint},
	{"GetTime",					CFuncs::ScriptGetTime},
	{"GetDate",					CFuncs::ScriptGetDate},
	{"GetObNearestScreenCoord",	CFuncs::ScriptGetObNearestScreenCoord},
	{"Randomize",				CFuncs::ScriptRandomize},
	{"RunningReplay",			Replay::ScriptRunningReplay},
	{"PauseReplay",				Replay::ScriptPauseReplay},
	{"UnPauseReplay",			Replay::ScriptUnPauseReplay},
	{"DeleteDummies",			Replay::ScriptDeleteDummies},
	{"ShowGameObjects",			Replay::ScriptShowGameObjects},
	{"HideGameObjects",			Replay::ScriptHideGameObjects},
	{"PlaybackReplay",			Replay::ScriptPlaybackReplay},
	{"ReplayRecordSimpleScriptCall",	Replay::ScriptReplayRecordSimpleScriptCall},
	{"RecordPanelMessage",		Replay::ScriptRecordPanelMessage},
	{"SwitchToReplayRecordMode",Replay::ScriptSwitchToReplayRecordMode},
	{"SwitchToReplayIdleMode",	Replay::ScriptSwitchToReplayIdleMode},
	{"AllocateReplayMemory",	Replay::ScriptAllocateReplayMemory},
	{"DeallocateReplayMemory",	Replay::ScriptDeallocateReplayMemory},
	{"StartRecordingAfresh",				Replay::ScriptStartRecordingAfresh},
	{"RememberLevelStructureNameForReplays",	Replay::ScriptRememberLevelStructureNameForReplays},
	{"GetReplayLevelStructureName",	Replay::ScriptGetReplayLevelStructureName},
	{"ClearTrickAndScoreText",		Replay::ScriptClearTrickAndScoreText},
	{"NeedToLoadReplayBuffer",	CFuncs::ScriptNeedToLoadReplayBuffer},
	{"LoadReplayData",			CFuncs::ScriptLoadReplayData},
	{"ResetTimer",				CFuncs::ScriptResetTimer},
	{"TimeGreaterThan",			CFuncs::ScriptTimeGreaterThan},
	{"GetStartTime",			CFuncs::ScriptGetStartTime},
	{"GetElapsedTime",          CFuncs::ScriptGetElapsedTime},
	{"RemoveParameter",			CFuncs::ScriptRemoveParameter},
	{"GetRandomValue",			CFuncs::ScriptGetRandomValue},
	{"SetConfig",				CFuncs::ScriptSetConfig},
	{"PrintConfig",				CFuncs::ScriptPrintConfig},
	{"German",					CFuncs::ScriptGerman},
	{"French",					CFuncs::ScriptFrench},
	{"Spanish",					CFuncs::ScriptSpanish},
	{"Italian",					CFuncs::ScriptItalian},
	{"GetNodeName",				CFuncs::ScriptGetNodeName},
	{"SetTesterScript",			CFuncs::ScriptSetTesterScript},
	{"KillTesterScript",		CFuncs::ScriptKillTesterScript},
	{"ResetStopwatch",			CFuncs::ScriptResetStopwatch},
	{"PrintStopwatchTime",		CFuncs::ScriptPrintStopwatchTime},
	{"CustomSkaterFilenameDefined",CFuncs::ScriptCustomSkaterFilenameDefined},
	{"GetCustomSkaterFilename",	CFuncs::ScriptGetCustomSkaterFilename},
	{"SetCustomSkaterFilename",	CFuncs::ScriptSetCustomSkaterFilename},
	{"CurrentSkaterIsPro",		CFuncs::ScriptCurrentSkaterIsPro},
	{"EditingPark",				CFuncs::ScriptEditingPark},
	{"GetParkName",				CFuncs::ScriptGetParkName},
	{"SetParkName",				CFuncs::ScriptSetParkName},
	{"ParkEditorThemeWasSwitched",CFuncs::ScriptParkEditorThemeWasSwitched},
	{"GetGoalsCompleted",		CFuncs::ScriptGetGoalsCompleted},
	{"GetNextLevelRequirements",CFuncs::ScriptGetNextLevelRequirements},
	{"MenuIsShown",				CFuncs::ScriptMenuIsShown},
	{"MenuIsSelected",			CFuncs::ScriptMenuIsSelected},

	{"GetMostRecentSave",		CFuncs::ScriptGetMostRecentSave},
	{"GetMemCardSpaceAvailable",CFuncs::ScriptGetMemCardSpaceAvailable},
	{"GetMemCardSpaceRequired",	CFuncs::ScriptGetMemCardSpaceRequired},
	{"MemCardFileExists",		CFuncs::ScriptMemCardFileExists},
	{"DeleteMemCardFile",		CFuncs::ScriptDeleteMemCardFile},
	{"FormatCard",				CFuncs::ScriptFormatCard},
	{"CardIsInSlot",			CFuncs::ScriptCardIsInSlot},
	{"SectorSizeOK",			CFuncs::ScriptSectorSizeOK},
	{"CardIsDamaged",			CFuncs::ScriptCardIsDamaged},
	{"CardIsForeign",			CFuncs::ScriptCardIsForeign},
	{"BadDevice",				CFuncs::ScriptBadDevice},
	{"GetSaveInfo",				CFuncs::ScriptGetSaveInfo},
	{"CreateTemporaryMemCardPools",CFuncs::ScriptCreateTemporaryMemCardPools},
	{"RemoveTemporaryMemCardPools",CFuncs::ScriptRemoveTemporaryMemCardPools},
	{"SwitchToTempPoolsIfTheyExist",CFuncs::ScriptSwitchToTempPoolsIfTheyExist},
	{"SwitchToRegularPools",	CFuncs::ScriptSwitchToRegularPools},
	{"CardIsFormatted",			CFuncs::ScriptCardIsFormatted},
	{"SaveFailedDueToInsufficientSpace",CFuncs::ScriptSaveFailedDueToInsufficientSpace},
	{"GetSummaryInfo",			CFuncs::ScriptGetSummaryInfo},
	{"SaveToMemoryCard",		CFuncs::ScriptSaveToMemoryCard},
	{"LoadFromMemoryCard",		CFuncs::ScriptLoadFromMemoryCard},
	{"LoadedCustomSkater",		CFuncs::ScriptLoadedCustomSkater},
	{"SetSectionsToApplyWhenLoading",CFuncs::ScriptSetSectionsToApplyWhenLoading},
	{"GetMemCardDataForUpload",	CFuncs::ScriptGetMemCardDataForUpload},
	{"ClearMemCardDataForUpload",CFuncs::ScriptClearMemCardDataForUpload},
	{"GetMaxTHPS4FilesAllowed",	CFuncs::ScriptGetMaxTHPS4FilesAllowed},
	{"GetMemCardDirectoryListing",CFuncs::ScriptGetMemCardDirectoryListing},
	{"ForEachIn",				CFuncs::ScriptForEachIn},
	{"SizeOf",					CFuncs::ScriptSizeOf},
	{"GetElement",				CFuncs::ScriptGetElement},
	{"GetNextArrayElement",		CFuncs::ScriptGetNextArrayElement},
	{"GetRandomArrayElement",	CFuncs::ScriptGetRandomArrayElement},
	{"PermuteArray",			CFuncs::ScriptPermuteArray},
	{"CreateIndexArray",		CFuncs::ScriptCreateIndexArray},
	{"GetGammaValues",			CFuncs::ScriptGetGammaValues},
	{"ApplyChangeGamma",		CFuncs::ScriptApplyChangeGamma},
	{"GotParam",				CFuncs::ScriptGotParam},
	{"Goto",					CFuncs::ScriptGoto},
	{"GotoPreserveParams",		CFuncs::ScriptGotoPreserveParams},
	{"GotoRandomScript",		CFuncs::ScriptGotoRandomScript},

	{"PreloadModel", CFuncs::ScriptPreloadModel},

	{"LaunchPanelMessage", 		CFuncs::ScriptDummyCommand},
	{"LaunchLocalPanelMessage", CFuncs::ScriptDummyCommand},
	{"KillMessages", 			CFuncs::ScriptDummyCommand},
	{"ChangeLocalMessage", 		CFuncs::ScriptDummyCommand},
	{"LaunchConsoleMessage", 	CFuncs::ScriptDummyCommand},
	//{"FireMenuEvent",			Front::ScriptFireMenuEvent},

	{"SetViewMode",				CFuncs::ScriptSetViewMode},
	
	{"ToggleRenderMode",		CFuncs::ScriptToggleRenderMode},
	{"SetRenderMode",			CFuncs::ScriptSetRenderMode},
	{"SetWireframeMode",		CFuncs::ScriptSetWireframeMode},
	{"ScreenShot",				CFuncs::ScriptScreenShot},
	{"DumpShots",				CFuncs::ScriptDumpShots},
	//{"SetStat",					CFuncs::ScriptSetStat},

	{"LoadFont", 				Nx::ScriptLoadFont},
	{"UnloadFont",				Nx::ScriptUnloadFont},

	{"LoadTexture", 			Nx::ScriptLoadTexture},
	{"UnloadTexture",			Nx::ScriptUnloadTexture},
	{"AddTextureToVram", 		Nx::ScriptAddTextureToVram},
	{"RemoveTextureFromVram",	Nx::ScriptRemoveTextureFromVram},
	{"LoadFaceTextureFromProfile", Nx::ScriptLoadFaceTextureFromProfile},
	{"Generate32BitImage",		Nx::ScriptGenerate32BitImage},
	{"OffsetTexture",			Nx::ScriptOffsetTexture},
    {"AdjustTextureRegion",		Nx::ScriptAdjustTextureRegion},
	{"PullTextureToEdge",		Nx::ScriptPullTextureToEdge},
	{"PushTextureToPoint",		Nx::ScriptPushTextureToPoint},
	{"AdjustTextureBrightness",	Nx::ScriptAdjustTextureBrightness},
	{"AdjustTextureHSV",		Nx::ScriptAdjustTextureHSV},
	{"CopyTexture",				Nx::ScriptCopyTexture},
	{"CombineTextures",			Nx::ScriptCombineTextures},
	{"LoadParticleTexture",		Nx::ScriptLoadParticleTexture},
	{"UnloadParticleTexture",	Nx::ScriptUnloadParticleTexture},
	{"LoadSFPTexture",			Nx::ScriptLoadSFPTexture},
	{"UnloadSFPTexture",		Nx::ScriptUnloadSFPTexture},
	{"DumpTextures",			Nx::ScriptDumpTextures},

	{"SetModelFaceTexturePoints", Nx::ScriptSetModelFaceTexturePoints},
	{"SetFaceMassageTextureOverlay", Nx::ScriptSetFaceMassageTextureOverlay},
	{"MassageFaceTexture",		Nx::ScriptMassageFaceTexture},
	{"AdjustFaceTextureToModel", Nx::ScriptAdjustFaceTextureToModel},
	{"CombineFaceTextureWithOverlay", Nx::ScriptCombineFaceTextureWithOverlay},

	{"SetLightAmbientColor",  	Nx::ScriptSetLightAmbientColor},
	{"SetLightDirection",		Nx::ScriptSetLightDirection},
	{"SetLightDiffuseColor",	Nx::ScriptSetLightDiffuseColor},
	{"PushWorldLights",			Nx::ScriptPushWorldLights},
	{"PopWorldLights",			Nx::ScriptPopWorldLights},

	{"SetColorBufferClear",		CFuncs::ScriptSetColorBufferClear},

	{"SetEventHandler",			CFuncs::ScriptSetEventHandler},	   
	{"ClearEventHandler",		CFuncs::ScriptClearEventHandler},
	{"ClearEventHandlerGroup",	CFuncs::ScriptClearEventHandlerGroup},
	{"OnExceptionRun",			CFuncs::ScriptOnExceptionRun},
	{"OnExitRun",				CFuncs::ScriptOnExitRun},
	
	{"SetUVWibbleParams",  		CFuncs::ScriptSetUVWibbleParams},
	{"EnableExplicitUVWibble",	CFuncs::ScriptEnableExplicitUVWibble},
	{"DisableExplicitUVWibble",	CFuncs::ScriptDisableExplicitUVWibble},
	{"SetUVWibbleOffsets",		CFuncs::ScriptSetUVWibbleOffsets},

	{"ToggleMetricItem",		CFuncs::ScriptToggleMetricItem},
	{"ToggleMemMetrics",		CFuncs::ScriptToggleMemMetrics},

	{"KillAllTextureSplats",	CFuncs::ScriptKillAllTextureSplats},
	
	{"PreloadModels",			CFuncs::ScriptPreloadModels},
	{"PreloadPedestrians",		CFuncs::ScriptPreloadPedestrians},
	{"PreselectRandomPedestrians",		CFuncs::ScriptPreselectRandomPedestrians},
	{"ReplaceCarTextures",		CFuncs::ScriptReplaceCarTextures},

	{"LoadSound",				CFuncs::ScriptLoadSound},
    // PlaySound "SoundName" Vol=100 Pitch=100
	{"PlaySound",				CFuncs::ScriptPlaySound},
	{"StopSound",				CFuncs::ScriptStopSound},
	{"StopAllSounds",			CFuncs::ScriptStopAllSounds},
	{"SetSoundParams",			CFuncs::ScriptSetSoundParams},
	{"IsSoundPlaying",			CFuncs::ScriptIsSoundPlaying},
	// 0-100 for zero to 100percent reverb level...
	{"SetSfxReverb",   			CFuncs::ScriptSetReverb},
	{"SetSfxVolume",   			CFuncs::ScriptSetVolume},
	{"SetSfxDropoff",			CFuncs::ScriptSetDropoff},
	{"LoadTerrainSounds",		CFuncs::ScriptLoadTerrainSounds},
	{"SetObjectColor",			CFuncs::ScriptSetObjectColor},
	{"SetSceneColor",			CFuncs::ScriptSetSceneColor},
	{"CompressVC",				CFuncs::ScriptCompressVC},
	{"NudgeVC",					CFuncs::ScriptNudgeVC},
	{"FakeLights",				CFuncs::ScriptFakeLights},
	{"CenterCamera",			CFuncs::ScriptCenterCamera},
	// music tracks commands:
	{"SetMusicVolume",			CFuncs::ScriptSetMusicVolume},
	{"SetMusicStreamVolume",	CFuncs::ScriptSetMusicStreamVolume},
	{"PlayTrack",				CFuncs::ScriptPlayTrack},
	{"PlayMusicStream",			CFuncs::ScriptPlayMusicStream},
	{"SkipMusicTrack", 			CFuncs::ScriptSkipMusicTrack},
	{"PauseMusic",				CFuncs::ScriptPauseMusic},
	{"StopMusic",				CFuncs::ScriptStopMusic},
	{"SetMusicMode",			CFuncs::ScriptSetMusicMode},
	{"SetRandomMode",			CFuncs::ScriptSetRandomMode},
	{"SetMusicLooping",			CFuncs::ScriptSetMusicLooping},
	{"LoadMusicHeader",			CFuncs::ScriptLoadMusicHeader},
	{"LoadStreamHeader",		CFuncs::ScriptLoadStreamHeader},
	{"StreamIsAvailable",		CFuncs::ScriptStreamIsAvailable}, // only can be used in the skateshop!
	// tracks added to the tracklist get played randomly during the game...
	{"AddMusicTrack",			CFuncs::ScriptAddMusicTrack},
	{"ChangeTrackState",		CFuncs::ScriptChangeTrackState},
    {"GetCurrentTrack",		    CFuncs::ScriptGetCurrentTrack},
	{"TrackEnabled",			CFuncs::ScriptTrackEnabled},
	{"MusicIsPaused",			CFuncs::ScriptMusicIsPaused},
	{"ClearMusicTrackList",		CFuncs::ScriptClearMusicTrackList},
	{"PlayStream",				CFuncs::ScriptPlayStream},
	{"StopStream",				CFuncs::ScriptStopStream},
	{"PauseStream",				CFuncs::ScriptPauseStream},
	{"SetStreamParams",			CFuncs::ScriptSetStreamParams},
	{"IsStreamPlaying",			CFuncs::ScriptIsStreamPlaying},
	{"LoadStreamFrameAmp",		CFuncs::ScriptLoadStreamFrameAmp},
	{"FreeStreamFrameAmp",		CFuncs::ScriptFreeStreamFrameAmp},
	{"PlayMovie",				CFuncs::ScriptPlayMovie},
	
	{"SetGameType",				Mdl::ScriptSetGameType},
	{"InTeamGame",				Mdl::ScriptInTeamGame},
	{"SetNumTeams",				GameNet::Manager::ScriptSetNumTeams},
	{"GetNumTeams",				GameNet::Manager::ScriptGetNumTeams},
	{"GetNumPlayersOnTeam",		GameNet::Manager::ScriptGetNumPlayersOnTeam},
	{"GetMyTeam",				GameNet::Manager::ScriptGetMyTeam},
	{"JoinTeam",				GameNet::Manager::ScriptJoinTeam},
	{"GetCollidingPlayerAndTeam", CFuncs::ScriptGetCollidingPlayerAndTeam},
    {"LobbyCheckKeyboard",      CFuncs::ScriptLobbyCheckKeyboard},
	{"TestGameType",			Mdl::ScriptTestGameType},
	{"TestRequestedGameType",	Mdl::ScriptTestRequestedGameType},
	{"ChangeLevel",				Mdl::ScriptChangeLevel},
	{"LaunchLevel",				Mdl::ScriptLaunchLevel},
	{"RequestLevel",			Mdl::ScriptRequestLevel},
	{"Retry",					Mdl::ScriptRetry},
	{"LaunchGame",				Mdl::ScriptLaunchGame},
	{"ResetLevel",				Mdl::ScriptResetLevel},
	{"FillRankingScreen",		Mdl::ScriptFillRankingScreen},
	{"InitSkaterHeaps",			Mdl::ScriptInitSkaterHeaps},

	{"NodeExists",				CFuncs::ScriptNodeExists},
	{"Create",					CFuncs::ScriptCreate},
	{"CreateFromStructure",		CFuncs::ScriptCreateFromStructure},
	{"Kill",					CFuncs::ScriptKill},
	{"Visible",					CFuncs::ScriptVisible},
	{"Invisible",				CFuncs::ScriptInvisible},
	{"Shatter",					CFuncs::ScriptShatter},

	{"ToggleSkaterCamMode",				CFuncs::ScriptToggleSkaterCamMode},
	{"SetSkaterCamLerpReductionTimer",	CFuncs::ScriptSetSkaterCamLerpReductionTimer},
	
	{"PlaySkaterCamAnim",				CFuncs::ScriptPlaySkaterCamAnim},
	{"SetSkaterCamAnimSkippable",		CFuncs::ScriptSetSkaterCamAnimSkippable},
	{"SetSkaterCamAnimShouldPause",		CFuncs::ScriptSetSkaterCamAnimShouldPause},
	{"SkaterCamAnimFinished",			CFuncs::ScriptSkaterCamAnimFinished},
	{"SkaterCamAnimHeld",				CFuncs::ScriptSkaterCamAnimHeld},
	{"KillSkaterCamAnim",				CFuncs::ScriptKillSkaterCamAnim},
	{"GetSkaterCamAnimParams",			CFuncs::ScriptGetSkaterCamAnimParams},
	{"GetCurrentSkaterCamAnimName",		CFuncs::ScriptGetCurrentSkaterCamAnimName},

	{"PlayMovingObjectAnim",		   	CFuncs::ScriptPlayMovingObjectAnim},
	{"SetMovingObjectAnimSkippable",	CFuncs::ScriptSetMovingObjectAnimSkippable},
	{"SetMovingObjectAnimShouldPause",	CFuncs::ScriptSetMovingObjectAnimShouldPause},
	{"MovingObjectAnimFinished",		CFuncs::ScriptMovingObjectAnimFinished},
	{"MovingObjectAnimHeld",			CFuncs::ScriptMovingObjectAnimHeld},
	{"KillMovingObjectAnim",			CFuncs::ScriptKillMovingObjectAnim},

	{"PlayCutscene",		   	CFuncs::ScriptPlayCutscene},
	{"IsMovieQueued",		   	CFuncs::ScriptIsMovieQueued},
	{"HasMovieStarted",		   	CFuncs::ScriptHasMovieStarted},
	
	// (most of the cutscene functions are actually the same
	// as the movingobjectanim-style functions)
	{"SetCutsceneSkippable",	CFuncs::ScriptSetSkaterCamAnimSkippable},
	{"SetCutsceneShouldPause",	CFuncs::ScriptSetSkaterCamAnimShouldPause},
	{"CutsceneFinished",		CFuncs::ScriptSkaterCamAnimFinished},
	{"CutsceneHeld",			CFuncs::ScriptSkaterCamAnimHeld},
	{"KillCutscene",			CFuncs::ScriptKillSkaterCamAnim},

	{"SkaterDebugOn",			CFuncs::ScriptSkaterDebugOn},
	{"SkaterDebugOff",			CFuncs::ScriptSkaterDebugOff},
	{"IfDebugOn",				CFuncs::ScriptIfDebugOn},
	{"IfDebugOff",				CFuncs::ScriptIfDebugOff},
	{"Bootstrap",				CFuncs::ScriptBootstrap},
	{"CD",						CFuncs::ScriptCD},
	{"NotCD",					CFuncs::ScriptNotCD},
	{"Gunslinger",				CFuncs::ScriptGunslinger},
	{"CasArtist",				CFuncs::ScriptCasArtist},
	{"NotCasArtist",			CFuncs::ScriptNotCasArtist},
	{"SendFlag",				CFuncs::ScriptSendFlag},
	{"ClearFlag",				CFuncs::ScriptClearFlag},
	{"QueryFlag",				CFuncs::ScriptQueryFlag},
	{"SendException",			CFuncs::ScriptFlagException},
	{"IsAlive",					CFuncs::ScriptCheckIfAlive},

	{"MakeSkaterGoto",			CFuncs::ScriptMakeSkaterGoto},
	{"MakeSkaterGosub",			CFuncs::ScriptMakeSkaterGosub},

	{"LaunchMenuScreen",		Mdl::ScriptLaunchMenuScreen},
	{"UseOnePadInFrontEnd",		CFuncs::ScriptDummyCommand},
	{"SetMenuAutoRepeatTimes",	Mdl::ScriptSetMenuAutoRepeatTimes},
	{"SetMenuPadMappings",		Mdl::ScriptSetMenuPadMappings},
	{"SetButtonEventMappings",	Mdl::ScriptSetButtonEventMappings},
	{"SetAnalogStickActiveForMenus",	Mdl::ScriptSetAnalogStickActiveForMenus},

	{"ControllerPressed",		CFuncs::ScriptControllerPressed},
	{"ControllerDebounce",		CFuncs::ScriptControllerDebounce},
	{"GetAnalogueInfo",			CFuncs::ScriptGetAnalogueInfo},

	{"SetScreenMode",			CFuncs::ScriptSetScreenMode},
	{"ScriptGetScreenMode",		Nx::ScriptGetScreenMode},
	{"SetScreenModeFromGameMode",	CFuncs::ScriptSetScreenModeFromGameMode},
	{"Set2DIn3DSpaceParams",		Nx::ScriptSet2DIn3DSpaceParams},
	

	{"SpawnScript",				CFuncs::ScriptSpawnScript},
	{"SpawnSound",				CFuncs::ScriptSpawnSound},
	{"SpawnSkaterScript",		CFuncs::ScriptSpawnSkaterScript},
	{"KillSpawnedScript",		CFuncs::ScriptKillSpawnedScript},
	{"PauseSkaters",			CFuncs::ScriptPauseSkaters},
	{"UnPauseSkaters",			CFuncs::ScriptUnPauseSkaters},
	{"PauseSkater",				CFuncs::ScriptPauseSkater},
	{"UnPauseSkater",			CFuncs::ScriptUnPauseSkater},

	{"PauseGame",				CFuncs::ScriptPauseGame},
	{"UnPauseGame",				CFuncs::ScriptUnPauseGame},
    {"GameIsPaused",			CFuncs::ScriptIsGamePaused},

	{"PauseObjects",			CFuncs::ScriptPauseObjects},
	{"UnPauseObjects",			CFuncs::ScriptUnPauseObjects},

	{"PauseSpawnedScripts",		CFuncs::ScriptPauseSpawnedScripts},
	{"UnPauseSpawnedScripts",	CFuncs::ScriptUnPauseSpawnedScripts},

	// clock related functions
	{"ResetClock",				CFuncs::ScriptResetClock},
	{"PadsPluggedIn",			CFuncs::ScriptPadsPluggedIn},
	{"DoFlash",					CFuncs::ScriptDoFlash},

	{"InPreFile",				File::ScriptInPreFile},
	{"LoadPreFile",				File::ScriptLoadPreFile},
	{"UnloadPreFile",			File::ScriptUnloadPreFile},
	{"IsLoadPreFinished",		File::ScriptIsLoadPreFinished},
	{"AllLoadPreFinished",		File::ScriptAllLoadPreFinished},
	{"WaitLoadPre",				File::ScriptWaitLoadPre},
	{"WaitAllLoadPre",			File::ScriptWaitAllLoadPre},
	{"LoadPipPre",				Pip::ScriptLoadPipPre},
	{"UnLoadPipPre",			Pip::ScriptUnloadPipPre},
	{"DumpPipPreStatus",		Pip::ScriptDumpPipPreStatus},
	{"StartServer",				CFuncs::ScriptStartServer},
	{"SpawnCrown",				GameNet::Manager::ScriptSpawnCrown},
	{"StartCTFGame",			GameNet::Manager::ScriptStartCTFGame},
	{"EndCTFGame",				GameNet::Manager::ScriptEndCTFGame},
	{"PlayerTookFlag",			GameNet::Manager::ScriptTookFlag},
	{"PlayerCapturedFlag",		GameNet::Manager::ScriptCapturedFlag},
	{"PlayerRetrievedFlag",		GameNet::Manager::ScriptRetrievedFlag},
	{"PlayerHasFlag",			GameNet::Manager::ScriptHasFlag},
    {"TeamFlagTaken",			GameNet::Manager::ScriptTeamFlagTaken},
	{"DisplayFlagBaseWarning",	GameNet::Manager::ScriptDisplayFlagBaseWarning},
	{"FindServers",				CFuncs::ScriptFindServers},
	{"FoundServers",			GameNet::Manager::ScriptFoundServers},
	{"JoinServer",				CFuncs::ScriptJoinServer},
	{"LeaveServer",				CFuncs::ScriptLeaveServer},
	{"SetNetworkMode",			CFuncs::ScriptSetNetworkMode},
	{"SetServerMode",			CFuncs::ScriptSetServerMode},
	{"StartNetworkGame",		GameNet::Manager::ScriptStartNetworkGame},
	{"NetworkGamePending",		GameNet::Manager::ScriptNetworkGamePending},
	{"EndNetworkGame", 			GameNet::Manager::ScriptEndNetworkGame},
	{"EnteredNetworkGame",		GameNet::Manager::ScriptEnteredNetworkGame},
	{"JustStartedNetGame",		GameNet::Manager::ScriptJustStartedNetGame},
	{"OverrideGameModeOptions",	Game::ScriptOverrideGameModeOptions},

	{"ResetCamera",				CFuncs::ScriptResetCamera},
	{"GetValueFromVolume",		CFuncs::ScriptGetValueFromVolume},
	{"SetSliderValue",			CFuncs::ScriptSetSliderValue},
	{"SetVolumeFromValue",		CFuncs::ScriptSetVolumeFromValue},
	
	{"ResetDefaultAppearance",	CFuncs::ScriptResetDefaultAppearance},
	{"ResetDefaultTricks",		CFuncs::ScriptResetDefaultTricks},
	{"ResetDefaultStats",		CFuncs::ScriptResetDefaultStats},
	{"RandomizeAppearance",		CFuncs::ScriptRandomizeAppearance},
	{"PrintCurrentAppearance",	CFuncs::ScriptPrintCurrentAppearance},
	{"SetNeversoftSkater",		CFuncs::ScriptSetNeversoftSkater},
	{"CurrentProfileIsLocked",	CFuncs::ScriptCurrentProfileIsLocked},
	{"SetIconTexture",			CFuncs::ScriptSetIconTexture},
	
	{"MemViewToggle",           CFuncs::ScriptMemViewToggle},

    {"EnableFog",				CFuncs::ScriptEnableFog},
    {"DisableFog",				CFuncs::ScriptDisableFog},
    {"SetFogDistance",			CFuncs::ScriptSetFogDistance},
    {"SetFogExponent",			CFuncs::ScriptSetFogExponent},
	{"SetFogColor",				CFuncs::ScriptSetFogColor},
	
	{"Change",					CFuncs::ScriptChangeSymbolValue},
	{"PreferenceEquals",		CFuncs::ScriptPreferenceEquals},
	{"SetUIFromPreferences",	CFuncs::ScriptSetUIFromPreferences},
	{"SetUIFromSkaterProfile",	CFuncs::ScriptSetUIFromSkaterProfile},
	{"SetPreference",			CFuncs::ScriptSetPreference},
	{"SetPreferencesFromUI",	CFuncs::ScriptSetPreferencesFromUI},
	{"GetPreferenceString",		CFuncs::ScriptGetPreferenceString},
	{"GetPreferencePassword",	CFuncs::ScriptGetPreferencePassword},
	{"GetPreferenceChecksum",	CFuncs::ScriptGetPreferenceChecksum},
	
	{"MemPushContext",			CFuncs::ScriptMemPushContext},
	{"MemPopContext",			CFuncs::ScriptMemPopContext},
	{"ProfileTasks",			CFuncs::ScriptProfileTasks},
	{"UseNetworkPreferences",	CFuncs::ScriptUseNetworkPreferences},
	{"CanChangeDevices",		CFuncs::ScriptCanChangeDevices},
	{"NeedToTestNetSetup",		CFuncs::ScriptNeedToTestNetSetup},
	{"TestNetSetup",			CFuncs::ScriptTestNetSetup},
	{"StopAllScripts",			CFuncs::ScriptStopAllScripts},
	{"SetMenuElementText",		CFuncs::ScriptSetMenuElementText},
	{"FirstTimeThisIsCalled",	CFuncs::ScriptFirstTimeThisIsCalled},
	{"VibrationIsOn",			CFuncs::ScriptVibrationIsOn},
	{"VibrationOff",			CFuncs::ScriptVibrationOff},
	{"VibrationOn",				CFuncs::ScriptVibrationOn},
	{"VibrateController",		CFuncs::ScriptVibrateController},
	{"EnableActuators",			CFuncs::ScriptEnableActuators},
	{"AutoKickIsOn",			CFuncs::ScriptAutoKickIsOn},
	{"AutoKickOn",				CFuncs::ScriptAutoKickOn},
	{"AutoKickOff",				CFuncs::ScriptAutoKickOff},
	{"SpinTapsAreOn",			CFuncs::ScriptSpinTapsAreOn},
	{"SpinTapsOn",				CFuncs::ScriptSpinTapsOn},
	{"SpinTapsOff",				CFuncs::ScriptSpinTapsOff},
	{"IsOnline",				CFuncs::ScriptIsOnline},
	{"ConnectToInternet",		CFuncs::ScriptConnectToInternet},
	{"CancelConnectToInternet",	CFuncs::ScriptCancelConnectToInternet},
	{"CancelLogon",				CFuncs::ScriptCancelLogon},
	{"DisconnectFromInternet",	CFuncs::ScriptDisconnectFromInternet},
	{"InNetGame",				CFuncs::ScriptInNetGame},
	{"DumpScripts",				CFuncs::ScriptDumpScripts},
	{"SetSlomo",				CFuncs::ScriptSetSlomo},
	{"SetArenaSize",			CFuncs::ScriptSetArenaSize},
	{"ToggleNetMetrics",		CFuncs::ScriptToggleNetMetrics },
	{"GetCurrentProDisplayInfo",CFuncs::ScriptGetCurrentProDisplayInfo},
	{"SetPlayerAppearance",		CFuncs::ScriptSetPlayerAppearance},
	{"SetPlayerFaceTexture",	CFuncs::ScriptSetPlayerFaceTexture},
    {"SetPlayerFaceOverlayTexture",	CFuncs::ScriptSetPlayerFaceOverlayTexture},
	{"ClearPlayerFaceTexture",	CFuncs::ScriptClearPlayerFaceTexture},
	{"GetPlayerFacePoints",		CFuncs::ScriptGetPlayerFacePoints},
	{"SetPlayerFacePoints",		CFuncs::ScriptSetPlayerFacePoints},
	{"PlayerFaceIsValid",		CFuncs::ScriptPlayerFaceIsValid},
	{"SelectCurrentSkater",		CFuncs::ScriptSelectCurrentSkater},
	{"SetParticleSysVisibility",CFuncs::ScriptSetParticleSysVisibility},
	{"TogglePlayerNames",		CFuncs::ScriptTogglePlayerNames},
	{"SetCurrentGameType",		CFuncs::ScriptSetCurrentGameType},
	{"DumpNetMessageStats",		CFuncs::ScriptDumpNetMessageStats},
	{"NotifyBailDone",			CFuncs::ScriptNotifyBailDone},
	{"ClearPowerups",			CFuncs::ScriptClearPowerups},
	{"BroadcastProjectile",		CFuncs::ScriptBroadcastProjectile},
	{"BroadcastEnterVehicle",	CFuncs::ScriptBroadcastEnterVehicle},

	// Loading screen
	{"DisplayLoadingScreen",	CFuncs::ScriptDisplayLoadingScreen},
	{"HideLoadingScreen",		CFuncs::ScriptHideLoadingScreen},

	// Loading bar of loading screen
	{"SetLoadingBarPos",		Nx::ScriptSetLoadingBarPos},
	{"SetLoadingBarSize",		Nx::ScriptSetLoadingBarSize},
	{"SetLoadingBarStartColor",	Nx::ScriptSetLoadingBarStartColor},
	{"SetLoadingBarEndColor",	Nx::ScriptSetLoadingBarEndColor},
	{"SetLoadingBarBorder",		Nx::ScriptSetLoadingBarBorder},
	{"SetLoadingBarBorderColor",Nx::ScriptSetLoadingBarBorderColor},

	// park editor, ya munks
	{"SetParkEditorTimeOfDay",	Ed::ScriptSetParkEditorTimeOfDay},
	{"GetParkEditorTimeOfDayScript",Ed::ScriptGetParkEditorTimeOfDayScript},
	{"RebuildParkNodeArray",	Ed::ScriptRebuildParkNodeArray},
	{"FreeUpMemoryForPlayingPark",Ed::ScriptFreeUpMemoryForPlayingPark},
	{"CalibrateMemoryGauge",	Ed::ScriptCalibrateMemoryGauge},
	{"GetParkEditorCursorPos",	Ed::ScriptGetParkEditorCursorPos},
	{"SwitchToParkEditorCamera",Ed::ScriptSwitchToParkEditorCamera},
	{"SetParkEditorState",		Ed::ScriptSetParkEditorState},
	{"SetParkEditorPauseMode",	Ed::ScriptSetParkEditorPauseMode},
	{"SetParkEditorMaxPlayers",	Ed::ScriptSetParkEditorMaxPlayers},
	{"GetParkEditorMaxPlayers",	Ed::ScriptGetParkEditorMaxPlayers},
	{"GetParkEditorMaxPlayersPossible",Ed::ScriptGetParkEditorMaxPlayersPossible},
	{"CustomParkMode",			Ed::ScriptCustomParkMode},
	{"CanCleanlyResizePark",	Ed::ScriptCanCleanlyResizePark},
	#ifdef __PLAT_NGC__
	{"WriteCompressedMapBuffer",Ed::ScriptWriteCompressedMapBuffer},
	{"RequiresDefragment",		Ed::ScriptRequiresDefragment},
	{"TopDownHeapTooLow",		Ed::ScriptTopDownHeapTooLow},
	#endif
	{"ResizePark",				Ed::ScriptResizePark},
	{"GetCurrentParkBounds",	Ed::ScriptGetCurrentParkBounds},
	{"CanChangeParkDimension", 	Ed::ScriptCanChangeParkDimension},
	{"SaveParkToDisk",			Ed::ScriptSaveParkToDisk},
	{"LoadParkFromDisk",		Ed::ScriptLoadParkFromDisk},
	{"IsParkUnsaved",			Ed::ScriptIsParkUnsaved},
	{"FireCustomParkGap",		Ed::ScriptFireCustomParkGap},
	{"SetEditedParkGapInfo",	Ed::ScriptSetEditedParkGapInfo},
	{"GetEditedParkGapName",	Ed::ScriptGetEditedParkGapName},
	{"ParkEditorSelectionAreaTooBigToCopy",Ed::ScriptParkEditorSelectionAreaTooBigToCopy},
	{"CopyParkEditorSelectionToClipboard",Ed::ScriptCopyParkEditorSelectionToClipboard},
	{"SwitchParkEditorMenuPieceToMostRecentClipboard",Ed::ScriptSwitchParkEditorMenuPieceToMostRecentClipboard},
	{"CutParkEditorAreaSelection",Ed::ScriptCutParkEditorAreaSelection},
	{"ParkEditorAreaSelectionDeletePieces",Ed::ScriptParkEditorAreaSelectionDeletePieces},
	{"ContinueParkEditorAreaSelection",	Ed::ScriptContinueParkEditorAreaSelection},
	{"GetEditorTheme",			Ed::ScriptGetEditorTheme},
	{"SetEditorTheme",			Ed::ScriptSetEditorTheme},
	{"GetEditorMaxThemes",		Ed::ScriptGetEditorMaxThemes},
	{"GetCustomParkName",		Ed::ScriptGetCustomParkName},
	{"SetCustomParkName",		Ed::ScriptSetCustomParkName},
	{"BindParkEditorToController",	Ed::ScriptBindParkEditorToController},
	{"ParkEditorCommand",		CFuncs::ScriptDummyCommand},
	{"ParkEditorGetGapName",	CFuncs::ScriptDummyCommand},
	{"ParkEditorSetGapName",	CFuncs::ScriptDummyCommand},
	{"IsCustomPark",			Ed::ScriptIsCustomPark},
	{"IsUnsavedPark",			CFuncs::ScriptDummyCommand},
	
	{"ObserveNextSkater",		CFuncs::ScriptObserveNextSkater},

	// Prints the current memory usage of the bottom up heap
	{"PrintMemInfo",			CFuncs::ScriptPrintMemInfo},
	{"DisplayFreeMem",      	CFuncs::ScriptDisplayFreeMem},
	{"AnalyzeHeap",				CFuncs::ScriptAnalyzeHeap},
	{"SetMemThreadSafe",		CFuncs::ScriptMemThreadSafe},
	
	{"CareerStartLevel",		CFuncs::ScriptCareerStartLevel},
	{"CareerLevelIs",			CFuncs::ScriptCareerLevelIs},
	{"CareerReset",				CFuncs::ScriptCareerReset},
	{"SetGoal",               	CFuncs::ScriptSetGoal},        
	{"UnSetGoal",               CFuncs::ScriptUnSetGoal},        
	{"GetGoal",               	CFuncs::ScriptGetGoal},        
	{"JustGotGoal",           	CFuncs::ScriptJustGotGoal},    
	{"SetFlag",               	CFuncs::ScriptSetFlag},        
	{"UnSetFlag",               CFuncs::ScriptUnSetFlag},        
	{"GetFlag",               	CFuncs::ScriptGetFlag},        
	{"JustGotFlag",           	CFuncs::ScriptJustGotFlag},
	{"SetScoreGoal",			CFuncs::ScriptSetScoreGoal},			
	{"ClearScoreGoals",			CFuncs::ScriptClearScoreGoals},			

	{"SetGlobalFlag",           CFuncs::ScriptSetGlobalFlag},        
	{"UnSetGlobalFlag",         CFuncs::ScriptUnSetGlobalFlag},        
	{"GetGlobalFlag",           CFuncs::ScriptGetGlobalFlag},        
	
	// Career-related functions...  these refer to skater 0,
	// so don't try to use these functions from a trick script.
	{"ProfileEquals",			CFuncs::ScriptProfileEquals},
	{"IsCareerMode",			CFuncs::ScriptIsCareerMode},
	{"EndRun",					CFuncs::ScriptEndRun},
	{"AllowPause",				CFuncs::ScriptAllowPause},

	{"EnterObserverMode",		CFuncs::ScriptEnterObserverMode},
	{"EnterSurveyorMode",		GameNet::Manager::ScriptEnterSurveyorMode},
	{"ExitSurveyorMode",		GameNet::Manager::ScriptExitSurveyorMode},
	
	{"RefreshServerList",		CFuncs::ScriptRefreshServerList},
	{"SetJoinMode",				GameNet::Manager::ScriptSetJoinMode},
	{"SetHostMode",				GameNet::Manager::ScriptSetHostMode},
	{"IsHost",					GameNet::Manager::ScriptIsHost},
	{"IsAutoServing",			GameNet::Manager::ScriptIsAutoServing},
	{"ChangeLevelPending",		GameNet::Manager::ScriptChangeLevelPending},
	{"ToggleProSet",			GameNet::Manager::ScriptToggleProSet},
	{"ResetProSetFlags",		GameNet::Manager::ScriptResetProSetFlags},
		
	// Some gameflow-related tests
	{"PauseGameFlow",			CFuncs::ScriptPauseGameFlow},
	{"UnpauseGameFlow",			CFuncs::ScriptUnpauseGameFlow},
	{"InFrontEnd",				CFuncs::ScriptInFrontEnd},
	{"GetFireballLevel",		CFuncs::ScriptGetFireballLevel},
	{"InSplitScreenGame",		CFuncs::ScriptInSplitScreenGame},
	{"GameModeEquals",			CFuncs::ScriptGameModeEquals},
	{"OnServer",				CFuncs::ScriptOnServer},
	{"ShouldEndRun",			CFuncs::ScriptShouldEndRun},
	{"InitializeSkaters",		CFuncs::ScriptInitializeSkaters},
	{"SkatersAreReady",			CFuncs::ScriptSkatersAreReady},
	{"RestartLevel",			CFuncs::ScriptRestartLevel},
	{"EndRunSelected",			CFuncs::ScriptEndRunSelected},
	{"AllSkatersAreIdle",		CFuncs::ScriptAllSkatersAreIdle},
	{"FirstTrickStarted",		CFuncs::ScriptFirstTrickStarted},
	{"FirstTrickCompleted",		CFuncs::ScriptFirstTrickCompleted},
	{"CalculateFinalScores",	CFuncs::ScriptCalculateFinalScores},
	{"ReinsertSkaters",			CFuncs::ScriptReinsertSkaters},
	{"UnhookSkaters",			CFuncs::ScriptUnhookSkaters},
	{"ToggleScores",			CFuncs::ScriptToggleScores},
	{"ApplySplitScreenOptions",	CFuncs::ScriptApplySplitScreenOptions},
	{"ApplyToSkaterProfile",	CFuncs::ScriptApplyToSkaterProfile},
	{"RefreshSkaterColors",		CFuncs::ScriptRefreshSkaterColors},
	{"RefreshSkaterScale",		CFuncs::ScriptRefreshSkaterScale},
	{"RefreshSkaterVisibility", CFuncs::ScriptRefreshSkaterVisibility},
	{"RefreshSkaterUV", 		CFuncs::ScriptRefreshSkaterUV},
	{"IsTrue",					CFuncs::ScriptIsTrue},
	{"InitSkaterModel",			CFuncs::ScriptInitSkaterModel},
	{"RefreshSkaterModel",		CFuncs::ScriptRefreshSkaterModel},
	{"EditPlayerAppearance",	CFuncs::ScriptEditPlayerAppearance},
	{"GetCurrentSkaterProfileIndex", CFuncs::ScriptGetCurrentSkaterProfileIndex},
    {"GetCustomSkaterName",     CFuncs::ScriptGetCustomSkaterName},

	{"GetCurrentLevel",			CFuncs::ScriptGetCurrentLevel},

	{"StartCompetition",		CFuncs::ScriptStartCompetition},
	{"EndCompetition",			CFuncs::ScriptEndCompetition},
	{"CompetitionEnded",		CFuncs::ScriptCompetitionEnded},
	{"StartCompetitionRun",		CFuncs::ScriptStartCompetitionRun},
	{"EndCompetitionRun",		CFuncs::ScriptEndCompetitionRun},

	{"StartHorse",				CFuncs::ScriptStartHorse},
	{"EndHorse",				CFuncs::ScriptEndHorse},
	{"HorseEnded",				CFuncs::ScriptHorseEnded},
	{"HorseStatusEquals",		CFuncs::ScriptHorseStatusEquals},
	{"StartHorseRun",			CFuncs::ScriptStartHorseRun},
	{"EndHorseRun",				CFuncs::ScriptEndHorseRun},
	{"SwitchHorsePlayers",		CFuncs::ScriptSwitchHorsePlayers},
	{"GetHorseString",			CFuncs::ScriptGetHorseString},
	{"IsCurrentHorseSkater",	CFuncs::ScriptIsCurrentHorseSkater},
	{"ApplyToHorsePanelString", CFuncs::ScriptApplyToHorsePanelString},
	
	{"XTriggered",				CFuncs::ScriptXTriggered},
	{"UsePad",					CFuncs::ScriptUsePad},

	{"InMultiplayerGame",		CFuncs::ScriptInMultiplayerGame},	
	{"IsTopJudge",				CFuncs::ScriptIsTopJudge},
	{"PlaceIs",					CFuncs::ScriptPlaceIs},
	{"RoundIs",					CFuncs::ScriptRoundIs},
	
	{"GameFlow",				CFuncs::ScriptGameFlow},	
	{"AwardStatPoint",			CFuncs::ScriptAwardStatPoint},
	{"AwardSpecialTrickSlot",	CFuncs::ScriptAwardSpecialTrickSlot},
	{"UpdateSkaterStats",		CFuncs::ScriptUpdateSkaterStats},
	
	{"GoalsGreaterThan",        CFuncs::ScriptGoalsGreaterThan},    
	{"GoalsEqualTo",            CFuncs::ScriptGoalsEqualTo},
	{"MedalsGreaterThan",       CFuncs::ScriptMedalsGreaterThan},   
	{"MedalsEqualTo",           CFuncs::ScriptMedalsEqualTo},       
	{"StartServerList",			CFuncs::ScriptStartServerList},
	{"StartLobbyList",			CFuncs::ScriptStartLobbyList},
	{"NumServersInLobby",		GameNet::Manager::ScriptGetNumServersInLobby},
#ifdef __PLAT_NGPS__
	{"NumPlayersInLobby",		GameNet::LobbyMan::ScriptGetNumPlayersInLobby},
	{"RejoinLobby",				GameNet::LobbyMan::ScriptRejoinLobby},
	{"ChooseLobby",				GameNet::LobbyMan::ScriptChooseLobby},
	{"LeaveLobby",				GameNet::LobbyMan::ScriptLeaveLobby},
	{"LobbyConnect",			GameNet::LobbyMan::ScriptLobbyConnect},
	{"LobbyDisconnect",			GameNet::LobbyMan::ScriptLobbyDisconnect},
	{"FillLobbyProspectiveBuddyList",	GameNet::LobbyMan::ScriptFillLobbyProspectiveBuddyList},
	{"StartNatNegotiation",		GameNet::LobbyMan::ScriptStartNatNegotiation},
	{"CancelNatNegotiation",	GameNet::LobbyMan::ScriptCancelNatNegotiation},
	
	{"CanHostGame",             GameNet::LobbyMan::ScriptCanHostGame},
	{"SendMessage",				GameNet::LobbyMan::ScriptSendMessage},
	{"SetQuietMode",			GameNet::LobbyMan::ScriptSetQuietMode},
	{"FillPlayerList",			GameNet::LobbyMan::ScriptFillPlayerList},
	{"LoadNetConfigs",			GameNet::Manager::ScriptLoadNetConfigs},
	{"NoNetConfigFiles",		GameNet::Manager::ScriptNoNetConfigFiles},
	{"FillNetConfigList",		GameNet::Manager::ScriptFillNetConfigList},
	{"ChooseNetConfig",			GameNet::Manager::ScriptChooseNetConfig},
	{"FillPlayerListMenu",		GameNet::Manager::ScriptFillPlayerListMenu},
	{"DownloadFace",			GameNet::ContentMan::ScriptDownloadFace},
	{"UploadFile",				GameNet::ContentMan::ScriptUploadFile},
	{"DownloadFile",			GameNet::ContentMan::ScriptDownloadFile},
	{"DownloadDirectoryList",	GameNet::ContentMan::ScriptDownloadDirectoryList},
	{"FreeDirectoryListing",	GameNet::ContentMan::ScriptFreeDirectoryListing},
	{"FillVaultMenu",			GameNet::ContentMan::ScriptFillVaultMenu},
	{"NextVaultCategory",		GameNet::ContentMan::ScriptNextVaultCategory},
	{"PrevVaultCategory",		GameNet::ContentMan::ScriptPrevVaultCategory},
	{"StatsLoggedIn",			GameNet::StatsMan::ScriptStatsLoggedIn},
	{"StatsLogIn",				GameNet::StatsMan::ScriptStatsLogIn},
	{"StatsLogOff",				GameNet::StatsMan::ScriptStatsLogOff},
	{"ReportStats",				GameNet::StatsMan::ScriptReportStats},
	{"RetrievePersonalStats",	GameNet::StatsMan::ScriptRetrievePersonalStats},
	{"RetrieveTopStats",		GameNet::StatsMan::ScriptRetrieveTopStats},
	{"NeedToRetrieveTopStats",	GameNet::StatsMan::ScriptNeedToRetrieveTopStats},
	{"FillStatsArrays",			GameNet::StatsMan::ScriptFillStatsArrays},
	{"GetRank",					GameNet::StatsMan::ScriptGetRank},
	{"CleanUpTopStats",			GameNet::StatsMan::ScriptCleanUpTopStats},
	{"ProfileLoggedIn",			GameNet::BuddyMan::ScriptProfileLoggedIn},
	{"SetUniqueId",				GameNet::BuddyMan::ScriptSetUniqueId},
	{"CreateProfile",			GameNet::BuddyMan::ScriptCreateProfile},
	{"ProfileLogIn",			GameNet::BuddyMan::ScriptProfileLogIn},
	{"ProfileLogOff",			GameNet::BuddyMan::ScriptProfileLogOff},
	{"FillBuddyList",			GameNet::BuddyMan::ScriptFillBuddyList},
	{"FillProspectiveBuddyList",GameNet::BuddyMan::ScriptFillProspectiveBuddyList},
	{"AddBuddy",				GameNet::BuddyMan::ScriptAddBuddy},
	{"RemoveBuddy",				GameNet::BuddyMan::ScriptRemoveBuddy},
	{"CancelAddBuddy",			GameNet::BuddyMan::ScriptCancelAddBuddy},
	{"JoinBuddy",				GameNet::BuddyMan::ScriptJoinBuddy},
	{"HasBuddies",				GameNet::BuddyMan::ScriptHasBuddies},
	{"BuddyListFull",			GameNet::BuddyMan::ScriptBuddyListFull},
	{"SetLobbyStatus",			GameNet::BuddyMan::ScriptSetLobbyStatus},
	{"PostGame",				GameNet::Manager::ScriptPostGame},
	{"AuthenticateClient",		GameNet::Manager::ScriptAuthenticateClient },
	{"WriteDNASBinary",			GameNet::Manager::ScriptWriteDNASBinary },
#endif
	{"ConnectedToPeer",			GameNet::Manager::ScriptConnectedToPeer },
	{"InGroupRoom",				GameNet::Manager::ScriptInGroupRoom},
	
	{"ChooseServer", 			GameNet::Manager::ScriptChooseServer},
	{"DescribeServer",			GameNet::Manager::ScriptDescribeServer},
	{"RetrieveServerInfo",		GameNet::Manager::ScriptRetrieveServerInfo},
	{"CancelJoinServer", 		GameNet::Manager::ScriptCancelJoinServer},
	{"ReattemptJoinServer",		GameNet::Manager::ScriptReattemptJoinServer},
	{"CreatePlayerOptions",     GameNet::Manager::ScriptCreatePlayerOptions},
	{"AllPlayersAreReady",      GameNet::Manager::ScriptAllPlayersAreReady},
	
	{"ChooseAccount",			GameNet::Manager::ScriptChooseAccount},
	{"RemovePlayer",			GameNet::Manager::ScriptRemovePlayer},
	{"CancelRemovePlayer",		GameNet::Manager::ScriptCancelRemovePlayer},
	{"KickPlayer",				GameNet::Manager::ScriptKickPlayer},
	{"BanPlayer",				GameNet::Manager::ScriptBanPlayer},
	{"FCFSRequestStartGame",	GameNet::Manager::ScriptFCFSRequestStartGame},
	{"FCFSRequestChangeLevel",	GameNet::Manager::ScriptFCFSRequestChangeLevel},
	{"FCFSRequestToggleProSet", GameNet::Manager::ScriptFCFSRequestToggleProSet},
	{"FCFSRequestToggleGoalSelection",	GameNet::Manager::ScriptFCFSRequestToggleGoalSelection},
	{"HasSignedDisclaimer",		GameNet::Manager::ScriptHasSignedDisclaimer},
	
	// "Omnigon" is code for "cheat". Just another attempt to NOT lead hackers directly to the
	// pile of gold
	{"ClearOmnigons",			CFuncs::ScriptClearCheats},
	{"BroadcastOmnigon",		CFuncs::ScriptBroadcastCheat},
	{"LastBroadcastedOmnigonWas",CFuncs::ScriptLastBroadcastedCheatWas},
	{"OmnigonAllowed",			CFuncs::ScriptCheatAllowed},

	{"JoinWithPassword",		CFuncs::ScriptJoinWithPassword},
	{"GetRecordText",			CFuncs::ScriptGetRecordText},
	{"UpdateRecords",			CFuncs::ScriptUpdateRecords},
	{"SendChatMessage",			CFuncs::ScriptSendChatMessage},
	{"InSlapGame",				CFuncs::ScriptInSlapGame},
	{"LoadPendingPlayers",		CFuncs::ScriptLoadPendingPlayers},
	{"DropPendingPlayers",		GameNet::Manager::ScriptDropPendingPlayers},
	{"StopServerList",			CFuncs::ScriptStopServerList},
	{"FreeServerList",			CFuncs::ScriptFreeServerList},
	{"LaunchQueuedScripts",     CFuncs::ScriptLaunchQueuedScripts},
	{"IsObserving",				CFuncs::ScriptIsObserving},
	{"GetInitialsString",		CFuncs::ScriptGetInitialsString},
	{"SetInitialsString",		CFuncs::ScriptSetInitialsString},
	{"UpdateInitials",			CFuncs::ScriptUpdateInitials},
	{"NewRecord",				CFuncs::ScriptNewRecord},
	{"AttachToSkater",			CFuncs::ScriptAttachToSkater},
	{"TryCheatString",			CFuncs::ScriptTryCheatString},
	{"LevelIs",					CFuncs::ScriptLevelIs},
	{"StartNetworkLobby",		CFuncs::ScriptStartNetworkLobby},
	{"ObserversAllowed",		CFuncs::ScriptObserversAllowed},
	{"NumPlayersAllowed",		CFuncs::ScriptNumPlayersAllowed},
	{"AutoDNS",					CFuncs::ScriptAutoDNS},
	{"UsingDefaultMasterServers",CFuncs::ScriptUsingDefaultMasterServers},
	{"UsingDHCP",				CFuncs::ScriptUsingDHCP},
	{"InInternetMode",			CFuncs::ScriptInInternetMode},
	{"LoadExecPS2",				CFuncs::ScriptLoadExecPS2},
	{"ExitDemo",				CFuncs::ScriptExitDemo},
	{"SendGameOverToObservers", GameNet::Manager::ScriptSendGameOverToObservers},
	{"GameIsOver", 				CFuncs::ScriptGameIsOver},
	{"EnteringNetGame",			CFuncs::ScriptEnteringNetGame},
	{"DeviceChosen", 			CFuncs::ScriptDeviceChosen},
	{"SetLevelName",			CFuncs::ScriptSetLevelName},
	{"TrickOffAllObjects",		CFuncs::ScriptTrickOffAllObjects},
	{"DumpHeaps",				CFuncs::ScriptDumpHeaps},
	{"DumpFragments",			CFuncs::ScriptDumpFragments},
	{"ResetPS2",				CFuncs::ScriptResetPS2},
	{"ResetHD",					CFuncs::ScriptResetHD},
	{"PAL",						CFuncs::ScriptPAL},
	{"English",					CFuncs::ScriptEnglish},
	{"TimeUp",					CFuncs::ScriptTimeUp},
	{"LaunchEvent",				Obj::ScriptLaunchEvent},
	{"FireEvent",				Obj::ScriptLaunchEvent},	// LaunchEvent and FireEvent are the same
	{"PrintEventLog",			Obj::ScriptPrintEventLog},
	{"ObjectExists",			Obj::ScriptObjectExists},
	{"TerminateObjectsScripts",	Obj::ScriptTerminateObjectsScripts},
	{"AssignAlias",				Obj::ScriptAssignAlias},
	{"SetObjectProps",			Obj::ScriptSetObjectProperties},
	{"CreateScreenElement",		Front::ScriptCreateScreenElement},
	{"DestroyScreenElement",	Front::ScriptDestroyScreenElement},
	{"RunScriptOnScreenElement",	Front::ScriptRunScriptOnScreenElement},
	{"SetScreenElementProps",	Front::ScriptSetScreenElementProps},
	{"GetScreenElementProps",	Front::ScriptGetScreenElementProps},
	{"DoScreenElementMorph",	Front::ScriptDoScreenElementMorph},
	{"SetScreenElementLock",	Front::ScriptSetScreenElementLock},
	{"ScreenElementSystemInit",		Front::ScriptScreenElementSystemInit},
	{"TextElementConcatenate",	Front::ScriptTextElementConcatenate},
	{"TextElementBackspace",	Front::ScriptTextElementBackspace},
	{"GetTextElementString",	Front::ScriptGetTextElementString},
	{"GetTextElementLength",	Front::ScriptGetTextElementLength},
	{"GetScreenElementDims", 	Front::ScriptGetScreenElementDims},
	{"GetScreenElementPosition", Front::ScriptGetScreenElementPosition},
	{"LaunchViewer",			CFuncs::ScriptLaunchViewer},
	{"LaunchScriptDebugger",	CFuncs::ScriptLaunchScriptDebugger},
	{"SetViewerModel",			CFuncs::ScriptSetViewerModel},
	{"SetViewerAnim",			CFuncs::ScriptSetViewerAnim},
	{"SetViewerLODDist",		CFuncs::ScriptSetViewerLODDist},
	{"ReloadViewerAnim",		CFuncs::ScriptReloadViewerAnim},
	{"ReloadSkaterCamAnim",		CFuncs::ScriptReloadSkaterCamAnim},
	{"SetScoreDegradation",		CFuncs::ScriptGameModeSetScoreDegradation},
	{"SetScoreAccumulation",	CFuncs::ScriptGameModeSetScoreAccumulation},
	{"ResetScore",				CFuncs::ScriptResetScore},
	{"ResetScorePot", 			CFuncs::ScriptResetScorePot},
	{"ResetScoreDegradation",	CFuncs::ScriptResetScoreDegradation},
	{"UpdateScore",				CFuncs::ScriptUpdateScore},
	{"AddRestartsToMenu",		CFuncs::ScriptAddRestartsToMenu},
	{"AddGapsToMenu",			Obj::ScriptAddGapsToMenu},
	{"CreateGapList",			Obj::ScriptCreateGapList},
	{"GetLevelGapTotals",		Obj::ScriptGetLevelGapTotals},
	{"GiveAllGaps",				Obj::ScriptGiveAllGaps},
    {"SetTimeLimit",            Mdl::ScriptSetTimeLimit},
	{"MenuSelectedIndexIs",		Front::ScriptMenuSelectedIndexIs},
	{"ScreenElementExists",		Front::ScriptScreenElementExists},
	{"SetRootScreenElement",	Front::ScriptSetRootScreenElement},

	// Goal-related stuff
	{"GoalManager_AddGoal",				Game::ScriptAddGoal},
	{"GoalManager_RemoveGoal",			Game::ScriptRemoveGoal},
	{"GoalManager_EditGoal",			Game::ScriptEditGoal},
	{"GoalManager_ActivateGoal",		Game::ScriptActivateGoal},
	{"GoalManager_DeactivateGoal",		Game::ScriptDeactivateGoal},
	{"GoalManager_ClearLastGoal",		Game::ScriptClearLastGoal},
	{"GoalManager_WinGoal",				Game::ScriptWinGoal},
	{"GoalManager_LoseGoal",			Game::ScriptLoseGoal},
	{"GoalManager_RemoveAllGoals",		Game::ScriptRemoveAllGoals},
	{"GoalManager_DeactivateAllGoals",	Game::ScriptDeactivateAllGoals},
	{"GoalManager_UninitializeAllGoals",Game::ScriptUninitializeAllGoals},
	{"GoalManager_UninitializeGoal",	Game::ScriptUninitializeGoal},
	{"GoalManager_InitializeAllGoals",	Game::ScriptInitializeAllGoals},
	{"GoalManager_InitializeGoal",		Game::ScriptInitializeGoal},
	{"GoalManager_GoalInitialized",		Game::ScriptGoalInitialized},
	{"GoalManager_InitializeAllSelectedGoals", Game::ScriptInitializeAllSelectedGoals},
	{"GoalManager_InitializeAllMinigames", Game::ScriptInitializeAllMinigames},
	{"GoalManager_DeactivateAllMinigames", Game::ScriptDeactivateAllMinigames},
	{"GoalManager_DeactivateCurrentGoal", Game::ScriptDeactivateCurrentGoal},
	{"GoalManager_UpdateAllGoals",		Game::ScriptUpdateAllGoals},
	{"GoalManager_HasActiveGoals",		Game::ScriptHasActiveGoals},
	{"GoalManager_GoalIsActive",		Game::ScriptGoalIsActive},
	{"GoalManager_SetGoalTimer",		Game::ScriptSetGoalTimer},
	{"GoalManager_ZeroGoalTimer",		Game::ScriptZeroGoalTimer},
	{"GoalManager_SetGoalFlag",			Game::ScriptSetGoalFlag},
    {"GoalManager_HasSeenGoal",         Game::ScriptHasSeenGoal},
    {"GoalManager_PauseAllGoals",       Game::ScriptPauseAllGoals},
    {"GoalManager_UnPauseAllGoals",     Game::ScriptUnPauseAllGoals},
    {"GoalManager_RestartLastGoal",     Game::ScriptRestartLastGoal},
    // {"GoalManager_CreateGoalFlag",      Game::ScriptCreateGoalFlag},
    {"GoalManager_AllFlagsSet",         Game::ScriptAllFlagsSet},
	{"GoalManager_GoalFlagSet",			Game::ScriptGoalFlagSet},
    {"GoalManager_CanRetryGoal",        Game::ScriptCanRetryGoal},      
    {"GoalManager_GetGoalParams",       Game::ScriptGetGoalParams},
    {"GoalManager_CanStartGoal",        Game::ScriptCanStartGoal},
    {"GoalManager_NextHorseSpot",       Game::ScriptNextTourSpot},
	{"GoalManager_NextTourSpot",		Game::ScriptNextTourSpot},
    {"GoalManager_NextRaceWaypoint",    Game::ScriptNextRaceWaypoint},
    {"GoalManager_CreateGoalName",      Game::ScriptCreateGoalName},
	{"GoalManager_GetLevelPrefix",		Game::ScriptGetLevelPrefix},
    {"GoalManager_SetGraffitiMode",     Game::ScriptSetGraffitiMode},
    {"GoalManager_HasWonGoal",          Game::ScriptHasWonGoal},
    {"GoalManager_GotCounterObject",    Game::ScriptGotCounterObject},
    {"GoalManager_CounterGoalDone",     Game::ScriptCounterGoalDone},
	{"GoalManager_ClearGoalPoints",		Game::ScriptClearGoalPoints},
    {"GoalManager_HasGoalPoints",       Game::ScriptHasGoalPoints},
    {"GoalManager_SpendGoalPoints",     Game::ScriptSpendGoalPoints},
    {"GoalManager_GetNumberOfGoalPoints", Game::ScriptGetNumberOfGoalPoints},
    {"GoalManager_GetCash",             Game::ScriptGetCash},
    {"GoalManager_SpendCash",           Game::ScriptSpendCash},
    {"GoalManager_AddCash",             Game::ScriptAddCash},
    {"GoalManager_HasBeatenGoalWithProset", Game::ScriptHasBeatenGoalWithProset},
    {"GoalManager_GetProsetNotPrefix",  Game::ScriptGetProsetNotPrefix},
    {"GoalManager_LevelUnload",         Game::ScriptLevelUnload},
    {"GoalManager_LevelLoad",           Game::ScriptLevelLoad},
    {"GoalManager_NumGoalsBeatenInLevel",  Game::ScriptNumGoalsBeatenInLevel},
    {"GoalManager_UnlockGoal",			Game::ScriptUnlockGoal},
	{"GoalManager_UnlockAllGoals",      Game::ScriptUnlockAllGoals},
	{"GoalManager_TurnPro",				Game::ScriptTurnPro},
	{"GoalManager_CheckMinigameRecord", Game::ScriptCheckMinigameRecord},
	{"GoalManager_SetStartTime",		Game::ScriptSetStartTime},
	{"GoalManager_UpdateComboTimer", 	Game::ScriptUpdateComboTimer},
	{"GoalManager_AddMinigameTime",		Game::ScriptAddMinigameTime},
	{"GoalManager_SetStartHeight", 		Game::ScriptSetStartHeight},
	{"GoalManager_CheckHeightRecord", 	Game::ScriptCheckHeightRecord},
	{"GoalManager_CheckDistanceRecord",	Game::ScriptCheckDistanceRecord},
/*	
	{"GoalManager_ShowGoalPoints", 		Game::ScriptShowGoalPoints},
	{"GoalManager_HideGoalPoints",		Game::ScriptHideGoalPoints},
	{"GoalManager_ShowPoints",			Game::ScriptShowPoints},
	{"GoalManager_HidePoints",			Game::ScriptHidePoints},
*/
	{"GoalManager_AddGoalPoint",		Game::ScriptAddGoalPoint},
	{"GoalManager_PlayGoalStartStream", Game::ScriptPlayGoalStartStream},
	{"GoalManager_PlayGoalWinStream", 	Game::ScriptPlayGoalWinStream},
	{"GoalManager_StopCurrentStream",	Game::ScriptStopCurrentStream},
	{"GoalManager_PlayGoalWaitStream",	Game::ScriptPlayGoalWaitStream},
	{"GoalManager_PauseGoal",			Game::ScriptPauseGoal},
	{"GoalManager_UnPauseGoal",			Game::ScriptUnPauseGoal},
	{"GoalManager_PauseCompetition",	Game::ScriptPauseCompetition},
	{"GoalManager_UnPauseCompetition",	Game::ScriptUnPauseCompetition},
	{"GoalManager_UnBeatAllGoals",		Game::ScriptUnBeatAllGoals},
	{"GoalManager_AddViewGoalsList",	Game::ScriptAddViewGoalsList},
	{"GoalManager_GoalIsLocked",		Game::ScriptGoalIsLocked},
	{"GoalManager_IsInCompetition",		Game::ScriptIsInCompetition},
	{"GoalManager_GetGoalAnimations",	Game::ScriptGetGoalAnimations},
	{"GoalManager_PlayGoalStream",		Game::ScriptPlayGoalStream},
	{"GoalManager_EndRunCalled",		Game::ScriptEndRunCalled},
	{"GoalManager_ClearEndRun",			Game::ScriptClearEndRun},
	{"GoalManager_FinishedEndOfRun",	Game::ScriptFinishedEndOfRun},
	{"GoalManager_StartedEndOfRun",		Game::ScriptStartedEndOfRun},
	{"GoalManager_SetShouldDeactivateOnExpire",	Game::ScriptSetShouldDeactivateOnExpire},
	{"GoalManager_EndBetAttempt",		Game::ScriptEndBetAttempt},
	{"GoalManager_StartBetAttempt",		Game::ScriptStartBetAttempt},
	{"GoalManager_WinBet",				Game::ScriptWinBet},
	{"GoalManager_MoveBettingGuyNow",	Game::ScriptMoveBettingGuyNow},
	{"GoalManager_BetOffered",			Game::ScriptBetOffered},
	{"GoalManager_BetAccepted",			Game::ScriptBetAccepted},
	{"GoalManager_BetRefused",			Game::ScriptBetRefused},
	{"GoalManager_BetIsActive",			Game::ScriptBetIsActive},
	{"GoalManager_AddTempSpecialTrick",	Game::ScriptAddTempSpecialTrick},
	{"GoalManager_RemoveTempSpecialTrick", Game::ScriptRemoveTempSpecialTrick},
	{"GoalManager_GetTrickFromKeyCombo", Game::ScriptGetTrickFromKeyCombo},
	{"GoalManager_QuickStartGoal",		Game::ScriptQuickStartGoal},
	{"GoalManager_AddGoalChoices",		Game::ScriptAddGoalChoices},
	{"GoalManager_GoalIsSelected",		Game::ScriptGoalIsSelected},
	{"GoalManager_ToggleGoalSelection",	Game::ScriptToggleGoalSelection},
	{"GoalManager_GoalsAreSelected",	Game::ScriptGoalsAreSelected},
	{"GoalManager_AddTime",				Game::ScriptAddTime},
	{"GoalManager_ReplaceTrickText",	Game::ScriptReplaceTrickText},
	// {"GoalManager_UnlockProSpecificChallenges",	Game::ScriptUnlockProSpecificChallenges},
	// {"GoalManager_ProSpecificChallengesUnlocked", Game::ScriptProSpecificChallengesUnlocked},
	{"GoalManager_GetNumberCollected",	Game::ScriptGetNumberCollected},
	{"GoalManager_GetNumberOfFlags",	Game::ScriptGetNumberOfFlags},
	{"GoalManager_IsPro",				Game::ScriptIsPro},
	{"GoalManager_ResetGoalFlags",		Game::ScriptResetGoalFlags},
	{"GoalManager_ColorTrickObjects",	Game::ScriptColorTrickObjects},
	{"GoalManager_GetNumberOfTimesGoalStarted", Game::ScriptGetNumberOfTimesGoalStarted},
	{"GoalManager_GoalExists",			Game::ScriptGoalExists},
	{"GoalManager_GetGoalAttemptInfo",	Game::ScriptGetGoalAttemptInfo},
	{"GoalManager_SetCanStartGoal",		Game::ScriptSetCanStartGoal},
	{"GoalManager_GetLastGoalId",		Game::ScriptGetLastGoalId},
	{"GoalManager_ClearTetrisTricks",	Game::ScriptClearTetrisTricks},
	// {"GoalManager_MarkProSpecificChallengeBeaten", Game::ScriptMarkProSpecificChallengeBeaten},
	// {"GoalManager_SkaterHasBeatenProSpecificChallenge", Game::ScriptSkaterHasBeatenProSpecificChallenge},
	{"GoalManager_AnnounceGoalStarted",	Game::ScriptAnnounceGoalStarted},
	{"GoalManager_SetEndRunType",		Game::ScriptSetEndRunType},
	{"GoalManager_GetActiveGoalId",		Game::ScriptGetActiveGoalId},
	{"GoalManager_ResetCareer",			Game::ScriptResetCareer},
	{"GoalManager_AwardMinigameCash",	Game::ScriptAwardMinigameCash},
	{"GoalManager_AwardAllGoalCash",	Game::ScriptAwardAllGoalCash},
	{"GoalManager_UpdateFamilyTrees",	Game::ScriptUpdateFamilyTrees},
	{"GoalManager_IsLeafNode",			Game::ScriptIsLeafNode},
	{"GoalManager_IsRootNode",			Game::ScriptIsRootNode},
	{"GoalManager_SuspendGoalPedLogic",	Game::ScriptSuspendGoalPedLogic},
	{"GoalManager_RememberLevelStructureName", Game::ScriptRememberLevelStructureName},
	{"GoalManager_SetDifficultyLevel",	Game::ScriptSetDifficultyLevel},
	{"GoalManager_GetDifficultyLevel",	Game::ScriptGetDifficultyLevel},
	// {"GoalManager_GetGoalParam",		Game::ScriptGetGoalParam},
	{"GoalManager_RestartStage",		Game::ScriptRestartStage},
	{"GoalManager_CanRestartStage",		Game::ScriptCanRestartStage},
	{"GoalManager_SetGoalChaptersAndStages", Game::ScriptSetGoalChaptersAndStages},
	{"GoalManager_AdvanceStage", 		Game::ScriptAdvanceStage},
	{"GoalManager_GetCurrentChapterAndStage", Game::ScriptGetCurrentChapterAndStage},
	{"GoalManager_SetCurrentChapterAndStage", Game::ScriptSetCurrentChapterAndStage},
	{"GoalManager_FilmGoalCheckpoint",	Game::ScriptFilmGoalCheckpoint},
	{"GoalManager_StartFilming",		Game::ScriptStartFilming},
	{"GoalManager_GoalShouldExpire",	Game::ScriptGoalShouldExpire},
	{"GoalManager_SetSponsor",			Game::ScriptSetSponsor},
	{"GoalManager_GetSponsor",			Game::ScriptGetSponsor},
	{"GoalManager_SetTeamMember",		Game::ScriptSetTeamMember},
	{"GoalManager_KillTeamMembers",		Game::ScriptKillTeamMembers},
    {"GoalManager_SetTeamName", 		Game::ScriptSetTeamName},
	{"GoalManager_GetTeam",				Game::ScriptGetTeam},
	{"GoalManager_RunLastStageScript",	Game::ScriptRunLastStageScript},
	{"GoalManager_UnloadLastFam",		Game::ScriptUnloadLastFam},
	{"GoalManager_StopLastStream",		Game::ScriptStopLastSream},
	{"GoalManager_HideAllGoalPeds",		Game::ScriptHideAllGoalPeds},

    {"GetCreateATrickParams",	        Game::ScriptGetCreateATrickParams},
    {"GetCreateATrickOtherParams",      Game::ScriptGetCreateATrickOtherParams},
    {"SetCreateATrickParams",	        Game::ScriptSetCreateATrickParams},
    {"SetCreateATrickOtherParams",      Game::ScriptSetCreateATrickOtherParams},
    {"SetCreateATrickRotations",        Game::ScriptSetCreateATrickRotations},
    {"SetCreateATrickAnimations",       Game::ScriptSetCreateATrickAnimations},
    {"GetCreateATrickRotations",        Game::ScriptGetCreateATrickRotations},
    {"GetCreateATrickAnimations",       Game::ScriptGetCreateATrickAnimations},

    {"CAT_SetNumAnims",                 Game::ScriptCAT_SetNumAnims},
    {"CAT_GetNumAnims",                 Game::ScriptCAT_GetNumAnims},
    {"CAT_SetAnimsDone",                Game::ScriptCAT_SetAnimsDone},
    {"CAT_GetAnimsDone",                Game::ScriptCAT_GetAnimsDone},
    {"CAT_SetRotsDone",                 Game::ScriptCAT_SetRotsDone},
    {"CAT_GetRotsDone",                 Game::ScriptCAT_GetRotsDone},
    {"CAT_SetBailDone",                 Game::ScriptCAT_SetBailDone},
    {"CAT_GetBailDone",                 Game::ScriptCAT_GetBailDone},
    {"CAT_SetFlipSkater",               Game::ScriptCAT_SetFlipSkater},
    {"CAT_GetFlipSkater",               Game::ScriptCAT_GetFlipSkater},
    {"CAT_SetHoldTime",                 Game::ScriptCAT_SetHoldTime},
    {"CAT_GetHoldTime",                 Game::ScriptCAT_GetHoldTime},
    {"CAT_SetTotalX",                   Game::ScriptCAT_SetTotalX},
    {"CAT_GetTotalX",                   Game::ScriptCAT_GetTotalX},
    {"CAT_SetTotalY",                   Game::ScriptCAT_SetTotalY},
    {"CAT_GetTotalY",                   Game::ScriptCAT_GetTotalY},
    {"CAT_SetTotalZ",                   Game::ScriptCAT_SetTotalZ},
    {"CAT_GetTotalZ",                   Game::ScriptCAT_GetTotalZ},
    
    {"AddWarpPointsToMenu",             CFuncs::ScriptAddWarpPointsToMenu},
	{"RunScriptOnObject",   			CFuncs::ScriptRunScriptOnObject},
	{"RunScriptOnComponentType",		CFuncs::ScriptRunScriptOnComponentType},

	// some asset manager functions
	{"LoadAsset",						CFuncs::ScriptLoadAsset},
    {"LoadAnim",						CFuncs::ScriptLoadAnim},
    {"LoadSkeleton",					CFuncs::ScriptLoadSkeleton},
    {"UnloadAnim",						CFuncs::ScriptUnloadAnim},
	{"SetDefaultPermanent",				CFuncs::ScriptAssManSetDefaultPermanent},
	{"SetReferenceChecksum",			CFuncs::ScriptAssManSetReferenceChecksum},
    
    {"SkaterIsBraking",                 CFuncs::ScriptSkaterIsBraking},
	{"LocalSkaterExists",				CFuncs::ScriptLocalSkaterExists},
	{"DownloadMotd",					GameNet::Manager::ScriptDownloadMotd},
	{"AlreadyGotMotd",					GameNet::Manager::ScriptAlreadyGotMotd},
	{"AlreadySignedIn",					GameNet::Manager::ScriptAlreadySignedIn},
	
	{"SignOut",							GameNet::Manager::ScriptSignOut},
	{"JoinServerComplete",				GameNet::Manager::ScriptJoinServerComplete},
	{"OnXbox",							CFuncs::ScriptOnXbox },
	{"SystemLinkEnabled",				CFuncs::ScriptSystemLinkEnabled },
	{"GotoXboxDashboard",				CFuncs::ScriptGotoXboxDashboard },

	{"CreateParticleSystem",			CFuncs::ScriptCreateParticleSystem },
	{"SetScript",						CFuncs::ScriptSetScript },
	{"DestroyParticleSystem",			CFuncs::ScriptDestroyParticleSystem },
	{"EmptyParticleSystem",				CFuncs::ScriptEmptyParticleSystem },
	{"ParticleExists",					CFuncs::ScriptParticleExists },

	{"WeatherUpdateGrid",				Nx::CEngine::ScriptWeatherUpdateGrid },
	{"WeatherSetRainHeight",			Nx::CEngine::ScriptWeatherSetRainHeight },
	{"WeatherSetRainFrames",			Nx::CEngine::ScriptWeatherSetRainFrames },
	{"WeatherSetRainLength",			Nx::CEngine::ScriptWeatherSetRainLength },
	{"WeatherSetRainBlendMode",			Nx::CEngine::ScriptWeatherSetRainBlendMode },
	{"WeatherSetRainRate",				Nx::CEngine::ScriptWeatherSetRainRate },
    {"WeatherSetRainColor",				Nx::CEngine::ScriptWeatherSetRainColor},

	{"WeatherSetSplashRate",			Nx::CEngine::ScriptWeatherSetSplashRate },
	{"WeatherSetSplashLife",			Nx::CEngine::ScriptWeatherSetSplashLife },
	{"WeatherSetSplashSize",			Nx::CEngine::ScriptWeatherSetSplashSize },
	{"WeatherSetSplashColor",			Nx::CEngine::ScriptWeatherSetSplashColor },
	{"WeatherSetSplashBlendMode",		Nx::CEngine::ScriptWeatherSetSplashBlendMode },

	{"WeatherSetSnowHeight",			Nx::CEngine::ScriptWeatherSetSnowHeight },
	{"WeatherSetSnowFrames",			Nx::CEngine::ScriptWeatherSetSnowFrames },
	{"WeatherSetSnowSize",				Nx::CEngine::ScriptWeatherSetSnowSize },
	{"WeatherSetSnowBlendMode",			Nx::CEngine::ScriptWeatherSetSnowBlendMode },
	{"WeatherSetSnowRate",				Nx::CEngine::ScriptWeatherSetSnowRate },
    {"WeatherSetSnowColor",				Nx::CEngine::ScriptWeatherSetSnowColor},

    {"WeatherSetSnowActive",			Nx::CEngine::ScriptWeatherSetSnowActive},
    {"WeatherSetRainActive",			Nx::CEngine::ScriptWeatherSetRainActive},

	{"StructureContains",				CFuncs::ScriptStructureContains},
	{"GetBonePosition",					CFuncs::ScriptGetBonePosition},
	{"ShouldEmitParticles",				CFuncs::ScriptShouldEmitParticles},
	{"ParticlesOn",						CFuncs::ScriptParticlesOn},
	{"ParticlesOff",					CFuncs::ScriptParticlesOff},
	{"MangleChecksums",					CFuncs::ScriptMangleChecksums},
	{"AppendSuffixToChecksum",			CFuncs::ScriptAppendSuffixToChecksum},
	
	{"RotateVector",					CFuncs::ScriptRotateVector},

	{"IsPS2",							CFuncs::ScriptIsPS2},
	{"IsNGC",							CFuncs::ScriptIsNGC},
	{"IsXBOX",							CFuncs::ScriptIsXBOX},
	{"IsWIN32",							CFuncs::ScriptIsWIN32},
	{"GetPlatform",						CFuncs::ScriptGetPlatform},
	{"IsPal",							CFuncs::ScriptIsPal},

	{"PrintSkaterStats",				CFuncs::ScriptPrintSkaterStats},
    {"PrintSkaterStats2",				CFuncs::ScriptPrintSkaterStats2},
	{"PrintSkaterPosition",				CFuncs::ScriptPrintSkaterPosition},
	{"GetSkaterID",						CFuncs::ScriptGetSkaterID},
	{"GetCurrentSkaterID",				CFuncs::ScriptGetCurrentSkaterID},
	{"GetViewerObjectID",				CFuncs::ScriptGetViewerObjectID},
	
	{"PushMemProfile",					CFuncs::ScriptPushMemProfile},
	{"PopMemProfile",					CFuncs::ScriptPopMemProfile},
	{"TogglePass",						CFuncs::ScriptTogglePass},
	
	{"GetStatValue",					CFuncs::ScriptGetStatValue},
	{"GetNumStatPointsAvailable",		CFuncs::ScriptGetNumStatPointsAvailable},
	{"UnlockSkater",					CFuncs::ScriptUnlockSkater},
	{"SetSkaterProfileInfo",			CFuncs::ScriptSetSkaterProfileInfo},
	{"GetSkaterProfileInfo",			CFuncs::ScriptGetSkaterProfileInfo},
	{"GetSkaterProfileInfoByName",		CFuncs::ScriptGetSkaterProfileInfoByName},
	{"SetSkaterProfileProperty",		CFuncs::ScriptSetSkaterProfileProperty},
	{"SetSkaterProfileInfoByName",		CFuncs::ScriptSetSkaterProfileInfoByName},
	{"SetScreen",						CFuncs::ScriptSetScreen},

	{"GetUpperCaseString",				CFuncs::ScriptGetUpperCaseString},

	{"GetGameMode",						CFuncs::ScriptGetGameMode},
	{"StartKeyboardHandler",			CFuncs::ScriptStartKeyboardHandler},
	{"StopKeyboardHandler",				CFuncs::ScriptStopKeyboardHandler},
	{"EnableKeyboard",					CFuncs::ScriptEnableKeyboard},
	{"DisableKeyboard",					CFuncs::ScriptDisableKeyboard},
	
	{"GetRescaledTargetValue",			CFuncs::ScriptGetRescaledTargetValue},
	{"MemInitHeap",						CFuncs::ScriptMemInitHeap},
	{"MemDeleteHeap",					CFuncs::ScriptMemDeleteHeap},
	{"ClearStruct",						CFuncs::ScriptClearStruct},
	{"AppendStruct",					CFuncs::ScriptAppendStruct},
	{"ScriptExists",					CFuncs::ScriptScriptExists},
	{"GetPlayerAppearancePart",			CFuncs::ScriptGetPlayerAppearancePart},
	{"GetActualCASOptionStruct",		CFuncs::ScriptGetActualCASOptionStruct},
	{"GetActualPlayerAppearancePart",	CFuncs::ScriptGetActualPlayerAppearancePart},
	{"SetPlayerAppearanceColor",		CFuncs::ScriptSetPlayerAppearanceColor},
	{"SetPlayerAppearanceScale",		CFuncs::ScriptSetPlayerAppearanceScale},
	{"SetPlayerAppearanceUV",			CFuncs::ScriptSetPlayerAppearanceUV},
	{"FlushDeadObjects",				CFuncs::ScriptFlushDeadObjects},

	{"BindTrickToKeyCombo",				CFuncs::ScriptBindTrickToKeyCombo},
	{"GetKeyComboBoundToTrick",			CFuncs::ScriptGetKeyComboBoundToTrick},
	{"UpdateTrickMappings",				CFuncs::ScriptUpdateTrickMappings},
	{"GetConfigurableTricksFromType",	CFuncs::ScriptGetConfigurableTricksFromType},
	{"GetTrickDisplayText",				CFuncs::ScriptGetTrickDisplayText},
	{"GetSpecialTrickInfo",				CFuncs::ScriptGetSpecialTrickInfo},
	{"GetTrickType",					CFuncs::ScriptGetTrickType},
	{"TrickIsLocked",					CFuncs::ScriptTrickIsLocked},

	{"SpawnSecondControllerCheck",		CFuncs::ScriptSpawnSecondControllerCheck},
	{"StopSecondControllerCheck",		CFuncs::ScriptStopSecondControllerCheck},

	{"GetIndexOfItemContaining",		CFuncs::ScriptGetIndexOfItemContaining},
	{"ForEachSkaterName",				CFuncs::ScriptForEachSkaterName},
	{"ForEachSkaterProfile",			CFuncs::ScriptForEachSkaterProfile},
	{"ResetAllToDefaultStats",			CFuncs::ScriptResetAllToDefaultStats},
	{"ResetAllToDefaultProfile",		CFuncs::ScriptResetAllToDefaultProfile},
	{"ResetToDefaultProfile",			CFuncs::ScriptResetToDefaultProfile},
	{"GetLevelRecords",					CFuncs::ScriptGetLevelRecords},

	{"ResetComboRecords",				CFuncs::ScriptResetComboRecords},

	{"IsArray",							CFuncs::ScriptIsArray},

	{"GetNumberOfTrickOccurrences",		CFuncs::ScriptGetNumberOfTrickOccurrences},

	{"GetNumSoundtracks",				CFuncs::ScriptGetNumSoundtracks},
	{"GetSoundtrackName",				CFuncs::ScriptGetSoundtrackName},
	{"UseUserSoundtrack",				CFuncs::ScriptUseUserSoundtrack},
	{"UseStandardSoundtrack",			CFuncs::ScriptUseStandardSoundtrack},
	
	{"DisableReset",					CFuncs::ScriptDisableReset},
	{"EnableReset",						CFuncs::ScriptEnableReset},
	{"ResetToIPL",						CFuncs::ScriptResetToIPL},

	{"BindControllerToSkater",			CFuncs::ScriptBindControllerToSkater},
	{"BindFrontEndToController",		CFuncs::ScriptBindFrontEndToController},
	{"ControllerBoundToDifferentSkater",CFuncs::ScriptControllerBoundToDifferentSkater},
	{"ControllerBoundToSkater",			CFuncs::ScriptControllerBoundToSkater},

	{"GetKeyComboArrayFromTrickArray",	CFuncs::ScriptGetKeyComboArrayFromTrickArray},
	{"InitAnimCompressTable",			CFuncs::ScriptInitAnimCompressTable},

	{"FirstInputReceived",				CFuncs::ScriptFirstInputReceived},
	{"LockCurrentSkaterProfileIndex",	CFuncs::ScriptLockCurrentSkaterProfileIndex},

	{"SetSpecialTrickInfo",				CFuncs::ScriptSetSpecialTrickInfo},
    {"GetSkaterPosition",				CFuncs::ScriptGetSkaterPosition},
	{"GetSkaterVelocity",				CFuncs::ScriptGetSkaterVelocity},
	{"InterpolateParameters",			CFuncs::ScriptInterpolateParameters},
	{"GetLightCurrentColor",			Nx::ScriptGetLightCurrentColor},
    {"DrawDirectionalLightLines",		Nx::ScriptDrawDirectionalLightLines},

    {"CreateCompositeObject",			CFuncs::ScriptCreateCompositeObject},
	
	{"AutoRail",						CFuncs::ScriptAutoRail},
	
    {"Inside",           				CFuncs::ScriptInside},

    {"SetSpecialBarColors",           	CFuncs::ScriptSetSpecialBarColors},
	{"GetMetrics",						CFuncs::ScriptGetMetrics},
	{"MoveNode",						CFuncs::ScriptMoveNode},
	{"SetActiveCamera",					CFuncs::ScriptSetActiveCamera},

    {"Sin",                           	CFuncs::ScriptSin},
    {"Cos",                           	CFuncs::ScriptCos},
    {"Tan",                           	CFuncs::ScriptTan},
    {"ASin",                           	CFuncs::ScriptASin},
    {"ACos",                           	CFuncs::ScriptACos},
    {"ATan",                           	CFuncs::ScriptATan},
	
	{"ShowTracking",					CFuncs::ScriptShowTracking},
	
	{"IsGrind",							CFuncs::ScriptIsGrind},
	{"ShowCamOffset",					CFuncs::ScriptShowCamOffset},
	
	{"PlaySkaterStream",				CFuncs::ScriptPlaySkaterStream},

    {"GetTextureFromPath",              CFuncs::ScriptGetTextureFromPath},
    {"GetVramUsage",              CFuncs::ScriptGetVramUsage},
	{"CompositeObjectExists",			CFuncs::ScriptCompositeObjectExists},	
	
	{"DoNextTrick",					Obj::ScriptDoNextTrick},

	{"AllocatePathManMemory",		Obj::ScriptAllocatePathManMemory},


	{"AddSkaterEarly",					CFuncs::ScriptAddSkaterEarly},

	{"PreLoadStreamDone",				CFuncs::ScriptPreLoadStreamDone},
	{"StartPreLoadedStream",			CFuncs::ScriptStartPreLoadedStream},
	{"FinishRendering",					CFuncs::ScriptFinishRendering},

// Gamecube-specific message functions.
#ifdef __PLAT_NGC__
	{"Ngc_BGColor", 					Nx::ScriptNgc_BGColor},
	{"Ngc_Message", 					Nx::ScriptNgc_Message},
	{"Ngc_Menu", 						Nx::ScriptNgc_Menu},
	{"Ngc_Set480P",						Nx::ScriptNgc_Set480P},
	{"Ngc_Set480I",						Nx::ScriptNgc_Set480I},
	{"Ngc_SetWide",						Nx::ScriptNgc_SetWide},
	{"Ngc_SetStandard",					Nx::ScriptNgc_SetStandard},
	{"Ngc_ReduceColors",				Nx::ScriptNgc_ReduceColors},
	{"Ngc_Set60hz",						Nx::ScriptNgc_Set60Hz},
	{"Ngc_Set50hz",						Nx::ScriptNgc_Set50Hz},
#endif		// __PLAT_NGC__
};

// A list of all the member function names accessible from scripts.
// The name in quotes must be the same as the way it appears in q scripts. (case insensitive)
const char *ppMemberFunctionNames[]=
{
	// used by the asset manager (AssMan)	
    "AnimLoaded",
    "AssetLoaded",

	// used by Gfx::Camera
	"ChangeCameraFOV",

	// used by Obj::CMovieCamera
	"SetTargetObject",
	"ClearTargetObject",
	 
	// used by Gfx::CModelAppearance
	"SetPart",
	"GetPart",
	"ClearPart",
	"SetChecksum",
	"PartGotFlag",
	"GotPart",
	
	// used by Gfx::CModelBuilder
	"GeomModulateColor",
	"GeomSetUVOffset",
	"GeomAllocateUVMatrixParams",
	"GeomReplaceTexture",
	"ModelAddGeom",
	"ModelHideGeom",
	"ModelRemovePolys",
	"ModelFinalize",
    "ModelResetScale",
    "ModelApplyBoneScale",
    "ModelApplyBodyShape",
    "ModelApplyObjectScale",
	"ModelApplyFaceTexture",
	"ModelRunScript",
	"ModelClearGeom",
	"ModelClearAllGeoms",
	"DebugPrintAppearance",
	"AppearanceAllowScalingCheat",

	// used by Obj::CSkater
	"GetStat",
	"GetScriptedStat",
	"SetCustomRestart",
	"SkipToCustomRestart",
	"PausePhysics",
	"UnPausePhysics",
	"SetDriving",
	"UnsetDriving",
	"GetTimeSincePhysicsSwitch",
	"GetPreviousPhysicsStateDuration",
	"DumpEventBuffer",
	"AnimEquals",
	"PlayAnim",
	"BlendPeriodOut",
	"LoopingAnim",
	"AnimFinished",
	"LeftPressed",
	"RightPressed",
	"UpPressed",
	"DownPressed",
	"Jump",
	"Flipped",
	"Switched",
	"Crouched",
	"OnGround",
	"InAir",
	"OnWall",
	"OnLip",
	"OnRail",
	"InWallplant",
	"FirstTimeOnThisRail",
	"InBail",
	"NotInBail",
	"IsInBail",
	"PlayBonkSound",
	"PlayCessSound",
	"PlayLandSound",
	"PlayJumpSound",
	"SpeedLessThan",
	"SpeedGreaterThan",
	"SpeedEquals",
	"Braking",
	"CanBrakeOff",
	"CanBrakeOn",
	"CanKick",
	"CanKickOn",
	"CanKickOff",
	"ForceAutokickOn",
	"ForceAutokickOff",
	"RestoreAutokick",
	"AutoKickIsOff",
	"DoCarPlantBoost",
	"GetAnimLength",
    "Obj_GetAnimSpeed",
	"WaitAnim",
	"FrameIs",
	"BashOn",
	"BashOff",
	"SetTrickName",
	"SetTrickScore",
	"GetSpin",
	"Display",
	"HandleLipOllieDirection",
	"EnableDisplayFlip",
	"DisableDisplayFlip",
	"Flip",
	"ResetSwitched",
	"GetHeading",
	"Rotate",
	"RotateDisplay",
	"CancelRotateDisplay",
	"BoardRotate",
	"NoSpin",
	"CanSpin",
	"Move",
	"Hide",
	"Unhide",
	"IsHidden",
	"Suspend",
	"Unsuspend",
	"Pause",
	"Unpause",
	"SetSpeed",
	"GetSpeed",
	"OrientToNormal",
	"Held",
	"Released",
	"HeldLongerThan",
	"EnableInputEvents",
	"DisableInputEvents",
	"HasPowerup",
	"PickedUpPowerup",
	
//	"DoNextTrick",
	"ClearTricksFrom",
	"SetQueueTricks",
	"ClearTrickQueue",
	"AddTricksToQueue",
	"UseGrindEvents",
	"DoNextManualTrick",
	"SetManualTricks",
	"ClearManualTrick",
	"SetExtraGrindTricks",
	"ClearExtraGrindTrick",
	"AirTimeLessThan",
	"AirTimeGreaterThan",
	"GetAirTime",
	"GetAirTimeLeft",
	"GetSlope",
	"backwards",
	"ClearPanel_Landed",
	"ClearPanel_Bailed",
	"FlipAfter",
	"RotateAfter",
	"BoardRotateAfter",
	"IsFlipAfterSet",
	"TriggerType",
	"KillSkater",
	"FlipAndRotate",
	"DoBalanceTrick",
	"StopBalanceTrick",
	"SwitchOffBalanceMeter",
	"SwitchOnBalanceMeter",
	"StartBalanceTrick",
	"StartSkitch",
	"StopSkitch",
	"Skitching",
	"SetState",
	"ClearEventBuffer",
	"Input_Debounce",
	"DisablePlayerInput",
	"NetDisablePlayerInput",
	"EnablePlayerInput",
	"NetEnablePlayerInput",
	"PlayerInputIsDisabled",
	"StartGap",
	"EndGap",
	"StartGapTrick",
	"CheckGapTricks",
	"ClearGapTricks",
	"GotSpecial",
	"SetRailSound",
	"LockVelocityDirection",
	"SetRollingFriction",
	"SetSpecialFriction",
	"InNollie",
	"NollieOn",
	"NollieOff",
	"InPressure",
	"PressureOn",
	"PressureOff",
    "RunStarted",
	"EndOfRunDone",
	"EndOfRunStarted",
	"Goal_EndOfRunDone",
	"Goal_EndOfRunStarted",
	"IsInEndOfRun",
	"DuplicateTrigger",
	"SparksOn",
	"SparksOff",
	"Vibrate",
	"DoingTrick",
	"GetTerrain",
	"BailOn",
	"BailOff",
	"BailIsOn",
    "FrontTruckSparks",
	"SetFrontTruckSparks",
	"SetRearTruckSparks",
	
	"RemoveXEvents",
	"RestoreEvents",
	"YawBetween",
	"PitchGreaterThan",
	"AbsolutePitchGreaterThan",
	"RollGreaterThan",
	"YawingLeft",
	"YawingRight",
	// "PitchingForward",
	// "PitchingBackward",
	// "RollingLeft",
	// "RollingRight",
	"TextureSplat",
	"Skeleton_SpawnTextureSplat",
	"Skeleton_SpawnCompositeObject",
	"TweakTrick",
	"IsLatestTrick",
	"SetGrindTweak",
	"Ledge",
	"BadLedge",
	"SkateInAble",
	"ResetSpin",
	"LastSpinWas",
	"LandedFromSpine",
	"LandedFromVert",
	"SetLandedFromVert",
	"ResetLandedFromVert",
	"InVertAir",
	"AllowLipNoGrind",
	"ClearAllowLipNoGrind",
	"NoRailTricks",
	"AllowRailTricks",
	"SetExtraTricks",
	"KillExtraTricks",
	"TurnToFaceVelocity",
	"SC_SetSkaterCamOverride",
	"SC_ClearSkaterCamOverride",
	"SC_ShakeCamera",
	"SC_SetMode",
	"SetExtraPush",
	"GetMatrixNormal",
	"GetLastGroundPos",
	"ShouldMongo",
	"SetSlotTrick",
	"ChangeProTricks",
	"TrickOffObject",
	"AdjustBalance",
	"IsLocalSkater",
	"SkaterIsNamed",
	"GetCameraId",
	"AddSkaterToWorld",
	"ResetRigidBodyCollisionRadiusBoost",
	"RemoveSkaterFromWorld",
	"OverrideLimits",
	"CreateSpecialItem",
	"DestroySpecialItem",
	"DestroyAllSpecialItems",
	"SpecialItemExists",
	"OverrideCancelGround",
	"BoardIsRotated",
	"GetSkaterNumber",
	"LastScoreLandedGreaterThan",
	"LastScoreLandedLessThan",
	"TotalScoreGreaterThan",
	"TotalScoreLessThan",
	"GetTotalScore",
	"CurrentScorePotGreaterThan",
	"CurrentScorePotLessThan",
	"GetNumberOfNonGapTricks",
	"PlaceBeforeCamera",
	"CancelWallpush",
	
	// used by Obj::CCompositeObject
	"Obj_PrintDetails",
	"CreateComponentFromStructure",

	// used by Obj::CMovingObject
	"Obj_PlayStream",
	"Obj_StopStream",
	"FollowWaypointPath",
	"LookAtNode",
//	"Obj_WaitForStreamAvailable",
//	"Obj_WaitForStreamToStart",
//	"Obj_WaitStreamFinished",
	"Obj_ShadowOn",
	"Obj_ShadowOff",
	// objects would require an animated model to run these functions:
//	"RunAnim",
//	"CycleAnim",
	"Obj_WaitRotate",
	"Obj_WaitAnimFinished",
	"AnimExists",
	"Obj_WaitMove",
	"Obj_WaitStop",
	// wait functions:
	// other functions:
	"Obj_StopMoving",
	"Obj_StopRotating",
	"Obj_PlaySound",
	"Obj_AdjustSound",
	"Obj_StopSound",
	"Obj_SetSound", // tell a car, for example, which sound to use for engine loop.
	"Obj_Rotate",
	"Obj_RotX",
	"Obj_RotY",
	"Obj_RotZ",
	"Obj_Hover",
	"Obj_StorePos",
	"Obj_StoreNode",
	"Obj_LookAtNodeStored",
	"Obj_LookAtNodeLinked",
	"Obj_LookAtPosStored",
//	"Obj_MoveToNodeStored",
	"Obj_MoveToPosStored",
	"Obj_RandomPathMode",
	"Obj_FollowPathStored",
	"Obj_LookAtNode",
	"Obj_LookAtPos",
	"Obj_LookAtRelPos",
	"Obj_LookAtObject",
	"Obj_AngleToNearestSkaterGreaterThan",
	"Obj_MoveToLink",
	"Obj_GetRandomLink",
	"Obj_MoveToNode",
	"Obj_MoveToPos",
	"Obj_MoveToRelPos",
	"Obj_MoveForward",
	"Obj_MoveLeft",
	"Obj_IsMoving",
	"Obj_IsRotating",
	"Obj_SetConstantHeight",
	"Obj_FollowPath",
	"Obj_FollowPathLinked",
	"Obj_FollowLeader",
	"Obj_LockToObject",
	"Obj_GetSpeed",
	"Obj_GetNextObjOnPath",
	"Obj_SetPathVelocity",
	"Obj_SetPathAcceleration",
	"Obj_SetPathDeceleration",
	"Obj_SetPathMinStopVel",
	"Obj_StopAlongPath",
	"Obj_StartAlongPath",
	"Obj_SetPathTurnDist",
	"Obj_SetGroundOffset",
	"Obj_PlayAnim",
	"Obj_EnableAnimBlending",
	"Obj_SetAnimCycleMode",
	"Obj_AnimEquals",
	"Obj_StickToGround",
	"Obj_PathHeading",
	"Obj_AnimComplete",
	"Obj_AllowSkitching",
	"Obj_GetOrientation",
	"Obj_ReplaceTexture",
	"Obj_ReplaceSpriteTexture",
	"Obj_SetBodyShape",
	"Obj_SetBoneActive",
	"Obj_GetBonePosition",
	"SwitchOnAtomic",
	"SwitchOffAtomic",
    "AtomicIsHidden",
	"Obj_ClearGeoms",
	"Obj_InitModel",
	"Obj_InitModelFromProfile",
	"Obj_HasModelLights",
	"Obj_UpdateBrightness",
	"Obj_EnableAmbientLight",
	"Obj_EnableDiffuseLight",
	"Obj_DisableAmbientLight",
	"Obj_DisableDiffuseLight",
	"Obj_SetLightAmbientColor",
	"Obj_SetLightDirection",
	"Obj_SetLightDiffuseColor",
	"Obj_SetUVOffset",
	"Obj_SetUVParams",
	"Obj_SetBoundingSphere",
	"Obj_RestoreBoundingSphere",
	"Obj_SkipToRestart",

	// procedural bone anim functions
	"SetBoneTransActive",
	"SetBoneTransMin",
	"SetBoneTransMax",
	"SetBoneTransSpeed",
	"SetBoneTransCurrent",
	"SetBoneRotActive",
	"SetBoneRotMin",
	"SetBoneRotMax",
	"SetBoneRotSpeed",
	"SetBoneRotCurrent",
	"SetBoneScaleActive",
	"SetBoneScaleMin",
	"SetBoneScaleMax",
	"SetBoneScaleSpeed",
	"SetBoneScaleCurrent",
	"AddAnimController",
	"RemoveAnimController",
	"GetPartialAnimParams",
	"SetPartialAnimSpeed"
	"IncrementPartialAnimTime",
	"ReversePartialAnimDirection",
	"SetWobbleDetails",
	"Obj_Flip",
	"Obj_AnimationFlipped",

	// can be used by any Obj::CMovingObject
	"Obj_GetId",
	"Die",
	"DisassociateFromObject",
	"Obj_SetInnerRadius", // inner radius for player 'collision'
	"Obj_SetOuterRadius", // outer radius for player 'collision'
	"Obj_SetInnerAvoidRadius", // inner radius for player avoidance logic
	"Obj_SetOuterAvoidRadius", // outer radius for player avoidance logic
	"Obj_FlagSet",
	"Obj_FlagNotSet",
	"Obj_SetFlag",
	"Obj_ClearFlag",
	"Obj_SpawnScript",
	"Obj_KillSpawnedScript",
	"Obj_SwitchScript",
	"Obj_Visible",
	"Obj_Invisible",
	"Obj_ObjectInRadius",
	"Obj_ObjectInRect",
	"Obj_ObjectNotInRect",
	
	// "Obj_VarGet",
	// "Obj_VarSet",
	// "Obj_VarPrintf",
	// "Obj_VarPrint",
	// "Obj_VarInc",
	// "Obj_VarDec",
	// "Obj_VarLT",
	// "Obj_VarGT",
	// "Obj_VarEQ",
	
	"Obj_GetCollision",
	"Obj_GetDistToNode",
	"Obj_ApplyScaling",
	"Obj_EnableScaling",
	"Obj_DisableScaling",
	"Obj_SetColor",
	"Obj_ClearColor",
	"Obj_Jump",
	"Obj_WaitJumpFinished",
	"Obj_GetDistanceToObject",
	"Obj_GetOrientationToObject",
	"Obj_GetPosition",
	"Obj_SetPosition",
	"Obj_SetOrientation",
	"Obj_ForceUpdate",
	"Obj_GetVelocity",
	
	// Car member functions:
	"EnableCarShadow",
	 
	// Ped member functions:
	"Ped_SelectAvoidPoint",
	"Ped_MoveTowardsAvoidPoint",
	"Ped_AvoidPointReached",
	"Ped_RememberNextWaypoint",
	"Ped_RememberCurrentPosition",
	"Ped_RememberStickToGround",
	"Ped_RestoreStickToGround",
	"Ped_BackOnOriginalPath",

	// Bouncy obj member functions:
	"BouncyObj_PlayerCollisionOn",
	"BouncyObj_PlayerCollisionOff",
	"BouncyObj_Go",
	"MoveToRandomRestart",

	// CRigidBodyComponent member functions:
	"RigidBody_IgnoreSkater",
	"RigidBody_Wake",
	"RigidBody_Sleep",
	"RigidBody_Kick",
	"RigidBody_Reset",
	"RigidBody_DisablePlayerCollision",
	"RigidBody_EnablePlayerCollision",
	"RigidBody_MatchVelocityTo",
	
	// CRibbonComponent member functions:
	// "Ribbon_Reset",
	
	// CVehicleComponent member functions:
	"Vehicle_Kick",
	"Vehicle_Wake",
	"Vehicle_MoveToRestart",
	"Vehicle_PlaceBeforeCamera",
	"Vehicle_AdjustGravity",
	// "Vehicle_ForceBrake",
	"Vehicle_HandbrakeActive",
	"Vehicle_AllWheelsAreInContact",
	"Vehicle_LostCollision",
	"Vehicle_IsSkaterVisible",
	
	// CVehicleCameraComponent member functions:
	"VehicleCamera_Reset",
	




	// CSkaterPhysicsControlComponent member functions:
	"Walking",
	"Skating",
	"Driving",
	"SkaterPhysicsControl_SwitchSkatingToWalking",
	"SkaterPhysicsControl_SwitchWalkingToSkating",
	"SetBoardMissing",
	"UnsetBoardMissing",
	"IsBoardMissing",
	
	
	// CSkaterLoopingSoundComponent member functions:
	"SkaterLoopingSound_TurnOn",
	"SkaterLoopingSound_TurnOff",
	
	// CWalkComponent member functions:
	"Walk_Jump",
	"Walk_ScaleAnimSpeed",
	"Walk_Ground",
	"Walk_Air",
	"Walk_Hang",
	"Walk_Ladder",
	"Walk_AnimWait",
	"Walk_GetStateTime",
	"Walk_SetDragFactor",
	"Walk_ResetDragFactor",
	"Walk_AnimWaitComplete",
	"Walk_GetSpeedScale",
    "Walk_GetHangInitAnimType",
	"Walk_GetStateDuration",
	"Walk_GetPreviousState",
	"Walk_GetState",
	"Walk_GetHangAngle",
	
	// "Walk_CancelTransitionalMomentum",
	// "Walk_SuppressInAirControl",
	
	// CWalkCameraComponent member functions:
	"WalkCamera_FlushRequest",
	"WalkCamera_Reset",
	
	// CSkaterRunTimerComponent member functions:
	"RunTimer_Pause",
	"RunTimer_UnPause",
	"RunTimer_GetFactorComplete",
	"RunTimer_GetRunTimerControllerId",
	"RunTimer_GetRunTimerId",
	
#	ifdef TESTING_GUNSLINGER
	// CHorseComponent member functions:
	"Horse_GetSpeedScale",
	"Horse_Jump",
#	endif

	// CScreenElement functions:
	"SetProps",
	"DoMorph",
	"GetProps",
	
	// CObject functions:
//	"ClearEventHandler",
//	"ClearEventHandlerGroup",
	"SetTags",
	"GetTags",

	// Particle system functions.
	"SetPos",
	"SetSpeedRange",
	"SetEmitRange",
	"SetAngleSpread",
	"SetRandomAngle",
	"SetCircularEmit",
	"SetForce",
	"SetParticleSize",
	"SetLife",
	"SetEmitTarget",
	"SetColor",
	"BuildPath",
	"EmptySystem",
	
	"Emit",
	"EmitRate",

    // StatsManagerComponent fuctions
    "StatsManager_ActivateGoals",
    "StatsManager_DeactivateGoals",
    "StatsManager_GetGoalStatus",
    "StatsManager_ReInit",
    "StatsManager_Reset",
    "StatsManager_UnlockAmGoals",
    "StatsManager_UnlockProGoals",

	// PedLogicComponent functions
	"Ped_InitPath",
	"Ped_SetLogicState",
	"Ped_StartMoving",
	"Ped_StopMoving",
	"Ped_IsMoving",
	"Ped_SetStickToGroundDist",
	"Ped_SetIsGrinding",
	"Ped_Bail",
	"Ped_SetIsBailing",
	"Ped_GetCurrentVelocity",
	"Ped_StoreMaxVelocity",
	"Ped_GetOriginalMaxVelocity",
	"Ped_InitVertTrick",
	"Ped_HitWaypoint",
	"Ped_SetIsSkater",
	"Ped_NearVertNode",
	"Ped_PlayJumpSound",
	"Ped_PlayLandSound",
	"Ped_GetCurrentNodeNames",
	
	"FlagGoalAsWon",
	"FindUnfinishedGoal",
	"GoalExists",
	"NewEditorGoal",
	"RemovedCreatedGoal",
	"GoalHasAllPositionsSet",
	"SetCurrentEditorGoal",
	"SetEditorGoalType",
	"SetEditorGoalDescription",
	"SetEditorGoalWinMessage",
	"GetEditedGoalsInfo",
	"GetNumEditedGoals",
	"GetCurrentEditedGoalId",
	"WriteEditedGoalNodePositions",
	"AddEditedGoalToGoalManager",
	"GetCurrentEditedGoalInfo",
	"SetEditorGoalName",
	"SetEditorPedName",
	"MaxEditedGoalsReached",	
	"EditGoal",
	"NukeAllGoals",
	"GetMaxGoalsPerLevel",
	"SetGoalScore",
	"SetGoalTimeLimit",
	"SetGoalControlType",
	"RefreshGoalCursorPosition",
	"SetGoalSpecificParams",
	"RemoveGoalSpecificFlag",
	"AddKeyComboSet",
	"GetKeyComboSet",
	"RemoveKeyComboSet",
	"EditedGoalAddGap",
	"EditedGoalRemoveGap",
	"EditedGoalGotGap",
	"EditorCam_Initialise",
	"EditorCam_SetCursorPos",
	"EditorCam_SetOnlyVerticalCollisionChecks",

	// Rail editor component member functions
	"GetCursorPosition",
	"NewRail",
	"MaxRailsReached",
	"AddNewPosition",
	"ClearRailEditor",
	"SetEditingMode",
	"GetEditingMode",
	"DrawDottedLine",
	"DeleteDottedLine",
	"UpdateRailPointPosition",
	"HighlightRailPoint",
	"UnHighlightAllRails",
	"DeleteRailPoint",
	"GetEditedRailInfo",
	"DeleteRail",
	"DestroyEditedRailSectors",
	
	"SetStartPos",
	"SetMidPos",
	"SetEndPos",
	"SetStartBoxDimensions",
	"SetMidBoxDimensions",
	"SetEndBoxDimensions",
	"SetUpdateScript",
	"SetEmitRate",
	"SetLifetime",
	"SetMidPointPct",
	"SetMidpointColorPct",
	"SetStartRadius",
	"SetMidRadius",
	"SetEndRadius",
	"SetStartColor",
	"SetMidColor",
	"SetEndColor",
    
};

/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/

/*****************************************************************************
**							   Private Functions							**
*****************************************************************************/

/*****************************************************************************
**							   Public Functions								**
*****************************************************************************/

int GetCFunctionLookupTableSize()
{
    return (sizeof(CFunctionLookupTable)/sizeof(SCFunction));
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

int GetNumMemberFunctions()
{
    return (sizeof(ppMemberFunctionNames)/sizeof(const char *));
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

} // namespace Script

