/*****************************************************************************
**																			**
**			              Neversoft Entertainment			                **
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		GEL (Game Engine Library)								**
**																			**
**	Module:			Module (MDL)		 									**
**																			**
**	File name:		module.cpp												**
**																			**
**	Created:		05/27/99	-	mjb										**
**																			**
**	Description:	Module code												**
**																			**
*****************************************************************************/


/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/

#include <core/defines.h>

#include <gel/module.h>

/*****************************************************************************
**								DBG Information								**
*****************************************************************************/



namespace Mdl
{



/*****************************************************************************
**								  Externals									**
*****************************************************************************/


/*****************************************************************************
**								   Defines									**
*****************************************************************************/


/*****************************************************************************
**								Private Types								**
*****************************************************************************/


/*****************************************************************************
**								 Private Data								**
*****************************************************************************/


/*****************************************************************************
**								 Public Data								**
*****************************************************************************/


/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/


/*****************************************************************************
**							   Private Functions							**
*****************************************************************************/


/*****************************************************************************
**							   Public Functions								**
*****************************************************************************/

Module::Module ( void )
{
	

	state = vSTOPPED;
	locked = false;

	node = new Lst::Node< Module > ( this );
	Dbg_AssertType( node, Lst::Node< Module > );
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

Module::~Module ()
{
	

	Dbg_AssertType( node, Lst::Node< Module > );
	delete node;
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

} // namespace Mdl


