/*****************************************************************************
**																			**
**					   	  Neversoft Entertainment							**
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		Core Library											**
**																			**
**	Module:			Crc (CRC)												**
**																			**
**	Created:		03/05/01	spg											**
**																			**
**	File name:		core/crc.h												**
**																			**
**	Description:	Crc Functionality										**
**																			**
*****************************************************************************/

#ifndef __CORE_CRC_H
#define __CORE_CRC_H

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/

#ifndef __CORE_DEFINES_H
    #include <core/defines.h>
#endif

/*****************************************************************************
**								   Defines									**
*****************************************************************************/

namespace Crc
{

/*****************************************************************************
**							Class Definitions								**
*****************************************************************************/

/*****************************************************************************
**							 Private Declarations							**
*****************************************************************************/

/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/

/*****************************************************************************
**							  Public Declarations							**
*****************************************************************************/

/*****************************************************************************
**							   Public Prototypes							**
*****************************************************************************/

uint32 GenerateCRC( const char *stream, int size );
uint32 GenerateCRCCaseSensitive( const char *stream, int size );
uint32 UpdateCRC( const char *p_stream, int size, uint32 rc=0xffffffff );
uint32 GenerateCRCFromString( const char *pName );
uint32 ExtendCRCWithString( uint32 rc, const char *pName );
uint32 GetCRCTableEntry( int entry );

/*****************************************************************************
**								Inline Functions							**
*****************************************************************************/

} // namespace Crc

#endif // __CORE_CRC_H

