/*****************************************************************************
**																			**
**					   	  Neversoft Entertainment							**
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		Core Library											**
**																			**
**	Module:			Standard Header											**
**																			**
**	File name:		core/TimestampedFlag.h									**
**																			**
**	Created:		3/3/3	-	Dan											**
**																			**
*****************************************************************************/

#ifndef __CORE_TIMESTAMPEDFLAG_H
#define __CORE_TIMESTAMPEDFLAG_H

/*****************************************************************************
**								   Includes									**
*****************************************************************************/
	
#include <sys/timer.h>

/*****************************************************************************
**								   Defines									**
*****************************************************************************/


/*****************************************************************************
**							Class Definitions								**
*****************************************************************************/

/************************************************************************
 *																		*
 * Class:			TimestampedFlag										*
 *																		*
 * Description:		Flag which remembers the time of its last			*
 *					modification 						 				*
 *					Extracted from skater.h								*
 *																		*
 *																		*
 ***********************************************************************/

class CTimestampedFlag : public Spt::Class
{
public:
	void			Set ( bool state );
	void			SetTrue (   );
	void			SetFalse (   );
	void			Toggle (   );
	
	bool			Get (   );
	Tmr::Time		GetTime (   );
	Tmr::Time		GetElapsedTime (   );
	
					operator bool (   ) { return Get(); }
	
private:
	bool			m_state;		// flag state
	Tmr::Time		m_time;			// time of last state change
};

/*****************************************************************************
**							 Private Declarations							**
*****************************************************************************/


/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/


/*****************************************************************************
**							  Public Declarations							**
*****************************************************************************/


/*****************************************************************************
**							   Public Prototypes							**
*****************************************************************************/


/*****************************************************************************
**								Inline Functions							**
*****************************************************************************/

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline void			CTimestampedFlag::Set ( bool state )
{
	if (m_state == state)
	{
		return;
	}
	
	m_state = state;
	m_time  = Tmr::GetTime();
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline void			CTimestampedFlag::SetTrue (   )
{
	Set(true);
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline void			CTimestampedFlag::SetFalse (   )
{
	Set(false);
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline void			CTimestampedFlag::Toggle (   )
{
	Set(!m_state);	
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline bool			CTimestampedFlag::Get (   )
{
	return m_state;
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline Tmr::Time	CTimestampedFlag::GetTime (   )
{
	return m_time;
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline Tmr::Time	CTimestampedFlag::GetElapsedTime (   )
{
	return Tmr::GetTime() - GetTime();
	
}

#endif	//	__CORE_TIMESTAMPEDFLAG_H





