/*
	TreeView.cpp
	A class to encapsulate TreeView control functionality
	12-12-01
*/

#include "TreeView.h"

////////// TVItem class

TVItem* TVItem::GetParent()
{
	TVItem newItem;
	newItem.tree=tree;
	newItem.hTreeItem=TreeView_GetParent(tree->hwnd,hTreeItem);

	return &(tree->litems.Add(&newItem)->data);
}

TVItem* TVItem::AddItem(char* FieldName,void* pData,int flags)
{
	TVItem newItem;
	newItem.tree=tree;

	TVINSERTSTRUCT insertData;

	if (flags & TV_SORT)
		insertData.hInsertAfter=TVI_SORT;
	else
		insertData.hInsertAfter=TVI_LAST;

	insertData.hParent            =hTreeItem;
	insertData.item.mask          =TVIF_TEXT|TVIF_PARAM;
	//insertData.item.hItem         =
	//insertData.item.state         =
	//insertData.item.stateMask     =
	insertData.item.pszText       =FieldName;
	insertData.item.cchTextMax    =strlen(FieldName);
	//insertData.item.iImage        =
	//insertData.item.iSelectedImage=
	//insertData.item.cChildren     =
	insertData.item.lParam        =(LPARAM)pData;
	//insertData.item.iIntegral     =   

	newItem.hTreeItem=(HTREEITEM)SendMessage(tree->hwnd,TVM_INSERTITEM,0,(LPARAM)&insertData);
	Link<TVItem>* link=tree->litems.Add(&newItem);

	if (tree->items.GetItem(FieldName))
		tree->items.FlushItem(FieldName);

	tree->items.PutItem(FieldName,&link->data);

	return &(link->data);
}

////////// TreeView class

TreeView::TreeView(HINSTANCE hInstance,HWND hwndTreeView) :
	items(8)
{
	this->hInstance=hInstance;
	hwnd=hwndTreeView;

	ID=(int)GetWindowLong(hwndTreeView,GWL_ID);

	SelChangeFunc=NULL;
}

TreeView::~TreeView()
{
	//int size,i;
	//TVItem* curItem;

	// Clear out the data in the hash table
	/*  Unneeded (handled automatically by link list
	size=items.GetSize();
	items.IterateStart();

	for(i=0;i<size;i++)
	{
		curItem=items.IterateNext();
		delete curItem;
	}
	*/

	// DeSubClass the parent window
	
}

BOOL TreeView::ProcMessage(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	// First ensure that this message is actually for us
	// (in case the parent processing screwed up, or I later subclass it)
	switch(msg)
	{
	case WM_NOTIFY:
		if (wParam==ID)
		{
			NMTREEVIEW* tvdata=(NMTREEVIEW*)lParam;

			if (tvdata->action==TVN_SELCHANGED)
			{
				if (SelChangeFunc)
					SelChangeFunc(this);

				return TRUE;
			}
		}
	}

	return FALSE;
}

void* TreeView::GetSelection()
{
	HTREEITEM hItem;
	TVITEM    item;

	hItem=TreeView_GetSelection(hwnd);

	item.mask =TVIF_PARAM;
	item.hItem=hItem;

	if (TreeView_GetItem(hwnd,&item))
		return (void*)item.lParam;
	
	return NULL;
}

TVItem* TreeView::AddField(char* FieldName,void* pData,char* ParentName,int flags)
{
	TVItem*        tviParent;
	TVINSERTSTRUCT insertData;

	if (ParentName)
	{
		tviParent=items.GetItem(ParentName);

		// Couldn't find parent in hash table
		if (!tviParent)
			return NULL;

		insertData.hParent=tviParent->hTreeItem;
	}
	else
		insertData.hParent=NULL;

	TVItem newItem;
	newItem.tree=this;

	if (flags & TV_SORT)
		insertData.hInsertAfter=TVI_SORT;
	else
		insertData.hInsertAfter=TVI_LAST;


	insertData.item.mask          =TVIF_TEXT;
	//insertData.item.hItem         =
	//insertData.item.state         =
	//insertData.item.stateMask     =
	insertData.item.pszText       =FieldName;
	insertData.item.cchTextMax    =strlen(FieldName);
	//insertData.item.iImage        =
	//insertData.item.iSelectedImage=
	//insertData.item.cChildren     =
	insertData.item.lParam        =(LPARAM)pData;
	//insertData.item.iIntegral     =   

	newItem.hTreeItem=(HTREEITEM)SendMessage(hwnd,TVM_INSERTITEM,0,(LPARAM)&insertData);	
	Link<TVItem>* link=litems.Add(&newItem);

	if (items.GetItem(FieldName))
		items.FlushItem(FieldName);
	
	items.PutItem(FieldName,&link->data);

	return &(link->data);
}

TVItem* TreeView::AddField(TVItem* tviParent,char* FieldName,void* pData,int flags)
{
	TVItem newItem;
	newItem.tree=this;

	TVINSERTSTRUCT insertData;

	if (flags & TV_SORT)
		insertData.hInsertAfter=TVI_SORT;
	else
		insertData.hInsertAfter=TVI_LAST;

	insertData.hParent            =tviParent->hTreeItem;	
	insertData.item.mask          =TVIF_TEXT;
	
	//insertData.item.hItem         =
	//insertData.item.state         =
	//insertData.item.stateMask     =
	insertData.item.pszText       =FieldName;
	insertData.item.cchTextMax    =strlen(FieldName);
	//insertData.item.iImage        =
	//insertData.item.iSelectedImage=
	//insertData.item.cChildren     =
	insertData.item.lParam        =(LPARAM)pData;
	//insertData.item.iIntegral     =   

	newItem.hTreeItem=(HTREEITEM)SendMessage(hwnd,TVM_INSERTITEM,0,(LPARAM)&insertData);	
	Link<TVItem>* link=litems.Add(&newItem);

	if (items.GetItem(FieldName))
		items.FlushItem(FieldName);
	
	items.PutItem(FieldName,&link->data);

	return &(link->data);
}

void TreeView::DisableRedraw()
{
	SendMessage(hwnd,WM_SETREDRAW,FALSE,0);
}

void TreeView::EnableRedraw()
{
	SendMessage(hwnd,WM_SETREDRAW,TRUE,0);
}

void TreeView::DeleteField(TVItem* tvitem)
{
	TreeView_DeleteItem(hwnd,tvitem->hTreeItem);
}

void TreeView::SetItemData(TVItem* tvitem,void* val)
{
	TVITEM tvitm;
	tvitm.mask=TVIF_HANDLE|TVIF_PARAM;
	tvitm.hItem=tvitem->hTreeItem;
	tvitm.lParam=(LPARAM)val;
	TreeView_SetItem(hwnd,&tvitm);
}

void* TreeView::GetItemData(TVItem* tvitem)
{
	TVITEM tvitm;
	tvitm.mask=TVIF_HANDLE|TVIF_PARAM;
	tvitm.hItem=tvitem->hTreeItem;
	TreeView_GetItem(hwnd,&tvitm);

	return (void*)tvitm.lParam;
}
