/*
	SlideNum.h
	Slider Number UI
	A slider UI with an attached label displaying it's value
*/

#ifndef __SLIDERNUM__
#define __SLIDERNUM__

#include "max.h"
#include "UIControl.h"

#define SLIDENUM_CLASSNAME "SlideNum"

class SliderNum: public UIControl
{
	enum Mode
	{
		MODE_FLOAT,
		MODE_INT,
	};

	union
	{
		int   imin;
		float fmin;
	};
	
	union
	{
		int   imax;
		float fmax;
	};

	union
	{
		int   iincr;
		float fincr;
	};

	HWND            hwndSlider;		// The slider UI control
	HWND            hwndEdit;		// The label/static control
	ISliderControl* ISlider;
	Mode            mode;
	BOOL            bLockChange;

	LRESULT WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);
	void    BuildControlUI();
	HWND    GetFocusWindow();

public:
	CLASSNAME(SLIDENUM_CLASSNAME)

	SliderNum(HINSTANCE hInstance);
	SliderNum(HINSTANCE hInstance, HWND hwnd);
	~SliderNum();

	SliderNum(SliderNum& right);
	SliderNum& operator = (SliderNum& right);
	
	void SetLimits(int min,int max);
	void SetLimits(float min,float max);
	void SetMode(Mode mode);
	
	int   GetValue();
	void  SetValue(int val);
};

#endif
