/*
	MSWindow.h

	Getting sick of writting windows redirect message sinks
	Future windows will derive from this yclass
	Will gradually phase out old method

	NOTE: Your sink will not recieve WM_CREATE or WM_INITDIALOG
	      But, it shouldn't need to since you can do it in a constructor now
		  You are also restricted from using the Window's USERDATA, but again
		  in a class there's no need for it.

	Adam Lippmann
	12-20-01
*/

#ifndef __MSWINDOW__
#define __MSWINDOW__

#include <windows.h>

class MSWindow
{
	static LRESULT CALLBACK RedirectWndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
	{
		MSWindow* thisclass=(MSWindow*)GetWindowLong(hwnd,GWL_USERDATA);

		if (thisclass)
			return thisclass->WndProc(hwnd,msg,wParam,lParam);

		return DefWindowProc(hwnd,msg,wParam,lParam);
	}

protected:
	HWND hwnd;

	inline virtual LRESULT WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
	{
		return DefWindowProc(hwnd,msg,wParam,lParam);
	}

public:
	MSWindow(WNDCLASS* wndclass,
		     LPCTSTR   lpWindowName,
			 DWORD     dwStyle,
			 int       x,
			 int       y,
			 int       nWidth,
			 int       nHeight,
			 HWND      hWndParent,
			 HMENU     hMenu,
			 HINSTANCE hInstance)
	{
		wndclass->lpfnWndProc=RedirectWndProc;
		RegisterClass(wndclass);

		hwnd=CreateWindow(wndclass->lpszClassName,
			              lpWindowName,
						  dwStyle,
						  x,
						  y,
						  nWidth,
						  nHeight,
						  hWndParent,
						  hMenu,
						  hInstance,
						  NULL);

		SetWindowLong(hwnd,GWL_USERDATA,(LONG)this);
	};

	~MSWindow()
	{
		DestroyWindow(hwnd);
	}

	inline void Show() { ShowWindow(hwnd,SW_SHOW); }
	inline void Hide() { ShowWindow(hwnd,SW_HIDE); }
	inline HWND hWnd() { return hwnd; }
};

class MSDlgWindow
{
	void (*CloseCB)(MSDlgWindow*,void*);	// Function to call when window is closed
	void* pCloseCBData;						// Retained dawta to pass to callback

	static BOOL CALLBACK RedirectDlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
	{
		MSDlgWindow* thisclass=(MSDlgWindow*)GetWindowLong(hwnd,GWL_USERDATA);

		if (thisclass)
		{
			if (msg == WM_CLOSE)
			{
				BOOL rVal = thisclass->DlgProc(hwnd,msg,wParam,lParam);

				if (thisclass->CloseCB)
					thisclass->CloseCB(thisclass,thisclass->pCloseCBData);

				return rVal;
			}

			return thisclass->DlgProc(hwnd,msg,wParam,lParam);
		}

		return FALSE;
	}

protected:
	HWND hwnd;

	inline virtual BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
	{
		return FALSE;
	}

public:
	MSDlgWindow(HINSTANCE hInstance,
		        LPCTSTR   lpTemplate,
				HWND      hWndParent,
				bool      bAlwaysOnTop = false)
	{
		hwnd=CreateDialog(hInstance,lpTemplate,hWndParent,RedirectDlgProc);
		SetWindowLong(hwnd,GWL_USERDATA,(LONG)this);
		
		if (bAlwaysOnTop)
		{
			RECT rect;
			GetWindowRect(hwnd, &rect);
			SetWindowPos(hwnd, 
				         HWND_TOPMOST, 
						 rect.left,
						 rect.top, 
						 rect.right - rect.left, 
						 rect.bottom - rect.top,
						 SWP_NOMOVE | SWP_NOSIZE | SWP_NOREDRAW);
		}

		CloseCB = NULL;
		pCloseCBData = NULL;
	}

	~MSDlgWindow()
	{
		//EndDialog(hwnd,0);
		DestroyWindow(hwnd);
		SetWindowLong(hwnd,GWL_USERDATA,NULL);
	}

	void SetCloseCB(void(*func)(MSDlgWindow*,void*),void* pData)
	{
		CloseCB = func;
		pCloseCBData = pData;
	}

	inline void Show() { ShowWindow(hwnd,SW_SHOW); }
	inline void Hide() { ShowWindow(hwnd,SW_HIDE); }
	inline HWND hWnd() { return hwnd; }
};

#endif
