/*
	ListView.h
	Management class for ListView controls

	1-7-01
*/

#ifndef LISTVIEW_H
#define LISTVIEW_H

#include <windows.h>
#include <commctrl.h>

class ListView
{
	HWND hwnd;		// The ListView window
	int  numCol;	// Number of columns in the ListView control
	int  numItems;	// Number of items in the ListView control

	int  curCol;	// The current column we're adding to
	int  curRow;	// The current row we're adding to

	int(*fpSort)(DWORD,DWORD,ListView*,void*);	// Function used to sort the list
	void* pSortData;							// Callback retained data

	static int CALLBACK Compare(LPARAM lParam1,LPARAM lParam2,LPARAM lParamSort);

public:
	ListView(HWND hwnd);
	~ListView();

	bool  AddColumn(char* colName,int colWidth=100);
	int   AddItem(char* name,int rowIndex=-1);
	void  GetItem(int index,char* name,int size,int subitem=0);
	int   AddSubItem(char* name,int colIndex=-1,int rowIndex=-1);
	void  DeleteItem(int index);
	int   GetSel();
	int   GetSelItem();
	void  SetSel(int index);
	int   GetSelCount();
	int   GetSelCountExplicit();
	int   GetCount();
	int   GetNextItem(int lastindex,char* name,int size);
	void  Clear();
	int   Find(char* name, int field=0);
	void  SelectWildcard(char* wildcard);

	void  SetItemData(int index,DWORD val);
	DWORD GetItemData(int index);

	int  HitTest(int x,int y);		// Retrieves the index at given client position
	void Update(int index);

	void Select(int index);			// Selects an item
	void UnSelect(int index);		// UnSelects an item
	void UnSelectAll();				// UnSelects all items in the control
	bool IsSelected(int index);		// Retrieves item selection

	void Sort(int(*fpCompare)(DWORD,DWORD,ListView* pData,void* pExtData),void* pSortData=NULL);
	void ScrollToItem(int index);
};

#endif
