/*
	TrigSnap.cpp
	This is a custom snap plugin for the Trigger Objects that will snap
	from their center point
	aml - 9-30-02
*/

#include "max.h"
#include "osnapapi.h"
#include "../Trigger/Trigger.h"
#include "TriggerSnapData.h"
#include "resource.h"

#define vTRGSNAP_CLASS_ID   Class_ID(0x40164ee4, 0x48f90131)
#define NOSUB -1
#define PIV_SUB 0
#define BBOX_SUB 1

static TSTR strSnapName("NSTrigger Snap");

//#define SNAP_TO_CENTER

class TriggerSnap : public Osnap {

private:
	OsnapMarker markerdata;
	HBITMAP tools;
	HBITMAP masks;

public:

	TriggerSnap();//constructor
	virtual ~TriggerSnap();

	virtual int numsubs(){return 1;} //the number of subsnaps this guy has
	virtual TSTR *snapname(int index); // the snaps name to be displayed in the UI
	virtual boolean ValidInput(SClass_ID scid, Class_ID cid);// supports anything 
	Class_ID ClassID() { return vTRGSNAP_CLASS_ID; }

	virtual OsnapMarker *GetMarker(int index){return &markerdata;} 
	virtual HBITMAP getTools(){return tools;} 
	virtual HBITMAP getMasks(){return masks;} 
	virtual WORD HiliteMode(){return HILITE_BOX;}
	virtual WORD AccelKey(int index); //virtual key codes
	virtual void Snap(Object* pobj, IPoint2 *p, TimeValue t);
};

class TRGSnapClassDesc:public ClassDesc {
	public:
	int 			IsPublic() { return 0; }
	void *			Create(BOOL loading = FALSE) {return new TriggerSnap();}
	const TCHAR *	ClassName() { return _T("TriggerSnap"); }
	SClass_ID		SuperClassID() { return OSNAP_CLASS_ID; }
	Class_ID		ClassID() { return vTRGSNAP_CLASS_ID; }
	const TCHAR* 	Category() { return _T(""); }
	};

// Declare a static instance of the class descriptor.
static TRGSnapClassDesc TRGSnapDesc;
ClassDesc* GetTriggerSnapDesc() { return &TRGSnapDesc; }

TSTR *TriggerSnap::snapname(int index){
	switch(index)
	{
	case 0:
		return &strSnapName;
	}

	return NULL;
}


WORD TriggerSnap::AccelKey(int index){
	// Method is no longer used
	return 0;
}


TriggerSnap::TriggerSnap()
{
	tools = LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_TRGICON));
	masks = LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_TRGMASK));
	markerdata = OsnapMarker(5,TRGmark0verts,TRGmark0es);
};

TriggerSnap::~TriggerSnap()
{
	DeleteObject(tools);
	DeleteObject(masks);
}

boolean TriggerSnap::ValidInput(SClass_ID scid, Class_ID cid){

	//JH 6/17/99
	//The implementation of the snap manager assumes that any nodes which record hits
	//will still be around when the scenetraversal ends. With the introduction of autogrid
	//this assumption is clearly wrong since the temporary grid object comes and goes.
	//The short term fix is to avoid snapping to these grid objects.
	if(theman->GetNode() == GetCOREInterface()->GetActiveGrid())
		return FALSE;

	if (cid == vTRIGGER_CLASS_ID)
		return TRUE;

	return FALSE;

	/*
	if (cid == vLINK_OBJ_CLASS_ID)	// Don't snap to the link objects
		return FALSE;

	boolean c_ok = FALSE, sc_ok = FALSE;
	sc_ok |= (scid == GEOMOBJECT_CLASS_ID)? TRUE : FALSE;
	sc_ok |= (scid == SHAPE_CLASS_ID)? TRUE : FALSE;
	sc_ok |= (scid == CAMERA_CLASS_ID)? TRUE : FALSE;
	sc_ok |= (scid == LIGHT_CLASS_ID)? TRUE : FALSE;
	sc_ok |= (scid == HELPER_CLASS_ID)? TRUE : FALSE;
//	c_ok |= (cid == Class_ID(0xe44f10b3,0))? TRUE : FALSE; 

	return sc_ok;
	*/
}

static BOOL EssentiallyEmpty(Box3 &box)
{
	Point3 p2(0.01f,0.01f,0.01f);
	Point3 p1(-0.01f,-0.01f,-0.01f);
	if(box.pmin == p1 && box.pmax == p2)
		return TRUE;
	return FALSE;
}

void TriggerSnap::Snap(Object* pobj, IPoint2 *p, TimeValue t)
{	
	// This snap computes the bounding box points of a node as 
	// well as the pivot point

	//local copy of the cursor position
	Point2 fp = Point2((float)p->x, (float)p->y);

	//In this snap mode we actually need to get a pointer to the node so that we 
	// can check for WSM's and compute the pivot point
	INode *inode = theman->GetNode();
	Matrix3 atm; //This will hold the nodes tm before WSMs

	//See if this guys has any spacewarps applied
	BOOL wsm = (BOOL) inode->GetProperty(PROPID_HAS_WSM);

	//If it does then we'll need to get a meaningful tm as follows
	if(wsm)
		atm = inode->GetObjTMBeforeWSM(t);

	//get the node's bounding box
	Box3 box;
	box.Init();
	pobj->GetDeformBBox(t, box, NULL );

	if(EssentiallyEmpty(box))
		pobj->GetLocalBoundBox(t, inode, theman->GetVpt() , box);

		//We need a hitmesh which shows the bounding box of the node
	//This automatic variable gets passed to the hitmesh copy constructor
	// in every case
	HitMesh thehitmesh, *phitmesh;
	//thehitmesh.setNumVerts(1);
	thehitmesh.setNumVerts(8);
	for(int jj = 0;jj<8;++jj)
		thehitmesh.setVert(jj,box[jj]);

#ifdef SNAP_TO_CENTER
	// Compute center from hit mesh
	Point3 min, max;
	
	min = box[0];
	max = box[0];

	for(int i = 0; i < 8; i++)
	{
		if (box[i].x < min.x)
			min.x = box[i].x;

		if (box[i].y < min.y)
			min.y = box[i].y;

		if (box[i].z < min.z)
			min.z = box[i].z;

		if (box[i].x > max.x)
			max.x = box[i].x;

		if (box[i].y > max.y)
			max.y = box[i].y;

		if (box[i].z > max.z)
			max.z = box[i].z;
	}

	Point3 center(0,0,0);
	//center.x = (max.x - min.x) / 2.0f;
	center.y = (max.y - min.y) / 2.0f;
	center.z = -(max.z - min.z) / 2.0f;

	//center = -center;
#else
	Point3 center(0,0,0);

#endif

	BOOL got_one= FALSE;

	//Compute all the hit point candidates
	{
		got_one = FALSE;
		Point3 *pivpt;

		if(wsm)
			pivpt = new Point3(atm.GetTrans() - inode->GetObjOffsetPos());
		else
			pivpt = new Point3(-inode->GetObjOffsetPos());

		//Make a hitmesh
		phitmesh = new HitMesh(thehitmesh);

		*pivpt = -center;

		//now register a hit with the osnap manager
		theman->RecordHit(new OsnapHit(*pivpt, this, 0, NULL));
	}
}
