/*
	ViewportTexture.cpp
	Viewport texture provides a class tailored so that materials can provide
	their own representations for the Interactive Viewport Renderer
	aml  5-28-01
*/

#include "ViewportTexture.h"

class ViewportTexClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() { return 1; }
	void *			Create(BOOL loading) { return new ViewportTexture(); }
//	{ 	return new BMTex; }
	const TCHAR *	ClassName() { return "NExt Viewport Texture"; } // mjm - 2.3.99
	SClass_ID		SuperClassID() { return TEXMAP_CLASS_ID; }
	Class_ID 		ClassID() { return NEXT_VIEWPORTTEX_CLASS_ID; }
	const TCHAR* 	Category() { return TEXMAP_CAT_2D;  }
// PW: new descriptor data accessors added.  Note that the 
//      internal name is hardwired since it must not be localized.
	const TCHAR*	InternalName() { return _T("NExt Viewport Texture"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }			// returns owning module handle

	};

static ViewportTexClassDesc next_viewporttex_cd;

ClassDesc2* GetNExtViewportTexDesc() { return &next_viewporttex_cd;  }

ViewportTexture::ViewportTexture()
{
	tmaps = new Texmap*[vMAX_MATERIAL_PASSES];
	thebm = NULL;	
}

ViewportTexture::ViewportTexture(int nmaps)
{
	tmaps = new Texmap*[nmaps];
	thebm = NULL;
}

ViewportTexture::~ViewportTexture()
{
	delete [] tmaps;
}

void ViewportTexture::AssignBitmap(Bitmap* bmp)
{
	thebm = bmp;
}

DWORD_PTR ViewportTexture::GetActiveTexHandle(TimeValue t, TexHandleMaker& thmaker) {
// Debugging DON'T CACHE
	//	if (texHandle&&texTime==CalcFrame(t)&&texValid.InInterval(t)) 
//		return texHandle->GetHandle();
//	else {
		DiscardTexHandle();  
		texTime = CalcFrame(t);
		texHandle = thmaker.MakeHandle(GetVPDisplayDIB(t,thmaker,texValid));  
		return texHandle->GetHandle();
//		}
	}

BITMAPINFO* ViewportTexture::GetVPDisplayDIB(TimeValue t, TexHandleMaker& thmaker, Interval &valid, BOOL mono, BOOL forceW, BOOL forceH)
{
	// TODO: WARNING Need to add Bitmap creation
	//LoadBitmap(t);
	valid = FOREVER;

	if (thebm == NULL)
		return NULL;

	/*
	if (thebm==NULL) {
		return NULL;
		}
	*/
//BitmapInfo
//	bi.
//	thebm = TheManager->Load(

	BITMAPINFO *bmi = NULL;

	//int xflags = premultAlpha?0:EX_MULT_ALPHA;

	//if (mono&&alphaAsMono) xflags |= EX_RGB_FROM_ALPHA;
	//if (alphaAsRGB) xflags |= EX_RGB_FROM_ALPHA;
	//if (alphaSource==ALPHA_NONE) xflags |= EX_OPAQUE_ALPHA;
	//if (alphaSource==ALPHA_RGB) xflags |= EX_ALPHA_FROM_RGB;

	//bmi = thmaker.BitmapToDIB(thebm,uvGen->SymFlags(), xflags, forceW, forceH);
	//bmi = thmaker.BitmapToDIB(thebm,uvGen->SymFlags(), 0, forceW, forceH);
	bmi = thmaker.BitmapToDIB(thebm,0, 0, forceW, forceH);

	// Crazy test.  Post-modify image
	/*
	BITMAPINFOHEADER* bmih = &bmi->bmiHeader;
	char* imgBuf = (char*)bmi;
	imgBuf += sizeof(BITMAPINFO);
	for(int i=1;i<bmih->biWidth*bmih->biHeight*4-1;i++)
	{
		//imgBuf[i] = imgBuf[i] * rand()/1000;
		imgBuf[i] = (imgBuf[i-1] + imgBuf[i+1])/2;
	}
	// End Crazy test
	*/

	

	return bmi;
}
