/*
	PropMerge.h
	Property merging dialog
*/

#ifndef __PROPMERGE__
#define __PROPMERGE__

#include "../UI/MSWindow.h"
#include "configdata.h"

class MultiList;
class PropList;

class PropMergeDlg: public MSDlgWindow
{
	LinkList<ConfigClass>* configDB;

	MultiList*  mlistClass;
	MultiList*  mlistType;
	ICustEdit*  IEdit;
	
	void(*fpPropMergeCB)(PropMergeDlg*,void*);		// Callback called when the merge button is pressed
	void* pData;									// Retained data for the callback

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);
	void ProcMerge();
	void ClassChange();
	void TypeChange();
	void UpdateCategory();

public:
	PropMergeDlg(HINSTANCE hInstance,HWND hwndParent,
		         LinkList<ConfigClass>* configDB,
				 void(*fpPropMergeCB)(PropMergeDlg*,void*),
				 void* pData);
	~PropMergeDlg();

	CStr GetClass();
	CStr GetType();
	CStr GetCat();

	void ResetProps();
};

#endif
