/*
	PropBufGen.h
	Property Buffer Generator
	2-13-01
*/

#ifndef __PROPBUFGEN__
#define __PROPBUFGEN__

#include "max.h"
#include "../misc/llist.h"
#include "ConfigData.h"
#include "ScriptIniParser.h"

class PropBufGen: public ScriptIniParser
{
public:
	PropBufGen();
	~PropBufGen();

	CStr BuildPropBuffer(INode* node,
		                 CStr   strClass,
		                 CStr   strType,
						 DWORD  flags,
						 LinkList<ConfigProp>* props,
						 CStr   strCmds,
						 CStr   strScript,
						 CStr   strCluster,
						 LinkList<ConfigProgram>* programs,
						 LinkList<ConfigScript>* scripts=NULL,
						 bool   bConvertToDefaultDelim=true);

	inline void DumpNode(INode* node,
				         CStr   strClass,
				         CStr   strType,
				         DWORD  flags,
				         LinkList<ConfigProp>* props,
				         CStr   strCmds,
				         CStr   strScript,
				         CStr   strCluster,
						 LinkList<ConfigProgram>* programs,
						 LinkList<ConfigScript>* scripts)
	{
		node->SetUserPropBuffer(BuildPropBuffer(node,
			                                    strClass,
			                                    strType,
												flags,
												props,
												strCmds,
												strScript,
												strCluster,
												programs,
												scripts));
	}

	CStr GetClassProp(INode* node);
	CStr GetTypeProp(INode* node);

	// Scans the property buffer for any script files that have been requested to be generated
	// through script contexts (altscript directives)
	void ParseReqScripts(LinkList<CStr>* list,CStr& propBuffer);
	bool AssignAltBuf(INode* node,CStr bufName,CStr buf);
	void RemoveAltBuf(INode* node,CStr bufName);
	CStr GetAltBuf(INode* node,CStr bufName);
	CStr GetMetaCmds(CStr buf);

	static void BuildList(LinkList<CStr>* list, CStr buf, bool bShaveEntries = true);
	static bool BuildList(CStr Filename,LinkList<CStr>* list);
	static CStr BuildBuf(LinkList<CStr>* list);
	static CStr BuildBufCRLF(LinkList<CStr>* list);

	CStr BuildPartialList(LinkList<CStr>* list,Link<CStr>* start=0,Link<CStr>* end=0);

	CStr CombinePropBuffers(CStr& buf1, CStr& buf2, CStr& strClass, CStr& strType, bool bConvertToDefaultDelim=true);
	CStr GetUniqueClassTypeRecord(CStr className, CStr typeName);
	
	CStr BuildTemplateBuffer(LinkList<ConfigProp>* cprops, CStr classTypeRec);
	CStr ProcessTemplateBuffer(LinkList<ConfigProp>* cprops, CStr tempBuf);
};

#endif
